/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.identity.IdentityObservableSet;
import org.eclipse.core.internal.databinding.identity.IdentitySet;
import org.eclipse.core.internal.databinding.property.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSimpleValueObservableMap<S, K, I extends S, V>
extends AbstractObservableMap<K, V>
implements IPropertyObservable<SimpleValueProperty<S, V>> {
    private IObservableMap<K, I> masterMap;
    private SimpleValueProperty<S, V> detailProperty;
    private IObservableSet<I> knownMasterValues;
    private Map<I, V> cachedValues;
    private Set<I> staleMasterValues;
    private boolean updating = false;
    private IMapChangeListener<K, I> masterListener = new IMapChangeListener<K, I>(){

        public void handleMapChange(MapChangeEvent<K, I> event) {
            if (!MapSimpleValueObservableMap.this.isDisposed()) {
                this.updateKnownValues();
                if (!MapSimpleValueObservableMap.this.updating) {
                    MapSimpleValueObservableMap.this.fireMapChange(this.convertDiff(event.diff));
                }
            }
        }

        private void updateKnownValues() {
            IdentitySet knownValues = new IdentitySet(MapSimpleValueObservableMap.this.masterMap.values());
            MapSimpleValueObservableMap.this.knownMasterValues.retainAll((Collection)knownValues);
            MapSimpleValueObservableMap.this.knownMasterValues.addAll((Collection)knownValues);
        }

        private MapDiff<K, V> convertDiff(MapDiff<? extends K, ? extends I> diff) {
            IdentityMap oldValues = new IdentityMap();
            IdentityMap newValues = new IdentityMap();
            HashSet addedKeys = new HashSet();
            for (Object key : diff.getAddedKeys()) {
                Object newSource = diff.getNewValue(key);
                Object newValue = MapSimpleValueObservableMap.this.detailProperty.getValue(newSource);
                newValues.put(key, newValue);
                addedKeys.add(key);
            }
            HashSet removedKeys = new HashSet();
            for (Object key : diff.getRemovedKeys()) {
                Object oldSource = diff.getOldValue(key);
                Object oldValue = MapSimpleValueObservableMap.this.detailProperty.getValue(oldSource);
                oldValues.put(key, oldValue);
                removedKeys.add(key);
            }
            IdentitySet changedKeys = new IdentitySet((Collection)diff.getChangedKeys());
            Iterator it = changedKeys.iterator();
            while (it.hasNext()) {
                Object newValue;
                Object key = it.next();
                Object oldSource = diff.getOldValue(key);
                Object newSource = diff.getNewValue(key);
                Object oldValue = MapSimpleValueObservableMap.this.detailProperty.getValue(oldSource);
                if (Util.equals(oldValue, newValue = MapSimpleValueObservableMap.this.detailProperty.getValue(newSource))) {
                    it.remove();
                    continue;
                }
                oldValues.put(key, oldValue);
                newValues.put(key, newValue);
            }
            return Diffs.createMapDiff(addedKeys, removedKeys, (Set)changedKeys, (Map)oldValues, (Map)newValues);
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        public void handleStale(StaleEvent staleEvent) {
            MapSimpleValueObservableMap.this.fireStale();
        }
    };
    private INativePropertyListener<S> detailListener;
    private Set<Map.Entry<K, V>> entrySet;

    public MapSimpleValueObservableMap(IObservableMap<K, I> map, SimpleValueProperty<S, V> valueProperty) {
        super(map.getRealm());
        this.masterMap = map;
        this.detailProperty = valueProperty;
        ISimplePropertyListener listener = new ISimplePropertyListener<ValueDiff<V>>(){

            @Override
            public void handleEvent(final SimplePropertyEvent<ValueDiff<V>> event) {
                if (!MapSimpleValueObservableMap.this.isDisposed() && !MapSimpleValueObservableMap.this.updating) {
                    MapSimpleValueObservableMap.this.getRealm().exec(new Runnable(){

                        public void run() {
                            Object source = event.getSource();
                            if (event.type == SimplePropertyEvent.CHANGE) {
                                MapSimpleValueObservableMap.this.notifyIfChanged(source);
                            } else if (event.type == SimplePropertyEvent.STALE) {
                                boolean wasStale = !MapSimpleValueObservableMap.this.staleMasterValues.isEmpty();
                                MapSimpleValueObservableMap.this.staleMasterValues.add(source);
                                if (!wasStale) {
                                    MapSimpleValueObservableMap.this.fireStale();
                                }
                            }
                        }
                    });
                }
            }
        };
        this.detailListener = this.detailProperty.adaptListener(listener);
    }

    public Object getKeyType() {
        return this.masterMap.getKeyType();
    }

    public Object getValueType() {
        return this.detailProperty.getValueType();
    }

    protected void firstListenerAdded() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.knownMasterValues = new IdentityObservableSet(this.getRealm(), null);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        this.cachedValues = new IdentityMap();
        this.staleMasterValues = new IdentitySet();
        this.knownMasterValues.addSetChangeListener(new ISetChangeListener<I>(){

            public void handleSetChange(SetChangeEvent<I> event) {
                for (Object key : event.diff.getRemovals()) {
                    if (MapSimpleValueObservableMap.this.detailListener != null) {
                        MapSimpleValueObservableMap.this.detailListener.removeFrom(key);
                    }
                    MapSimpleValueObservableMap.this.cachedValues.remove(key);
                    MapSimpleValueObservableMap.this.staleMasterValues.remove(key);
                }
                for (Object key : event.diff.getAdditions()) {
                    MapSimpleValueObservableMap.this.cachedValues.put(key, MapSimpleValueObservableMap.this.detailProperty.getValue(key));
                    if (MapSimpleValueObservableMap.this.detailListener == null) continue;
                    MapSimpleValueObservableMap.this.detailListener.addTo(key);
                }
            }
        });
        this.getRealm().exec(new Runnable(){

            public void run() {
                MapSimpleValueObservableMap.this.knownMasterValues.addAll(MapSimpleValueObservableMap.this.masterMap.values());
                MapSimpleValueObservableMap.this.masterMap.addMapChangeListener(MapSimpleValueObservableMap.this.masterListener);
                MapSimpleValueObservableMap.this.masterMap.addStaleListener(MapSimpleValueObservableMap.this.staleListener);
            }
        });
    }

    protected void lastListenerRemoved() {
        this.masterMap.removeMapChangeListener(this.masterListener);
        this.masterMap.removeStaleListener(this.staleListener);
        if (this.knownMasterValues != null) {
            this.knownMasterValues.dispose();
            this.knownMasterValues = null;
        }
        this.cachedValues.clear();
        this.cachedValues = null;
        this.staleMasterValues.clear();
        this.staleMasterValues = null;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.getterCalled();
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public boolean containsKey(Object key) {
        this.getterCalled();
        return this.masterMap.containsKey(key);
    }

    public V get(Object key) {
        this.getterCalled();
        return (V)this.detailProperty.getValue(this.masterMap.get(key));
    }

    public V put(K key, V value) {
        if (!this.masterMap.containsKey(key)) {
            return null;
        }
        Object masterValue = this.masterMap.get(key);
        Object oldValue = this.detailProperty.getValue(masterValue);
        this.detailProperty.setValue(masterValue, value);
        this.notifyIfChanged(masterValue);
        return (V)oldValue;
    }

    public V remove(Object key) {
        this.checkRealm();
        Object masterValue = this.masterMap.get(key);
        Object oldValue = this.detailProperty.getValue(masterValue);
        this.masterMap.remove(key);
        return (V)oldValue;
    }

    private void notifyIfChanged(I masterValue) {
        if (this.cachedValues != null) {
            Object newValue;
            final Set<K> keys = this.keysFor(masterValue);
            final V oldValue = this.cachedValues.get(masterValue);
            if (!Util.equals(oldValue, newValue = this.detailProperty.getValue(masterValue)) || this.staleMasterValues.contains(masterValue)) {
                this.cachedValues.put(masterValue, newValue);
                this.staleMasterValues.remove(masterValue);
                this.fireMapChange(new MapDiff<K, V>(){

                    public Set<K> getAddedKeys() {
                        return Collections.emptySet();
                    }

                    public Set<K> getChangedKeys() {
                        return keys;
                    }

                    public Set<K> getRemovedKeys() {
                        return Collections.emptySet();
                    }

                    public V getNewValue(Object key) {
                        return newValue;
                    }

                    public V getOldValue(Object key) {
                        return oldValue;
                    }
                });
            }
        }
    }

    private Set<K> keysFor(I value) {
        IdentitySet keys = new IdentitySet();
        for (Map.Entry entry : this.masterMap.entrySet()) {
            if (entry.getValue() != value) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public boolean isStale() {
        this.getterCalled();
        return this.masterMap.isStale() || this.staleMasterValues != null && !this.staleMasterValues.isEmpty();
    }

    private void getterCalled() {
        ObservableTracker.getterCalled((IObservable)this);
    }

    public Object getObserved() {
        return this.masterMap;
    }

    @Override
    public SimpleValueProperty<S, V> getProperty() {
        return this.detailProperty;
    }

    public synchronized void dispose() {
        if (this.masterMap != null) {
            this.masterMap.removeMapChangeListener(this.masterListener);
            this.masterMap = null;
        }
        if (this.knownMasterValues != null) {
            this.knownMasterValues.clear();
            this.knownMasterValues.dispose();
            this.knownMasterValues = null;
        }
        this.masterListener = null;
        this.detailListener = null;
        this.detailProperty = null;
        this.cachedValues = null;
        this.staleMasterValues = null;
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<K, I>> it;
                {
                    this.it = MapSimpleValueObservableMap.this.masterMap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    MapSimpleValueObservableMap.this.getterCalled();
                    return this.it.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    MapSimpleValueObservableMap.this.getterCalled();
                    Map.Entry next = this.it.next();
                    return new MapEntry(next.getKey());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public int size() {
            return MapSimpleValueObservableMap.this.masterMap.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MapEntry
    implements Map.Entry<K, V> {
        private K key;

        MapEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            MapSimpleValueObservableMap.this.getterCalled();
            return this.key;
        }

        @Override
        public V getValue() {
            MapSimpleValueObservableMap.this.getterCalled();
            if (!MapSimpleValueObservableMap.this.masterMap.containsKey(this.key)) {
                return null;
            }
            return MapSimpleValueObservableMap.this.detailProperty.getValue(MapSimpleValueObservableMap.this.masterMap.get(this.key));
        }

        @Override
        public V setValue(V value) {
            if (!MapSimpleValueObservableMap.this.masterMap.containsKey(this.key)) {
                return null;
            }
            Object source = MapSimpleValueObservableMap.this.masterMap.get(this.key);
            Object oldValue = MapSimpleValueObservableMap.this.detailProperty.getValue(source);
            MapSimpleValueObservableMap.this.updating = true;
            try {
                MapSimpleValueObservableMap.this.detailProperty.setValue(source, value);
            }
            finally {
                MapSimpleValueObservableMap.this.updating = false;
            }
            MapSimpleValueObservableMap.this.notifyIfChanged(source);
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            MapSimpleValueObservableMap.this.getterCalled();
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Util.equals(this.getKey(), that.getKey()) && Util.equals(this.getValue(), that.getValue());
        }

        @Override
        public int hashCode() {
            MapSimpleValueObservableMap.this.getterCalled();
            Object value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
    }
}

