/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Collections;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Binding<M extends IObservable, T extends IObservable>
extends ValidationStatusProvider {
    protected DataBindingContext context;
    private T target;
    private M model;
    private IDisposeListener disposeListener;

    public Binding(T target, M model) {
        this.target = target;
        this.model = model;
    }

    public final void init(DataBindingContext context) {
        this.context = context;
        if (this.target.isDisposed()) {
            throw new IllegalArgumentException("Target observable is disposed");
        }
        if (this.model.isDisposed()) {
            throw new IllegalArgumentException("Model observable is disposed");
        }
        this.disposeListener = new IDisposeListener(){

            public void handleDispose(DisposeEvent staleEvent) {
                Binding.this.context.getValidationRealm().exec(new Runnable(){

                    public void run() {
                        if (!Binding.this.isDisposed()) {
                            Binding.this.dispose();
                        }
                    }
                });
            }
        };
        this.target.addDisposeListener(this.disposeListener);
        this.model.addDisposeListener(this.disposeListener);
        this.preInit();
        context.addBinding(this);
        this.postInit();
    }

    protected abstract void preInit();

    protected abstract void postInit();

    public abstract void updateTargetToModel();

    public abstract void updateModelToTarget();

    public abstract void validateTargetToModel();

    public abstract void validateModelToTarget();

    @Override
    public void dispose() {
        if (this.context != null) {
            this.context.removeBinding(this);
        }
        this.context = null;
        if (this.disposeListener != null) {
            if (this.target != null) {
                this.target.removeDisposeListener(this.disposeListener);
            }
            if (this.model != null) {
                this.model.removeDisposeListener(this.disposeListener);
            }
            this.disposeListener = null;
        }
        this.target = null;
        this.model = null;
        super.dispose();
    }

    void setDataBindingContext(DataBindingContext context) {
        this.context = context;
    }

    public T getTarget() {
        return this.target;
    }

    @Override
    public IObservableList<IObservable> getTargets() {
        return Observables.staticObservableList((Realm)this.context.getValidationRealm(), Collections.singletonList(this.target));
    }

    public M getModel() {
        return this.model;
    }

    @Override
    public IObservableList<IObservable> getModels() {
        return Observables.staticObservableList((Realm)this.context.getValidationRealm(), Collections.singletonList(this.model));
    }
}

