/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLookupSupport {
    private static HashMap<Class<?>, List<Class<?>>> classSearchOrderLookup;

    public static Class<?>[] getTypeHierarchyFlattened(Class<?> type) {
        List<Class<?>> classes = null;
        HashMap<Class<Object>, List<Class<Object>>> lookup = classSearchOrderLookup;
        if (lookup != null) {
            classes = lookup.get(type);
        }
        if (classes == null) {
            classes = new ArrayList();
            ClassLookupSupport.computeClassOrder(type, classes);
            if (lookup == null) {
                lookup = new HashMap();
                classSearchOrderLookup = lookup;
            }
            lookup.put(type, classes);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static void computeClassOrder(Class<?> adaptable, Collection<Class<?>> classes) {
        Class<Object> clazz = adaptable;
        HashSet seen = new HashSet(4);
        while (clazz != null) {
            classes.add(clazz);
            ClassLookupSupport.computeInterfaceOrder(clazz.getInterfaces(), classes, seen);
            Class clazz2 = clazz = clazz.isInterface() ? Object.class : clazz.getSuperclass();
        }
    }

    private static void computeInterfaceOrder(Class<?>[] interfaces, Collection<Class<?>> classes, Set<Class<?>> seen) {
        ArrayList newInterfaces = new ArrayList(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            Class<?> interfac = interfaces[i];
            if (seen.add(interfac)) {
                classes.add(interfac);
                newInterfaces.add(interfac);
            }
            ++i;
        }
        Iterator it = newInterfaces.iterator();
        while (it.hasNext()) {
            ClassLookupSupport.computeInterfaceOrder(((Class)it.next()).getInterfaces(), classes, seen);
        }
    }
}

