/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatedObservableMap<K, V>
extends ObservableMap<K, V> {
    private IObservableMap<K, V> target;
    private IObservableValue<IStatus> validationStatus;
    private boolean stale;
    private boolean computeNextDiff = false;
    private boolean updatingTarget = false;
    private IMapChangeListener<K, V> targetChangeListener = new IMapChangeListener<K, V>(){

        public void handleMapChange(MapChangeEvent<K, V> event) {
            if (ValidatedObservableMap.this.updatingTarget) {
                return;
            }
            IStatus status = (IStatus)ValidatedObservableMap.this.validationStatus.getValue();
            if (ValidatedObservableMap.isValid(status)) {
                if (ValidatedObservableMap.this.stale) {
                    ValidatedObservableMap.this.stale = false;
                    ValidatedObservableMap.this.updateWrappedMap(new HashMap(ValidatedObservableMap.this.target));
                } else {
                    MapDiff diff = event.diff;
                    if (ValidatedObservableMap.this.computeNextDiff) {
                        diff = Diffs.computeMapDiff((Map)ValidatedObservableMap.this.wrappedMap, (Map)ValidatedObservableMap.this.target);
                        ValidatedObservableMap.this.computeNextDiff = false;
                    }
                    ValidatedObservableMap.this.applyDiff(diff, ValidatedObservableMap.this.wrappedMap);
                    ValidatedObservableMap.this.fireMapChange(diff);
                }
            } else {
                ValidatedObservableMap.this.makeStale();
            }
        }
    };
    private IStaleListener targetStaleListener = new IStaleListener(){

        public void handleStale(StaleEvent staleEvent) {
            ValidatedObservableMap.this.fireStale();
        }
    };
    private IValueChangeListener<IStatus> validationStatusChangeListener = new IValueChangeListener<IStatus>(){

        public void handleValueChange(ValueChangeEvent<IStatus> event) {
            IStatus oldStatus = (IStatus)event.diff.getOldValue();
            IStatus newStatus = (IStatus)event.diff.getNewValue();
            if (ValidatedObservableMap.this.stale && !ValidatedObservableMap.isValid(oldStatus) && ValidatedObservableMap.isValid(newStatus)) {
                ValidatedObservableMap.this.stale = false;
                ValidatedObservableMap.this.updateWrappedMap(new HashMap(ValidatedObservableMap.this.target));
                ValidatedObservableMap.this.computeNextDiff = true;
            }
        }
    };

    public ValidatedObservableMap(IObservableMap<K, V> target, IObservableValue<IStatus> validationStatus) {
        super(target.getRealm(), new HashMap<K, V>(target));
        Assert.isNotNull(validationStatus, (String)"Validation status observable cannot be null");
        Assert.isTrue((boolean)target.getRealm().equals(validationStatus.getRealm()), (String)"Target and validation status observables must be on the same realm");
        this.target = target;
        this.validationStatus = validationStatus;
        target.addMapChangeListener(this.targetChangeListener);
        target.addStaleListener(this.targetStaleListener);
        validationStatus.addValueChangeListener(this.validationStatusChangeListener);
    }

    private void updateWrappedMap(Map<K, V> newMap) {
        Map oldMap = this.wrappedMap;
        MapDiff diff = Diffs.computeMapDiff((Map)oldMap, newMap);
        this.wrappedMap = newMap;
        this.fireMapChange(diff);
    }

    private static boolean isValid(IStatus status) {
        return status.isOK() || status.matches(3);
    }

    private void applyDiff(MapDiff<? extends K, ? extends V> diff, Map<K, V> map) {
        Iterator iterator = diff.getRemovedKeys().iterator();
        while (iterator.hasNext()) {
            map.remove(iterator.next());
        }
        for (Object key : diff.getChangedKeys()) {
            map.put(key, diff.getNewValue(key));
        }
        for (Object key : diff.getAddedKeys()) {
            map.put(key, diff.getNewValue(key));
        }
    }

    private void makeStale() {
        if (!this.stale) {
            this.stale = true;
            this.fireStale();
        }
    }

    private void updateTargetMap(MapDiff<K, V> diff) {
        this.updatingTarget = true;
        try {
            if (this.stale) {
                this.stale = false;
                this.applyDiff((MapDiff<? extends K, ? extends V>)Diffs.computeMapDiff(this.target, (Map)this.wrappedMap), (Map<K, V>)this.target);
            } else {
                this.applyDiff((MapDiff<? extends K, ? extends V>)diff, (Map<K, V>)this.target);
            }
        }
        finally {
            this.updatingTarget = false;
        }
    }

    public boolean isStale() {
        this.getterCalled();
        return this.stale || this.target.isStale();
    }

    public void clear() {
        this.checkRealm();
        if (this.isEmpty()) {
            return;
        }
        MapDiff diff = Diffs.computeMapDiff((Map)this.wrappedMap, Collections.emptyMap());
        this.wrappedMap = new HashMap();
        this.updateTargetMap(diff);
        this.fireMapChange(diff);
    }

    public V put(K key, V value) {
        MapDiff diff;
        V oldValue;
        this.checkRealm();
        if (this.wrappedMap.containsKey(key)) {
            oldValue = this.wrappedMap.put(key, value);
            diff = this.wrappedMap.containsKey(key) ? Diffs.createMapDiffSingleChange(key, oldValue, value) : Diffs.createMapDiffSingleRemove(key, oldValue);
        } else {
            oldValue = this.wrappedMap.put(key, value);
            diff = Diffs.createMapDiffSingleAdd(key, value);
        }
        this.updateTargetMap(diff);
        this.fireMapChange(diff);
        return oldValue;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkRealm();
        HashMap<? extends K, ? extends V> map = new HashMap<K, V>(this.wrappedMap);
        map.putAll(m);
        MapDiff diff = Diffs.computeMapDiff((Map)this.wrappedMap, map);
        this.wrappedMap = map;
        this.updateTargetMap(diff);
        this.fireMapChange(diff);
    }

    public V remove(Object key) {
        this.checkRealm();
        if (!this.wrappedMap.containsKey(key)) {
            return null;
        }
        Object oldValue = this.wrappedMap.remove(key);
        MapDiff diff = Diffs.createMapDiffSingleRemove((Object)key, oldValue);
        this.updateTargetMap(diff);
        this.fireMapChange(diff);
        return oldValue;
    }

    public Object getKeyType() {
        return this.target.getKeyType();
    }

    public Object getValueType() {
        return this.target.getValueType();
    }

    public synchronized void dispose() {
        this.target.removeMapChangeListener(this.targetChangeListener);
        this.target.removeStaleListener(this.targetStaleListener);
        this.validationStatus.removeValueChangeListener(this.validationStatusChangeListener);
        super.dispose();
    }
}

