/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.ResourceTreeNode;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.SemanticDB;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.SemanticResourceDBFactory;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.SemanticResourceDBPackage;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.TreeRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticMetadataPersistenceManager {
    private static final String METADATA_FILENAME = "metadata.xmi";
    static final IPath EMPTY = new Path("");
    private SemanticDB db;
    private Map<String, Resource> metadataResourceMap = new HashMap<String, Resource>();
    private File metadataFolder;
    Resource metadataResource;
    ResourceSet metadataResourceSet = new ResourceSetImpl();

    public SemanticMetadataPersistenceManager(File metadataFolder) {
        this.metadataFolder = metadataFolder;
    }

    public SemanticDB getSemanticDB() {
        return this.db;
    }

    public String getMetadataResourceLocation(String name) {
        return this.getMetadataFile(name).getAbsolutePath();
    }

    public String getMetadataFileName(String name) {
        return "$." + name + ".xmi";
    }

    public void init() throws IOException {
        this.metadataResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.metadataFolder.mkdirs();
        File metadataFile = this.getMetadataFile(null);
        if (!metadataFile.exists()) {
            this.initSemanticDB();
        } else {
            this.loadSemanticDB();
        }
    }

    public void initSemanticDB() {
        this.metadataResource = this.metadataResourceSet.createResource(this.getResourceURI(METADATA_FILENAME));
        this.db = SemanticResourceDBFactory.eINSTANCE.createSemanticDB();
        this.metadataResource.getContents().add((Object)this.db);
    }

    private void loadSemanticDB() throws IOException {
        SemanticResourceDBPackage pkg = SemanticResourceDBPackage.eINSTANCE;
        pkg.eClass();
        this.metadataResource = this.metadataResourceSet.createResource(this.getResourceURI(METADATA_FILENAME));
        this.metadataResource.load(null);
        EList contents = this.metadataResource.getContents();
        for (EObject eObject : contents) {
            if (!(eObject instanceof SemanticDB)) continue;
            this.db = (SemanticDB)eObject;
            this.migrateSemanticDB();
            break;
        }
    }

    public void saveSemanticDB(String projectName) throws IOException {
        if (SfsTraceLocation.CORE_DB.isActive()) {
            SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.CORE_DB.getLocation());
        }
        EList<TreeRoot> roots = this.db.getRoots();
        for (TreeRoot treeRoot : roots) {
            if (projectName != null && !projectName.equals(treeRoot.getName())) continue;
            this.assignToProjectSpecificMetadataResource(treeRoot);
        }
        this.metadataResource.save(null);
        if (projectName == null) {
            for (Map.Entry<String, Resource> resourceEntry : this.metadataResourceMap.entrySet()) {
                resourceEntry.getValue().save(null);
            }
        } else {
            Resource resource = this.metadataResourceMap.get(projectName);
            resource.save(null);
        }
    }

    public File getMetadataFile(String name) {
        String fileName = name != null ? this.getMetadataFileName(name) : METADATA_FILENAME;
        return new File(this.metadataFolder, fileName);
    }

    public void migrateSemanticDB() throws IOException {
        File file;
        TreeIterator objects = this.db.eAllContents();
        ArrayList<ResourceTreeNode> toBeRemoved = new ArrayList<ResourceTreeNode>();
        Set<String> filesToBeRemoved = this.listMetadataFiles();
        while (objects.hasNext()) {
            ResourceTreeNode node;
            EObject eObject = (EObject)objects.next();
            if (eObject instanceof TreeRoot) {
                TreeRoot root = (TreeRoot)eObject;
                if (!root.isExists()) {
                    toBeRemoved.add(root);
                    continue;
                }
                this.assignToProjectSpecificMetadataResource(root);
                filesToBeRemoved.remove(this.getMetadataFileName(root.getName()));
                continue;
            }
            if (!(eObject instanceof ResourceTreeNode) || (node = (ResourceTreeNode)eObject).isExists()) continue;
            toBeRemoved.add(node);
        }
        for (ResourceTreeNode resourceTreeNode : toBeRemoved) {
            if (resourceTreeNode instanceof TreeRoot) {
                ((TreeRoot)resourceTreeNode).setParentDB(null);
                this.db.getRoots().remove((Object)resourceTreeNode);
                continue;
            }
            resourceTreeNode.setParent(null);
        }
        for (String fileName : filesToBeRemoved) {
            file = new File(this.metadataFolder, fileName);
            if (!file.exists()) continue;
            file.delete();
        }
        this.metadataResource.save(null);
        for (String name : this.metadataResourceMap.keySet()) {
            file = this.getMetadataFile(name);
            if (file.exists()) continue;
            Resource resource = this.metadataResourceMap.get(name);
            resource.save(null);
        }
    }

    private Set<String> listMetadataFiles() {
        File[] files = this.metadataFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xmi") && !name.equals(SemanticMetadataPersistenceManager.METADATA_FILENAME);
            }
        });
        HashSet<String> names = new HashSet<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            names.add(file.getName());
            ++n2;
        }
        return names;
    }

    private void assignToProjectSpecificMetadataResource(TreeRoot root) {
        Resource resource = this.metadataResourceMap.get(root.getName());
        if (resource == null) {
            URI uri = URI.createFileURI((String)this.getMetadataResourceLocation(root.getName()));
            resource = this.metadataResourceSet.createResource(uri);
            this.metadataResourceMap.put(root.getName(), resource);
        }
        resource.getContents().add((Object)root);
    }

    private URI getResourceURI(String fileName) {
        File metadataFile = new File(this.metadataFolder, fileName);
        String metadataLocation = metadataFile.getAbsolutePath();
        return URI.createFileURI((String)metadataLocation);
    }

    public Resource getMetadataResource() {
        return this.metadataResource;
    }
}

