/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.spi;

import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticResourceRuleFactory;
import org.eclipse.core.runtime.IPath;

public class DefaultMinimalSemanticResourceRuleFactory
implements ISemanticResourceRuleFactory {
    protected final ISemanticFileStore rootStore;

    public DefaultMinimalSemanticResourceRuleFactory(ISemanticFileStore rootStore) {
        this.rootStore = rootStore;
    }

    public ISemanticFileStore charsetRule(ISemanticFileStore store) {
        return store;
    }

    public ISemanticFileStore modifyRule(ISemanticFileStore store) {
        return store;
    }

    public ISemanticFileStore copyRule(ISemanticFileStore source, ISemanticFileStore destination) {
        return null;
    }

    public ISemanticFileStore moveRule(ISemanticFileStore source, ISemanticFileStore destination) {
        IPath sourcePath = source.getPath();
        IPath destinationPath = destination.getPath();
        IPath rootPath = this.rootStore.getPath();
        if (rootPath.equals((Object)sourcePath)) {
            return this.getParent(this.rootStore);
        }
        if (rootPath.equals((Object)destinationPath)) {
            return this.getParent(this.rootStore);
        }
        int matchingSegments = sourcePath.matchingFirstSegments(destinationPath);
        if (matchingSegments < rootPath.segmentCount()) {
            return null;
        }
        if (matchingSegments == rootPath.segmentCount()) {
            return this.rootStore;
        }
        int segmentsToRemove = sourcePath.segmentCount() - matchingSegments;
        ISemanticFileStore store = source;
        int i = 0;
        while (i < segmentsToRemove) {
            store = (ISemanticFileStore)store.getParent();
            ++i;
        }
        return store;
    }

    public ISemanticFileStore refreshRule(ISemanticFileStore store) {
        return this.getParent(store);
    }

    public ISemanticFileStore deleteRule(ISemanticFileStore store) {
        return this.getParent(store);
    }

    public ISemanticFileStore createRule(ISemanticFileStore store) {
        return this.getParent(store);
    }

    public ISemanticFileStore validateEditRule(ISemanticFileStore[] stores) {
        if (stores.length == 1) {
            return this.getParent(stores[0]);
        }
        return this.getParent(this.rootStore);
    }

    private ISemanticFileStore getParent(ISemanticFileStore store) {
        if (store.getType() == 3) {
            return store;
        }
        return (ISemanticFileStore)store.getParent();
    }
}

