/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.IClassContributionProvider;
import org.eclipse.e4.tools.emf.ui.common.ResourceSearchScope;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.StringMatcher;
import org.eclipse.e4.tools.emf.ui.internal.common.ClassContributionCollector;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.ContributionDataFile;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.FilteredContributionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.TargetPlatformIconContributionCollector;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractIconDialogWithScopeAndFilter
extends FilteredContributionDialog {
    private IProject project;
    private Map<IFile, Image> icons = Collections.synchronizedMap(new HashMap());
    protected Integer maxDisplayedImageSize;
    protected int maxImageHeight;
    public static TargetPlatformIconContributionCollector collector;
    private IconMatchCallback callback;
    private String returnValue;
    private SearchThread task;

    public AbstractIconDialogWithScopeAndFilter(Shell parentShell, IEclipseContext context) {
        super(parentShell, context);
        this.project = (IProject)context.get(IProject.class);
    }

    @Override
    protected String getFilterTextMessage() {
        return Messages.AbstractIconDialogWithScopeAndFilter_typeToStartSearch;
    }

    @Override
    protected String getResourceNameText() {
        return Messages.AbstractIconDialogWithScopeAndFilter_iconName;
    }

    @Override
    protected ClassContributionCollector getCollector() {
        if (collector == null) {
            collector = TargetPlatformIconContributionCollector.getInstance();
        }
        return collector;
    }

    @Override
    protected void createOptions(Composite compOptions) {
        super.createOptions(compOptions);
        Label lblMaxSize = new Label(compOptions, 0);
        lblMaxSize.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblMaxSize.setText(Messages.AbstractIconDialogWithScopeAndFilter_maxDisplayedImageSize);
        final ComboViewer cv = new ComboViewer(compOptions);
        cv.getCombo().setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        cv.add((Object)10);
        cv.add((Object)20);
        cv.add((Object)30);
        cv.add((Object)50);
        cv.add((Object)100);
        cv.add((Object)150);
        cv.add((Object)200);
        this.maxDisplayedImageSize = 30;
        cv.setSelection((ISelection)new StructuredSelection((Object)this.maxDisplayedImageSize));
        cv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractIconDialogWithScopeAndFilter.this.maxDisplayedImageSize = (Integer)((IStructuredSelection)cv.getSelection()).getFirstElement();
                AbstractIconDialogWithScopeAndFilter.this.rebuildViewer();
                AbstractIconDialogWithScopeAndFilter.this.refreshSearch();
            }
        });
    }

    @Override
    protected void rebuildViewer() {
        super.rebuildViewer();
        this.getViewer().getTable().setHeaderVisible(true);
        ((GridData)this.getViewer().getTable().getLayoutData()).minimumHeight = 100;
        TableViewerColumn colIcon = new TableViewerColumn(this.getViewer(), 0);
        colIcon.getColumn().setText(Messages.AbstractIconDialogWithScopeAndFilter_icon);
        TableViewerColumn colText = new TableViewerColumn(this.getViewer(), 0);
        colText.getColumn().setText(Messages.AbstractIconDialogWithScopeAndFilter_details);
        this.getViewer().getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = AbstractIconDialogWithScopeAndFilter.this.maxDisplayedImageSize;
            }
        });
        colIcon.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                ContributionDataFile file = cell.getElement() instanceof IClassContributionProvider.ContributionData ? new ContributionDataFile((IClassContributionProvider.ContributionData)cell.getElement()) : (cell.getElement() instanceof Entry ? ((Entry)cell.getElement()).file : (IFile)cell.getElement());
                Image img = (Image)AbstractIconDialogWithScopeAndFilter.this.icons.get(file);
                if (img == null) {
                    InputStream in = null;
                    try {
                        try {
                            in = file.getContents();
                            img = new Image((Device)cell.getControl().getDisplay(), in);
                            AbstractIconDialogWithScopeAndFilter.this.icons.put(file, img);
                        }
                        catch (Exception exception) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (img != null) {
                    int height;
                    int width;
                    double scale1 = (double)AbstractIconDialogWithScopeAndFilter.this.maxDisplayedImageSize.intValue() / (double)img.getImageData().height;
                    double scale2 = (double)AbstractIconDialogWithScopeAndFilter.this.maxDisplayedImageSize.intValue() / (double)img.getImageData().width;
                    if (scale2 < scale1) {
                        scale1 = scale2;
                    }
                    if (scale1 < 1.0) {
                        width = (int)((double)img.getImageData().width * scale1);
                        if (width == 0) {
                            width = 1;
                        }
                        if ((height = (int)((double)img.getImageData().height * scale1)) == 0) {
                            height = 1;
                        }
                        Image img2 = new Image(img.getDevice(), img.getImageData().scaledTo(width, height));
                        img.dispose();
                        img = img2;
                        AbstractIconDialogWithScopeAndFilter.this.icons.put(file, img);
                    }
                    if (img.getImageData().width > (width = AbstractIconDialogWithScopeAndFilter.this.getViewer().getTable().getColumn(0).getWidth())) {
                        AbstractIconDialogWithScopeAndFilter.this.getViewer().getTable().getColumn(0).setWidth(img.getImageData().width);
                    }
                    if ((height = img.getImageData().height) > AbstractIconDialogWithScopeAndFilter.this.maxImageHeight) {
                        AbstractIconDialogWithScopeAndFilter.this.maxImageHeight = height;
                    }
                }
                cell.setImage(img);
            }
        });
        colIcon.getColumn().setWidth(30);
        colText.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                IFile file;
                String installLocation = null;
                if (cell.getElement() instanceof IClassContributionProvider.ContributionData) {
                    IClassContributionProvider.ContributionData contributionData = (IClassContributionProvider.ContributionData)cell.getElement();
                    file = new ContributionDataFile(contributionData);
                    installLocation = contributionData.installLocation;
                } else if (cell.getElement() instanceof Entry) {
                    file = ((Entry)cell.getElement()).file;
                    installLocation = ((Entry)cell.getElement()).installLocation;
                } else {
                    file = (IFile)cell.getElement();
                }
                StyledString styledString = new StyledString(file.getProjectRelativePath().toString(), null);
                String bundle = FilteredContributionDialog.getBundle(file);
                if (bundle != null) {
                    styledString.append(" - " + bundle, StyledString.DECORATIONS_STYLER);
                } else if (installLocation != null) {
                    styledString.append(" - " + installLocation, StyledString.DECORATIONS_STYLER);
                }
                cell.setText(styledString.getString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
        });
        colText.getColumn().setWidth(400);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractIconDialogWithScopeAndFilter.this.clearImages();
            }
        });
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.maxDisplayedImageSize = 20;
        this.rebuildViewer();
        return comp;
    }

    @Override
    protected boolean doSearch() {
        if (this.getSearchScopes().contains((Object)ResourceSearchScope.TARGET_PLATFORM)) {
            return false;
        }
        Timer timer = new Timer(true);
        if (this.callback != null) {
            this.callback.cancel = true;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
        this.clearImages();
        this.callback = new IconMatchCallback((IObservableList)this.getViewer().getInput());
        IClassContributionProvider.Filter filter = new IClassContributionProvider.Filter(this.project, this.getFilterTextBox().getText());
        filter.setSearchScope(this.getSearchScopes());
        filter.setBundles(this.getFilterBundles());
        filter.setLocations(this.getFilterLocations());
        filter.setPackages(this.getFilterPackages());
        filter.setIncludeNonBundles(this.includeNonBundles);
        this.task = new SearchThread(this.callback, filter);
        timer.schedule((TimerTask)this.task, 500L);
        return true;
    }

    private void clearImages() {
        for (Image img : this.icons.values()) {
            img.dispose();
        }
        this.icons.clear();
    }

    protected void okPressed() {
        this.returnValue = null;
        IFile file = this.getSelectedIfile();
        if (file != null) {
            String installLocation = null;
            if (file instanceof ContributionDataFile) {
                ContributionDataFile cdf = (ContributionDataFile)file;
                installLocation = cdf.getContributionData().installLocation;
            }
            if ((file = this.checkResourceAccessible(file, installLocation)) != null) {
                String uri;
                String bundle = AbstractIconDialogWithScopeAndFilter.getBundle(file);
                this.returnValue = uri = "platform:/plugin/" + bundle + "/" + file.getProjectRelativePath().toString();
                super.okPressed();
            }
        }
    }

    public String getValue() {
        return this.returnValue;
    }

    public static class Entry {
        IFile file;
        String installLocation;
    }

    private class IconMatchCallback {
        private volatile boolean cancel;
        private IObservableList list;

        private IconMatchCallback(IObservableList list) {
            this.list = list;
        }

        public void match(final IFile file, final String installLocation) {
            if (!this.cancel) {
                this.list.getRealm().exec(new Runnable(){

                    @Override
                    public void run() {
                        Entry entry = new Entry();
                        entry.file = file;
                        entry.installLocation = installLocation;
                        IconMatchCallback.this.list.add((Object)entry);
                    }
                });
            }
        }
    }

    private static class SearchThread
    extends TimerTask {
        private final IconMatchCallback callback;
        private final StringMatcher matcherGif;
        private final StringMatcher matcherJpg;
        private final StringMatcher matcherPng;
        private IClassContributionProvider.Filter filter;
        private boolean includeNonBundles;

        public SearchThread(IconMatchCallback callback, IClassContributionProvider.Filter filter) {
            this.matcherGif = new StringMatcher("*" + filter.namePattern + "*.gif", true, false);
            this.matcherJpg = new StringMatcher("*" + filter.namePattern + "*.jpg", true, false);
            this.matcherPng = new StringMatcher("*" + filter.namePattern + "*.png", true, false);
            this.callback = callback;
            this.filter = filter;
        }

        @Override
        public void run() {
            List<IProject> projects;
            if (this.filter.getSearchScope().contains((Object)ResourceSearchScope.TARGET_PLATFORM)) {
                return;
            }
            if (this.filter.getSearchScope().contains((Object)ResourceSearchScope.WORKSPACE)) {
                projects = Arrays.asList(this.filter.project.getWorkspace().getRoot().getProjects());
            } else if (this.filter.getSearchScope().contains((Object)ResourceSearchScope.PROJECT)) {
                if (this.filter.getSearchScope().contains((Object)ResourceSearchScope.REFERENCES)) {
                    projects = new ArrayList<IProject>();
                    projects.add(this.filter.project);
                    try {
                        IProject[] iProjectArray = this.filter.project.getReferencedProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject ref = iProjectArray[n2];
                            projects.add(ref);
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                } else {
                    projects = Arrays.asList(this.filter.project);
                }
            } else {
                return;
            }
            try {
                for (final IProject project : projects) {
                    if (!this.includeNonBundles && !this.filter.project.getFile("/META-INF/MANIFEST.MF").exists()) continue;
                    project.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (SearchThread.this.callback.cancel) {
                                return false;
                            }
                            if (resource.getType() == 2 || resource.getType() == 4) {
                                return true;
                            }
                            if (resource.getType() == 1 && !resource.isLinked()) {
                                String path = resource.getProjectRelativePath().toString();
                                if (SearchThread.this.matcherGif.match(path) || SearchThread.this.matcherPng.match(path) || SearchThread.this.matcherJpg.match(path)) {
                                    String bundle;
                                    if (E.notEmpty(SearchThread.this.filter.getPackages()) && !SearchThread.this.filter.getPackages().contains(resource.getProjectRelativePath().removeLastSegments(1).toOSString())) {
                                        return false;
                                    }
                                    if (E.notEmpty(SearchThread.this.filter.getLocations()) && !SearchThread.this.filter.getLocations().contains(project.getLocation().toOSString())) {
                                        return false;
                                    }
                                    if (E.notEmpty(SearchThread.this.filter.getBundles()) && ((bundle = AbstractIconDialogWithScopeAndFilter.getBundle(project)) == null || !SearchThread.this.filter.getBundles().contains(bundle))) {
                                        return false;
                                    }
                                    if (!SearchThread.this.filter.isIncludeNonBundles() && (bundle = AbstractIconDialogWithScopeAndFilter.getBundle(project)) == null) {
                                        return false;
                                    }
                                    SearchThread.this.callback.match((IFile)resource, project.getLocation().toOSString());
                                }
                            }
                            return false;
                        }
                    });
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

