/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.util.ArrayList;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.PatternFilter;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.SaveDialogBoundsSettingsDialog;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CommandCategorySelectionDialog
extends SaveDialogBoundsSettingsDialog {
    private IModelResource resource;
    private TableViewer viewer;
    private MCommand command;
    private Messages Messages;

    public CommandCategorySelectionDialog(Shell parentShell, IModelResource resource, MCommand command, Messages Messages2) {
        super(parentShell);
        this.resource = resource;
        this.command = command;
        this.Messages = Messages2;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.Messages.CommandCategorySelectionDialog_ShellTitle);
        this.setTitle(this.Messages.CommandCategorySelectionDialog_Title);
        this.setMessage(this.Messages.CommandCategorySelectionDialog_Message);
        final Image titleImage = new Image((Device)composite.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/wizban/newexp_wiz.png"));
        this.setTitleImage(titleImage);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                titleImage.dispose();
            }
        });
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText(this.Messages.CommandCategorySelectionDialog_LabelCategoryId);
        Text searchText = new Text(container, 2688);
        searchText.setLayoutData((Object)new GridData(768));
        new Label(container, 0);
        this.viewer = new TableViewer(container);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CommandCategorySelectionDialog.this.okPressed();
            }
        });
        ArrayList<EObject> categories = new ArrayList<EObject>();
        TreeIterator it = EcoreUtil.getAllContents((EObject)((EObject)this.resource.getRoot().get(0)), (boolean)true);
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            if (o.eClass() != CommandsPackageImpl.Literals.CATEGORY) continue;
            categories.add(o);
        }
        this.viewer.setInput(categories);
        PatternFilter filter = new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
            }
        };
        this.viewer.addFilter((ViewerFilter)filter);
        ControlFactory.attachFiltering(searchText, this.viewer, filter);
        return composite;
    }

    protected void okPressed() {
        Command cmd;
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        if (!s.isEmpty() && (cmd = SetCommand.create((EditingDomain)this.resource.getEditingDomain(), (Object)this.command, (Object)CommandsPackageImpl.Literals.COMMAND__CATEGORY, (Object)s.getFirstElement())).canExecute()) {
            this.resource.getEditingDomain().getCommandStack().execute(cmd);
            super.okPressed();
        }
    }

    private static class LabelProviderImpl
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private LabelProviderImpl() {
        }

        public void update(ViewerCell cell) {
            MCategory cmd = (MCategory)cell.getElement();
            StyledString styledString = new StyledString();
            if (cmd.getName() != null) {
                styledString.append(cmd.getName());
            }
            if (cmd.getElementId() != null) {
                styledString.append(" (" + cmd.getElementId() + ")", StyledString.DECORATIONS_STYLER);
            } else {
                styledString.append(" (<no id>)", StyledString.DECORATIONS_STYLER);
            }
            if (cmd.getDescription() != null) {
                styledString.append(" - " + cmd.getDescription(), StyledString.DECORATIONS_STYLER);
            }
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            MCategory command = (MCategory)element;
            String s = "";
            if (command.getName() != null) {
                s = String.valueOf(s) + command.getName();
            }
            if (command.getDescription() != null) {
                s = String.valueOf(s) + " " + command.getDescription();
            }
            if (command.getElementId() != null) {
                s = String.valueOf(s) + " " + command.getElementId();
            }
            return s;
        }
    }
}

