/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.spy;

import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.framework.FrameworkUtil;

public class SpyHandler {
    private static final int DEFAULT_SPY_WINDOW_HEIGHT = 600;
    private static final int DEFAULT_SPY_WINDOW_WIDTH = 1000;
    private static final String E4_SPIES_WINDOW_LABEL = "E4 Spies window";
    private static final String E4_SPIES_WINDOW = "org.eclipse.e4.tools.spy.window";
    private static final String E4_SPIES_TRIMBAR = "org.eclipse.e4.tools.spy.trimbar";
    private static final String E4_SPIES_TOOLBAR = "org.eclipse.e4.tools.spy.toolbar";
    private static final String E4_SPIES_PART_STACK = "org.eclipse.e4.tools.spy.partStack";

    @Execute
    public void run(EPartService ps, @Optional @Named(value="org.eclipse.e4.tools.spy.command.partID") String viewID, MApplication appli, EModelService modelService) {
        MWindow spyWindow = this.getOrCreateSpyWindow(appli, modelService);
        MPartStack partStack = (MPartStack)modelService.find(E4_SPIES_PART_STACK, (MUIElement)spyWindow);
        MPart p = ps.findPart(viewID);
        if (p == null) {
            p = ps.createPart(viewID);
            partStack.getChildren().add(p);
            partStack.setSelectedElement((MUIElement)p);
        }
        p.setVisible(true);
        ps.activate(p, true);
    }

    private MWindow getOrCreateSpyWindow(MApplication appli, EModelService modelService) {
        List existingWindow = modelService.findElements((MUIElement)appli, E4_SPIES_WINDOW, MWindow.class, null);
        if (existingWindow.size() >= 1) {
            return (MWindow)existingWindow.get(0);
        }
        String contributorURI = "platform:/plugin/" + FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        MTrimmedWindow tw = (MTrimmedWindow)modelService.createModelElement(MTrimmedWindow.class);
        tw.setElementId(E4_SPIES_WINDOW);
        tw.setLabel(E4_SPIES_WINDOW_LABEL);
        tw.setContributorURI(contributorURI);
        MTrimBar trimBar = (MTrimBar)modelService.createModelElement(MTrimBar.class);
        trimBar.setElementId(E4_SPIES_TRIMBAR);
        trimBar.setContributorURI(contributorURI);
        tw.getTrimBars().add(trimBar);
        MToolBar toolbar = (MToolBar)modelService.createModelElement(MToolBar.class);
        toolbar.setElementId(E4_SPIES_TOOLBAR);
        toolbar.setContributorURI(contributorURI);
        trimBar.getChildren().add(toolbar);
        for (MPartDescriptor mp : appli.getDescriptors()) {
            if (!mp.getTags().contains("Spy")) continue;
            MHandledToolItem toolItem = (MHandledToolItem)modelService.createModelElement(MHandledToolItem.class);
            toolItem.setContributorURI(contributorURI);
            MCommand spyCmd = null;
            for (MCommand cmd : appli.getCommands()) {
                if (!"org.eclipse.e4.tools.spy.command".equals(cmd.getElementId())) continue;
                spyCmd = cmd;
                break;
            }
            toolItem.setCommand(spyCmd);
            toolItem.setIconURI(mp.getIconURI());
            toolItem.setLabel(mp.getLabel());
            toolItem.setTooltip("Open the " + mp.getLabel());
            toolbar.getChildren().add(toolItem);
            MParameter p = (MParameter)modelService.createModelElement(MParameter.class);
            p.setName("org.eclipse.e4.tools.spy.command.partID");
            p.setValue(mp.getElementId());
            toolItem.getParameters().add(p);
        }
        tw.setWidth(1000);
        tw.setHeight(600);
        ((MWindow)appli.getChildren().get(0)).getWindows().add(tw);
        MPartStack partStack = (MPartStack)modelService.createModelElement(MPartStack.class);
        partStack.setElementId(E4_SPIES_PART_STACK);
        tw.getChildren().add(partStack);
        return tw;
    }
}

