/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.list.SimpleListProperty;
import org.eclipse.jface.internal.databinding.viewers.SelectionChangedListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionProviderMultipleSelectionProperty<S extends ISelectionProvider>
extends SimpleListProperty<S, Object> {
    private final boolean isPostSelection;

    public SelectionProviderMultipleSelectionProperty(boolean isPostSelection) {
        this.isPostSelection = isPostSelection;
    }

    public Object getElementType() {
        return Object.class;
    }

    public Class<Object> getElementClass() {
        return Object.class;
    }

    protected List<Object> doGetList(S source) {
        ISelection selection = source.getSelection();
        if (selection instanceof IStructuredSelection) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object element : ((IStructuredSelection)selection).toList()) {
                result.add(element);
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected void doSetList(S source, List<Object> list, ListDiff<Object> diff) {
        this.doSetList(source, list);
    }

    protected void doSetList(S source, List<Object> list) {
        source.setSelection((ISelection)new StructuredSelection(list));
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<ListDiff<Object>> listener) {
        return new SelectionChangedListener((IProperty)this, listener, this.isPostSelection);
    }

    public String toString() {
        return this.isPostSelection ? "IPostSelectionProvider.postSelection[]" : "ISelectionProvider.selection[]";
    }
}

