/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.util.Date;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet030DateAndTimeObservableValue {
    protected Shell shell;
    private Text modelText;
    private DateTime date;
    private DateTime calendar;
    private DateTime time;
    private Button syncTime;

    public static void main(String[] args) {
        try {
            Snippet030DateAndTimeObservableValue window = new Snippet030DateAndTimeObservableValue();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        final Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                Snippet030DateAndTimeObservableValue.this.createContents();
                Snippet030DateAndTimeObservableValue.this.shell.pack();
                Snippet030DateAndTimeObservableValue.this.shell.open();
                while (!Snippet030DateAndTimeObservableValue.this.shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    protected void createContents() {
        this.shell = new Shell();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout((Layout)layout);
        this.shell.setText("Snippet030DateAndTimeObservableValue.java");
        new Label((Composite)this.shell, 0).setText("Model date + time");
        this.modelText = new Text((Composite)this.shell, 2048);
        this.modelText.setEditable(false);
        this.modelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new Label((Composite)this.shell, 0).setText("Target date (SWT.DATE)");
        this.date = new DateTime((Composite)this.shell, 2080);
        this.date.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        new Label((Composite)this.shell, 0).setText("Target date (SWT.CALENDAR)");
        this.calendar = new DateTime((Composite)this.shell, 1024);
        this.calendar.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        new Label((Composite)this.shell, 0).setText("Target time");
        this.time = new DateTime((Composite)this.shell, 2176);
        this.syncTime = new Button((Composite)this.shell, 32);
        this.syncTime.setLayoutData((Object)new GridData());
        this.syncTime.setText("Sync with system time");
        this.bindUI();
    }

    private void bindUI() {
        DataBindingContext dbc = new DataBindingContext();
        WritableValue model = WritableValue.withValueType(Date.class);
        model.setValue((Object)new Date());
        dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.modelText), (IObservableValue)model);
        ISWTObservableValue timeSelection = WidgetProperties.selection().observe((Widget)this.time);
        dbc.bindValue((IObservableValue)new DateAndTimeObservableValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.date), (IObservableValue)timeSelection), (IObservableValue)model);
        dbc.bindValue((IObservableValue)new DateAndTimeObservableValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.calendar), (IObservableValue)timeSelection), (IObservableValue)model);
        this.syncTime.addListener(13, new Listener((IObservableValue)timeSelection){
            Runnable runnable;
            {
                this.runnable = new Runnable(){

                    public void run() {
                        if (Snippet030DateAndTimeObservableValue.this.syncTime.getSelection()) {
                            iObservableValue.setValue((Object)new Date());
                            Display.getCurrent().timerExec(100, (Runnable)this);
                        }
                    }
                };
            }

            public void handleEvent(Event event) {
                Snippet030DateAndTimeObservableValue.this.time.setEnabled(!Snippet030DateAndTimeObservableValue.this.syncTime.getSelection());
                if (Snippet030DateAndTimeObservableValue.this.syncTime.getSelection()) {
                    this.runnable.run();
                }
            }
        });
    }
}

