/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.compatibility.tests.util.testcases;

import java.text.MessageFormat;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.runtime.api.IDescriptiveObject;
import org.eclipse.platform.discovery.runtime.internal.xp.IContributionsReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public abstract class DynamicRegistryContributorTest<T extends IDescriptiveObject>
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.startCompatibilityIfNotStarted();
    }

    private void startCompatibilityIfNotStarted() throws BundleException {
        this.startBundleIfNotStarted("org.eclipse.platform.discovery.compatibility");
    }

    private void startBundleIfNotStarted(String bundleName) throws BundleException {
        Bundle runtimeBundle = Platform.getBundle((String)bundleName);
        if (runtimeBundle.getState() != 32) {
            runtimeBundle.start();
        }
    }

    public void testContribution() {
        String expectedId = this.expectedContributionId();
        for (IDescriptiveObject contribution : this.getParser(Platform.getExtensionRegistry()).readContributions()) {
            if (!expectedId.equals(contribution.getId())) continue;
            this.verifyContribution(contribution);
            return;
        }
        DynamicRegistryContributorTest.fail((String)MessageFormat.format("Contribution with id {0} not found in extension registry", expectedId));
    }

    protected abstract void verifyContribution(T var1);

    protected abstract IContributionsReader<T> getParser(IExtensionRegistry var1);

    protected abstract String expectedContributionId();
}

