/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.test.unit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.platform.discovery.destprefs.api.ISearchDestinationConfigurator;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class SearchConfiguratorsFixture {
    public final String CATEGORY_1 = "category_one";
    public final String CATEGORY_2 = "category_two";
    public final String DEST_PROVIDER_CAT1_1 = "destProviderCat1_1";
    public final String DEST_PROVIDER_CAT1_2 = "destProviderCat1_2";
    public final String DEST_PROVIDER_CAT2 = "destProviderCat2";
    public final String CONFIGURATOR_1_1_ID = "configurator_1_1";
    public final String CONFIGURATOR_1_2_ID = "configurator_1_2";
    public final String CONFIGURATOR_2_ID = "configurator_2";
    public final String CONFIGURATOR_1_1_FQNAME = "org.eclipse.platform.discovery.destprefs.configurator_1_1";
    public final String CONFIGURATOR_1_2_FQNAME = "org.eclipse.platform.discovery.destprefs.configurator_1_2";
    public final String CONFIGURATOR_2_FQNAME = "org.eclipse.platform.discovery.destprefs.configurator_2";
    @Mock
    public ISearchDestinationConfigurator<ISearchDestination> configurator_1_1;
    @Mock
    public ISearchDestinationConfigurator<ISearchDestination> configurator_1_2;
    @Mock
    public ISearchDestinationConfigurator<ISearchDestination> configurator_2;
    @Mock
    public ISearchProviderConfiguration searchProviderConfiguration;
    @Mock
    public IDestinationsProvider destprovider1;
    @Mock
    public ISearchDestination destination1;
    public IDestinationCategoryDescription categoryDesc1;
    public IDestinationCategoryDescription categoryDesc2;

    public void setup(ExtensionRegistryBuilder registryBuilder) {
        MockitoAnnotations.initMocks((Object)this);
        this.setupSearchProviderConfiguration();
        this.setupDestProvider();
        registryBuilder.addDestinationCategory("category_one", "category_one");
        registryBuilder.addDestinationCategory("category_two", "category_two");
        registryBuilder.addDestinationsProvider("destProviderCat1_1", "category_one", null, "someprovider_1_1", this.destprovider1);
        registryBuilder.addDestinationsProvider("destProviderCat1_2", "category_one", null, "someprovider_1_2", this.destprovider1);
        registryBuilder.addDestinationsProvider("destProviderCat2", "category_two", null, "someprovider2", this.destprovider1);
        registryBuilder.addSearchDestinationsConfigurator("configurator_1_1", "destProviderCat1_1", "org.eclipse.platform.discovery.destprefs.configurator_1_1", this.configurator_1_1);
        registryBuilder.addSearchDestinationsConfigurator("configurator_1_2", "destProviderCat1_2", "org.eclipse.platform.discovery.destprefs.configurator_1_2", this.configurator_1_2);
        registryBuilder.addSearchDestinationsConfigurator("configurator_2", "destProviderCat2", "org.eclipse.platform.discovery.destprefs.configurator_2", this.configurator_2);
    }

    private void setupDestProvider() {
        HashSet<ISearchDestination> destinations = new HashSet<ISearchDestination>();
        destinations.add(this.destination1);
        Mockito.when((Object)this.destprovider1.getSearchDestinations()).thenReturn(destinations);
    }

    private void setupSearchProviderConfiguration() {
        List<IDestinationCategoryDescription> allDestinationCategories = this.destinationCategories();
        Mockito.stub((Object)this.searchProviderConfiguration.getDestinationCategories()).toReturn(allDestinationCategories);
        Mockito.when((Object)this.searchProviderConfiguration.getDestinationProvidersForCategory((IDestinationCategoryDescription)Mockito.any(IDestinationCategoryDescription.class))).thenAnswer((Answer)new Answer<List<IDestinationsProviderDescription>>(){

            public List<IDestinationsProviderDescription> answer(InvocationOnMock invocation) throws Throwable {
                ArrayList<IDestinationsProviderDescription> result = new ArrayList<IDestinationsProviderDescription>();
                IDestinationCategoryDescription category = (IDestinationCategoryDescription)invocation.getArguments()[0];
                if (category.getId().equals("category_one")) {
                    result.add(SearchConfiguratorsFixture.this.destinationProvider("destProviderCat1_1"));
                    result.add(SearchConfiguratorsFixture.this.destinationProvider("destProviderCat1_2"));
                } else if (category.getId().equals("category_two")) {
                    result.add(SearchConfiguratorsFixture.this.destinationProvider("destProviderCat2"));
                }
                return result;
            }
        });
    }

    private IDestinationsProviderDescription destinationProvider(String destProviderId) {
        IDestinationsProviderDescription provider = (IDestinationsProviderDescription)Mockito.mock(IDestinationsProviderDescription.class);
        Mockito.stub((Object)provider.getId()).toReturn((Object)destProviderId);
        return provider;
    }

    private List<IDestinationCategoryDescription> destinationCategories() {
        ArrayList<IDestinationCategoryDescription> result = new ArrayList<IDestinationCategoryDescription>();
        this.categoryDesc1 = this.mockDestinationCategory("category_one");
        this.categoryDesc2 = this.mockDestinationCategory("category_two");
        result.add(this.categoryDesc1);
        result.add(this.categoryDesc2);
        return result;
    }

    private IDestinationCategoryDescription mockDestinationCategory(String categoryId) {
        IDestinationCategoryDescription category = (IDestinationCategoryDescription)Mockito.mock(IDestinationCategoryDescription.class);
        Mockito.stub((Object)category.getId()).toReturn((Object)categoryId);
        return category;
    }
}

