/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.test.unit.prefpage.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.CategoryDestinationProviderPair;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.CategoryDestinationsContentProvider;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.nodes.CategoryNode;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.nodes.DestinationNode;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CategoryDestinationsContentProviderTest {
    private CategoryDestinationsContentProvider contentProvider;
    @Mock
    private ISearchDestination DESTINATION_1;
    @Mock
    private ISearchDestination DESTINATION_2;
    @Mock
    private ISearchDestination DESTINATION_3;
    private static final String DESTINATION_NAME_1 = "First destination";
    private static final String DESTINATION_NAME_2 = "Second destination";
    private static final String DESTINATION_NAME_3 = "Third destination";
    @Mock
    private IDestinationCategoryDescription CATEGORY_1;
    @Mock
    private IDestinationCategoryDescription CATEGORY_2;
    private static final String CATEGORY_NAME_1 = "First category";
    private static final String CATEGORY_NAME_2 = "Second category";
    @Mock
    private IDestinationsProviderDescription DESTINATION_PROVIDER_1;
    @Mock
    private IDestinationsProviderDescription DESTINATION_PROVIDER_2;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupSearchDestinations();
        this.setupDestinationProviders();
        this.setupCategories();
        this.contentProvider = new CategoryDestinationsContentProvider();
    }

    private void setupSearchDestinations() {
        Mockito.when((Object)this.DESTINATION_1.getDisplayName()).thenReturn((Object)DESTINATION_NAME_1);
        Mockito.when((Object)this.DESTINATION_2.getDisplayName()).thenReturn((Object)DESTINATION_NAME_2);
        Mockito.when((Object)this.DESTINATION_3.getDisplayName()).thenReturn((Object)DESTINATION_NAME_3);
    }

    private void setupCategories() {
        Mockito.when((Object)this.CATEGORY_1.getDisplayName()).thenReturn((Object)CATEGORY_NAME_1);
        Mockito.when((Object)this.CATEGORY_2.getDisplayName()).thenReturn((Object)CATEGORY_NAME_2);
    }

    private void setupDestinationProviders() {
        HashSet<ISearchDestination> destinations1 = new HashSet<ISearchDestination>();
        destinations1.add(this.DESTINATION_1);
        destinations1.add(this.DESTINATION_2);
        HashSet<ISearchDestination> destinations2 = new HashSet<ISearchDestination>();
        destinations2.add(this.DESTINATION_3);
        IDestinationsProvider provider1 = (IDestinationsProvider)Mockito.mock(IDestinationsProvider.class);
        Mockito.when((Object)provider1.getSearchDestinations()).thenReturn(destinations1);
        IDestinationsProvider provider2 = (IDestinationsProvider)Mockito.mock(IDestinationsProvider.class);
        Mockito.when((Object)provider2.getSearchDestinations()).thenReturn(destinations2);
        Mockito.when((Object)this.DESTINATION_PROVIDER_1.createProvider()).thenReturn((Object)provider1);
        Mockito.when((Object)this.DESTINATION_PROVIDER_2.createProvider()).thenReturn((Object)provider2);
    }

    @Test
    public void testGetElements() {
        CategoryDestinationProviderPair categDescPair_1 = new CategoryDestinationProviderPair(this.CATEGORY_1, this.DESTINATION_PROVIDER_1);
        CategoryDestinationProviderPair categDescPair_2 = new CategoryDestinationProviderPair(this.CATEGORY_2, this.DESTINATION_PROVIDER_2);
        List<CategoryDestinationProviderPair> pairs = Arrays.asList(categDescPair_1, categDescPair_2);
        Object[] elements = this.contentProvider.getElements(pairs);
        Assert.assertEquals((String)"Two elements expected", (long)2L, (long)elements.length);
        ArrayList<String> elementDisplayNames = new ArrayList<String>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            elementDisplayNames.add(((CategoryNode)object).getDisplayName());
            ++n2;
        }
        Assert.assertTrue((String)"Category 1 expected to be contained in the result", (boolean)elementDisplayNames.contains(CATEGORY_NAME_1));
        Assert.assertTrue((String)"Category 2 expected to be contained in the result", (boolean)elementDisplayNames.contains(CATEGORY_NAME_2));
    }

    @Test
    public void testHasChildren() {
        CategoryNode categoryNode = new CategoryNode(CATEGORY_NAME_1, this.DESTINATION_PROVIDER_1);
        DestinationNode destinationNode = new DestinationNode(categoryNode, this.DESTINATION_1);
        Assert.assertTrue((String)"Children expected for category node", (boolean)this.contentProvider.hasChildren((Object)categoryNode));
        Assert.assertFalse((String)"No children expected for destination node", (boolean)this.contentProvider.hasChildren((Object)destinationNode));
    }

    @Test
    public void testGetChildren() {
        Object[] elements;
        CategoryNode categoryNode1 = new CategoryNode(CATEGORY_NAME_1, this.DESTINATION_PROVIDER_1);
        CategoryNode categoryNode2 = new CategoryNode(CATEGORY_NAME_2, this.DESTINATION_PROVIDER_2);
        Assert.assertFalse((String)"Array should not be empty", (this.contentProvider.getChildren((Object)categoryNode1).length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Array should have 2 children", (this.contentProvider.getChildren((Object)categoryNode1).length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Array should have 1 child", (this.contentProvider.getChildren((Object)categoryNode2).length == 1 ? 1 : 0) != 0);
        ArrayList<String> destinationDisplayNames = new ArrayList<String>();
        Object[] objectArray = elements = this.contentProvider.getChildren((Object)categoryNode1);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            destinationDisplayNames.add(((DestinationNode)object).getDestination().getDisplayName());
            ++n2;
        }
        Assert.assertTrue((String)"Destination 1 expected to be contained in the result", (boolean)destinationDisplayNames.contains(DESTINATION_NAME_1));
        Assert.assertTrue((String)"Destination 2 expected to be contained in the result", (boolean)destinationDisplayNames.contains(DESTINATION_NAME_2));
        Assert.assertFalse((String)"Destination 3 not expected to be contained in the result", (boolean)destinationDisplayNames.contains(DESTINATION_NAME_3));
    }
}

