/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.internal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.platform.discovery.core.internal.IDestinationsManager;
import org.eclipse.platform.discovery.destprefs.internal.IPreferenceDialogCreator;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.ISearchDestinationsConfiguratorDescription;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.swt.widgets.Shell;

public class DestinationsManager
implements IDestinationsManager {
    public static final String GENERIC_PREFPAGE_ID = "org.eclipse.platform.discovery.destprefs.preferencepage";
    private final AbstractExtensionPointParser<ISearchDestinationsConfiguratorDescription> destConfigurator;
    private final ISearchProviderConfiguration searchConfig;
    private final IPreferenceDialogCreator dialogCreator;

    public DestinationsManager(AbstractExtensionPointParser<ISearchDestinationsConfiguratorDescription> destConfigurator, IPreferenceDialogCreator dialogCreator, ISearchProviderConfiguration searchConfig) {
        this.destConfigurator = destConfigurator;
        this.dialogCreator = dialogCreator;
        this.searchConfig = searchConfig;
    }

    public void manageDestinations(Shell parentShell, IDestinationCategoryDescription selectedDestCategory) {
        List<String> prefPageIDs = this.allPreferencePages();
        this.dialogCreator.openPreferenceDialog(parentShell, this.getPrefPageIdToPreselect(selectedDestCategory), prefPageIDs.toArray(new String[prefPageIDs.size()]));
    }

    private List<String> allPreferencePages() {
        LinkedList<String> prefPageIDs = new LinkedList<String>();
        prefPageIDs.add(GENERIC_PREFPAGE_ID);
        for (IDestinationsProviderDescription provider : this.searchConfig.getAvailableDestinationProviders()) {
            if (provider.getPreferencePageId() == null) continue;
            prefPageIDs.add(provider.getPreferencePageId());
        }
        return prefPageIDs;
    }

    private String getPrefPageIdToPreselect(IDestinationCategoryDescription selectedDestCategory) {
        String prefPageId;
        if (selectedDestCategory != null && !this.hasDestinationsConfigurator(selectedDestCategory) && (prefPageId = this.getPrefPageIdFor(selectedDestCategory)) != null) {
            return prefPageId;
        }
        return GENERIC_PREFPAGE_ID;
    }

    private String getPrefPageIdFor(IDestinationCategoryDescription selectedDestCategory) {
        for (IDestinationsProviderDescription destProvider : this.searchConfig.getDestinationProvidersForCategory(selectedDestCategory)) {
            if (destProvider.getPreferencePageId() == null) continue;
            return destProvider.getPreferencePageId();
        }
        return null;
    }

    private boolean hasDestinationsConfigurator(IDestinationCategoryDescription selectedDestCategory) {
        for (IDestinationsProviderDescription destProvider : this.searchConfig.getDestinationProvidersForCategory(selectedDestCategory)) {
            for (ISearchDestinationsConfiguratorDescription desc : this.destConfigurator.readContributions()) {
                if (!desc.destinationProviderId().equals(destProvider.getId()) || !desc.destinationCategoryId().equals(selectedDestCategory.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

