/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.test.unit.internal;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.api.ISearchProvider;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.SearchProvidersExtensionParser;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.platform.discovery.testutils.utils.testcases.AbstractExtensionPointParserTest;
import org.junit.Assert;
import org.mockito.Mockito;

public class SearchProvidersExtensionParserTest
extends AbstractExtensionPointParserTest<ISearchProviderDescription> {
    private static final String CATEGORY_ID_1 = "category1";
    private static final String CATEGORY_ID_2 = "category2";
    private static final String OBJECT_ID_1 = "object1";
    private static final String OBJECT_ID_2 = "object2";
    private static final String OBJECT_NAME_1 = "object1";
    private static final String OBJECT_NAME_2 = "object2";
    private static final String PROVIDER_ID = "testprovider";
    private static final String PROVIDER_INSTANCE = "org.eclipse.test.MyProvider";
    private static final String PROVIDER_SUPPORTS_TEXT_SEARCH = "true";
    private ISearchProvider searchProviderMock;

    protected AbstractExtensionPointParser<ISearchProviderDescription> createParser(IExtensionRegistry registry) {
        return new SearchProvidersExtensionParser(registry);
    }

    protected void setupRegistry(ExtensionRegistryBuilder registryBuilder) {
        this.searchProviderMock = (ISearchProvider)Mockito.mock(ISearchProvider.class);
        registryBuilder.addObjectType("object1", "object1");
        registryBuilder.addObjectType("object2", "object2");
        registryBuilder.addDestinationCategory(CATEGORY_ID_1, null);
        registryBuilder.addDestinationCategory(CATEGORY_ID_2, null);
        registryBuilder.addSearchProvider(PROVIDER_ID, PROVIDER_INSTANCE, this.searchProviderMock, "object1", PROVIDER_SUPPORTS_TEXT_SEARCH, new String[]{CATEGORY_ID_1});
    }

    protected void verifyContributions(List<ISearchProviderDescription> contributions) {
        Assert.assertEquals((String)"One provider expeceted", (long)1L, (long)contributions.size());
        ISearchProviderDescription provider = contributions.get(0);
        Assert.assertEquals((String)"Unexpected id", (Object)PROVIDER_ID, (Object)provider.getId());
        Assert.assertEquals((String)"Unexpected object type", (Object)"object1", (Object)provider.getObjectType().getId());
        Assert.assertTrue((String)"Provider expected to support text search", (boolean)provider.supportsTextSearch());
        Assert.assertSame((String)"Unexpected provider created", (Object)provider.createInstance(), (Object)this.searchProviderMock);
        Assert.assertEquals((String)"Unexpected display name", (Object)PROVIDER_INSTANCE, (Object)provider.getDisplayName());
        Set categories = provider.getSupportedDestinationCategories();
        Assert.assertEquals((String)"One category expected", (long)1L, (long)categories.size());
        IDestinationCategoryDescription cat = (IDestinationCategoryDescription)categories.iterator().next();
        Assert.assertEquals((String)"Unexpected category", (Object)CATEGORY_ID_1, (Object)cat.getId());
    }
}

