/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.platform.discovery.runtime.api.IDisplayableObject;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.ComboSelectorPageObject;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ComboSelectorTest {
    private static final String FIRST_OBJECT_LABEL = "First";
    private static final String SECOND_OBJECT_LABEL = "Second";
    private static final String THIRD_OBJECT_LABEL = "Third";
    private ComboSelectorPageObject<IDisplayableObject> selector;

    @Before
    public void setUp() {
        IDisplayableObject firstObject = this.createDisplayableObject(FIRST_OBJECT_LABEL);
        IDisplayableObject secondObject = this.createDisplayableObject(SECOND_OBJECT_LABEL);
        IDisplayableObject thirdObject = this.createDisplayableObject(THIRD_OBJECT_LABEL);
        List<IDisplayableObject> input = Arrays.asList(firstObject, secondObject, thirdObject);
        this.selector = new ComboSelectorPageObject<IDisplayableObject>(input);
        this.selector.open();
    }

    @After
    public void tearDown() {
        this.selector.close();
    }

    private IDisplayableObject createDisplayableObject(String objectLabel) {
        IDisplayableObject object = (IDisplayableObject)Mockito.mock(IDisplayableObject.class);
        Mockito.stub((Object)object.getDisplayName()).toReturn((Object)objectLabel);
        return object;
    }

    @Test
    public void testCorrectObjectsDisplayed() throws Exception {
        List<String> items = Arrays.asList(this.selector.getItems());
        Assert.assertEquals((String)"Three items expected", (int)3, (int)items.size());
        Assert.assertEquals((String)"Unexpected first item", (String)FIRST_OBJECT_LABEL, (String)items.get(0));
        Assert.assertEquals((String)"Unexpected second item", (String)SECOND_OBJECT_LABEL, (String)items.get(1));
        Assert.assertEquals((String)"Unexpected third item", (String)THIRD_OBJECT_LABEL, (String)items.get(2));
    }

    @Test
    public void testSetInput() throws Exception {
        IDisplayableObject anotherObject = this.createDisplayableObject("ANOTHER_OBJECT");
        ArrayList<IDisplayableObject> newInput = new ArrayList<IDisplayableObject>();
        newInput.add(anotherObject);
        this.selector.setInput(newInput);
        Assert.assertEquals((String)"One item expected", (int)1, (int)this.selector.getItems().length);
        Assert.assertEquals((String)"Unexpeted item", (String)"ANOTHER_OBJECT", (String)this.selector.getItems()[0]);
    }

    @Test
    public void testGetSelectedItem() throws Exception {
        this.selector.select(THIRD_OBJECT_LABEL);
        Assert.assertEquals((String)"Unexpected selected item", (String)THIRD_OBJECT_LABEL, (String)this.selector.getSelectedItem());
    }

    @Test
    public void testHandleSelectionMethod() throws Exception {
        ISelectionChangedListener listener = (ISelectionChangedListener)Mockito.mock(ISelectionChangedListener.class);
        this.selector.registerSelectionListener(listener);
        this.selector.select(SECOND_OBJECT_LABEL);
        ((ISelectionChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).selectionChanged((SelectionChangedEvent)Mockito.argThat(this.eventWithSelection(SECOND_OBJECT_LABEL)));
    }

    @Test
    public void testSetEnabled() {
        Assert.assertTrue((String)"Combo should be enabled by default", (boolean)this.selector.isComboEnabled());
        Assert.assertTrue((String)"Label should be enabled by default", (boolean)this.selector.isLabelEnabled());
        this.selector.setEnabled(false);
        Assert.assertFalse((String)"Combo should be disabled now", (boolean)this.selector.isComboEnabled());
        Assert.assertFalse((String)"Label should be disabled now", (boolean)this.selector.isLabelEnabled());
        this.selector.setEnabled(true);
        Assert.assertTrue((String)"Combo should be enabled now", (boolean)this.selector.isComboEnabled());
        Assert.assertTrue((String)"Label should be enabled now", (boolean)this.selector.isLabelEnabled());
    }

    private Matcher<SelectionChangedEvent> eventWithSelection(final String expectedSelection) {
        return new ArgumentMatcher<SelectionChangedEvent>(){

            public boolean matches(Object argument) {
                SelectionChangedEvent event = (SelectionChangedEvent)argument;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IDisplayableObject selectedObject = (IDisplayableObject)selection.getFirstElement();
                return selection.size() == 1 && expectedSelection.equals(selectedObject.getDisplayName());
            }
        };
    }
}

