/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import java.text.MessageFormat;
import junit.framework.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.platform.discovery.ui.api.IFormTextBuilder;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.ITooltipProvider;
import org.eclipse.platform.discovery.ui.api.impl.GenericViewCustomizationImpl;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.DiscoveredItemsInShellPageObject;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.internal.longop.CurrentThreadOperationRunner;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DiscoveredItemsTreeTest {
    private static final String TOOLTIP_TEMPLATE = "Tooltip for {0}";
    private IGenericViewCustomization viewCustomization;
    private Object displayedItem;
    private DiscoveredItemsInShellPageObject viewerPageObject;

    @Before
    public void setUp() throws Exception {
        this.displayedItem = new Object();
        this.viewCustomization = this.createViewCustomization();
        this.viewerPageObject = new DiscoveredItemsInShellPageObject(this.discoveryEnv(), this.viewCustomization);
        this.viewerPageObject.open();
        this.viewerPageObject.tree().setInput(this.displayedItem);
    }

    @After
    public void tearDown() {
        this.viewerPageObject.close();
    }

    private IGenericViewCustomization createViewCustomization() {
        return new GenericViewCustomizationImpl(){

            public ITreeContentProvider getContentProvider() {
                return new MyContentProvider();
            }

            public ILabelProvider getLabelProvider() {
                return new LabelProvider();
            }

            public ITooltipProvider getTooltipProvider() {
                return new ITooltipProvider(){

                    public void createTooltipContent(IFormTextBuilder tooltipTextBuilder, Object element) {
                        tooltipTextBuilder.appendText(DiscoveredItemsTreeTest.this.tooltipText(element));
                    }
                };
            }
        };
    }

    private IDiscoveryEnvironment discoveryEnv() {
        IDiscoveryEnvironment env = (IDiscoveryEnvironment)Mockito.mock(IDiscoveryEnvironment.class);
        NullProgressMonitor monitor = new NullProgressMonitor();
        Mockito.when((Object)env.progressMonitor()).thenReturn((Object)monitor);
        Mockito.when((Object)env.operationRunner()).thenReturn((Object)new CurrentThreadOperationRunner((IProgressMonitor)monitor));
        return env;
    }

    @Test
    public void testItemIsDisplayed() {
        Assert.assertTrue((String)"Item is not displayed", (boolean)this.viewerPageObject.tree().isTreeItemDisplayed(this.displayedItem.toString()));
    }

    @Test
    public void testTooltip() {
        this.hoverOnTreeItem(this.displayedItem.toString());
        Assert.assertTrue((String)"Tooltip not displayed", (boolean)this.viewerPageObject.tree().isTooltipDisplayed(this.displayedItem.toString()));
        this.moveAwayFromTreeItem(this.displayedItem.toString());
        Assert.assertFalse((String)"Tooltip still displayed", (boolean)this.viewerPageObject.tree().isTooltipDisplayed(this.displayedItem.toString()));
    }

    private String tooltipText(Object object) {
        return MessageFormat.format(TOOLTIP_TEMPLATE, object.toString());
    }

    private void hoverOnTreeItem(Object object) {
        this.viewerPageObject.tree().discoveredTreeItem(object.toString()).hoverMouse();
    }

    private void moveAwayFromTreeItem(Object object) {
        this.viewerPageObject.tree().discoveredTreeItem(object.toString()).moveMouseAway();
    }

    private class MyContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private MyContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getElements(element).length > 0;
        }
    }
}

