/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.platform.discovery.runtime.api.IDisplayableObject;
import org.eclipse.platform.discovery.testutils.utils.pageobjects.InShellPageObject;
import org.eclipse.platform.discovery.ui.internal.selector.ComboSelector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotLabel;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComboSelectorPageObject<T extends IDisplayableObject>
extends InShellPageObject {
    private static final String COMBO_LABEL = "ComboSelectorPageObject";
    private final List<T> comboInput;
    private ComboSelector<T> selector;

    public ComboSelectorPageObject(List<T> comboInput) {
        this.comboInput = comboInput;
    }

    protected void createContent(Shell parent, FormToolkit formToolkit) {
        this.selector = new ComboSelector((Composite)parent, formToolkit, this.comboInput, COMBO_LABEL, 60, null);
    }

    public String[] getItems() {
        return this.combo().items();
    }

    public void select(String item) {
        this.combo().setSelection(item);
    }

    private SWTBotCombo combo() {
        return this.bot().comboBox();
    }

    public void setInput(final Collection<T> input) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ComboSelectorPageObject.this.selector.setInput(input);
            }
        });
    }

    public String getSelectedItem() {
        return this.combo().selection();
    }

    public void registerSelectionListener(ISelectionChangedListener listener) {
        this.selector.registerSelectionChangedListener(listener);
    }

    public boolean isComboEnabled() {
        return this.combo().isEnabled();
    }

    public boolean isLabelEnabled() {
        return this.comboLabel().isEnabled();
    }

    private SWTBotLabel comboLabel() {
        return this.bot().label();
    }

    public void setEnabled(final boolean enabled) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ComboSelectorPageObject.this.selector.setEnabled(enabled);
            }
        });
    }
}

