/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.MultipleWidgetsFoundException;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.utils.RecursiveSiblingFinder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.ChildrenControlFinder;
import org.eclipse.swtbot.swt.finder.finders.ControlFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.ArrayResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class SwtBotUtils {
    public boolean isReadOnly(AbstractSWTBot<? extends Widget> widget) {
        return SWTUtils.hasStyle((Widget)widget.widget, (int)8);
    }

    public void setSize(final AbstractSWTBot<? extends Control> control, final int width, final int height) {
        control.display.syncExec(new Runnable(){

            @Override
            public void run() {
                ((Control)control.widget).setSize(width, height);
            }
        });
    }

    public <ResultType extends Widget> ResultType findOneChildControlOfType(Widget parent, Class<ResultType> clazz, boolean shouldBeVisible) throws WidgetNotFoundException, MultipleWidgetsFoundException {
        return this.findOneChild((ControlFinder)new ChildrenControlFinder(parent), (Matcher<ResultType>)new InstanceOf<ResultType>(clazz), shouldBeVisible);
    }

    public <ResultType extends Widget> ResultType findOneChildControlOfExactType(Widget parent, Class<ResultType> clazz, boolean shouldBeVisible) throws WidgetNotFoundException, MultipleWidgetsFoundException {
        return this.findOneChild((ControlFinder)new ChildrenControlFinder(parent), (Matcher<ResultType>)new ClassEquals<ResultType>(clazz), shouldBeVisible);
    }

    public <ResultType extends Widget> ResultType findOneChildControl(Widget parent, Matcher<ResultType> matcher, boolean shouldBeVisible) throws WidgetNotFoundException, MultipleWidgetsFoundException {
        return this.findOneChild((ControlFinder)new ChildrenControlFinder(parent), matcher, shouldBeVisible);
    }

    private <ResultType extends Widget> ResultType findOneChild(ControlFinder finder, Matcher<ResultType> matcher, boolean shouldBeVisible) {
        finder.shouldFindInVisibleControls = !shouldBeVisible;
        List result = finder.findControls(matcher);
        if (result.size() == 0) {
            throw new WidgetNotFoundException(null);
        }
        if (result.size() > 1) {
            throw new MultipleWidgetsFoundException(result.toString());
        }
        return (ResultType)((Widget)result.get(0));
    }

    public SWTBotShell findShell(Matcher<Shell> shellMather) {
        LinkedList<SWTBotShell> foundShells = new LinkedList<SWTBotShell>();
        SWTBotShell[] sWTBotShellArray = new SWTBot().shells();
        int n = sWTBotShellArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotShell shell = sWTBotShellArray[n2];
            if (shellMather.matches((Object)shell)) {
                foundShells.add(shell);
            }
            ++n2;
        }
        if (foundShells.size() == 0) {
            throw new WidgetNotFoundException(null);
        }
        if (foundShells.size() > 1) {
            throw new MultipleWidgetsFoundException(null);
        }
        return (SWTBotShell)foundShells.iterator().next();
    }

    public <T extends Widget> T findSibling(AbstractSWTBot<? extends Control> siblingWidget, Class<T> targetClass) {
        InstanceOf<T> instanceofMatcher = new InstanceOf<T>(targetClass);
        Widget[] widgetArray = (Widget[])UIThreadRunnable.syncExec((ArrayResult)new RecursiveSiblingFinder((Control)siblingWidget.widget));
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget sibling = widgetArray[n2];
            if (sibling != siblingWidget.widget && instanceofMatcher.matches(sibling)) {
                return (T)sibling;
            }
            ++n2;
        }
        throw new WidgetNotFoundException(MessageFormat.format("No sibling to {0} of type {1} not found", siblingWidget.toString(), targetClass.getSimpleName()));
    }

    private static class ClassEquals<T extends Widget>
    extends BaseMatcher<T> {
        private final Class<T> clazz;

        public ClassEquals(Class<T> clazz) {
            this.clazz = clazz;
        }

        public boolean matches(Object item) {
            return this.clazz.equals(item.getClass());
        }

        public void describeTo(Description description) {
        }
    }

    private static class InstanceOf<T extends Widget>
    extends BaseMatcher<T> {
        private final Class<T> clazz;

        public InstanceOf(Class<T> clazz) {
            this.clazz = clazz;
        }

        public boolean matches(Object item) {
            return this.clazz.isAssignableFrom(item.getClass());
        }

        public void describeTo(Description description) {
        }
    }
}

