/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import org.eclipse.platform.discovery.core.api.ISearchFavoritesMasterController;
import org.eclipse.platform.discovery.core.internal.IContextStructuredSelection;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.internal.dnd.LocalContextSelectionTransfer;
import org.eclipse.platform.discovery.ui.internal.view.dnd.IDndInteractionEvent;
import org.eclipse.platform.discovery.ui.internal.view.impl.FavoritesDropInteractionListener;
import org.eclipse.platform.discovery.ui.test.unit.internal.dnd.DndTestFixture;
import org.eclipse.swt.dnd.Transfer;
import org.jmock.core.Constraint;

public class FavoritesDropInteractionListenerForLocalSelectionTest
extends MockObjectTestCase {
    private DndTestFixture.TestDNDInteractionEvent dropEvent;
    private FavoritesDropInteractionListener dropListener;
    private Mock<ISearchFavoritesMasterController> controller;
    private Mock<IContextStructuredSelection> selection;

    protected void setUp() throws Exception {
        this.dropEvent = new DndTestFixture.TestDNDInteractionEvent();
        this.controller = this.mock(ISearchFavoritesMasterController.class);
        this.selection = this.mock(IContextStructuredSelection.class);
        this.dropEvent.setDataType(LocalContextSelectionTransfer.getTransfer().getSupportedTypes()[0]);
        LocalContextSelectionTransfer.getTransfer().setSelection((IContextStructuredSelection)this.selection.proxy());
        this.dropListener = new FavoritesDropInteractionListener(new Transfer[]{LocalContextSelectionTransfer.getTransfer()}, (ISearchFavoritesMasterController)this.controller.proxy());
    }

    public void testDragEnterWithSupportedDataTypeAndAcceptableSelection() {
        this.controller.expects(this.once()).method("isImportPossible").with((Constraint)this.same(this.selection.proxy())).will(this.returnValue(true));
        this.dropListener.start((IDndInteractionEvent)this.dropEvent);
        FavoritesDropInteractionListenerForLocalSelectionTest.assertTrue((String)"DND.DROP_DEFAULT not set to event datail", (this.dropEvent.getInteractionDetail() == 16 ? 1 : 0) != 0);
    }

    public void testDragEnterWithSupportedDataTypeAndUnacceptableSelection() {
        this.controller.expects(this.once()).method("isImportPossible").with((Constraint)this.same(this.selection.proxy())).will(this.returnValue(false));
        this.dropListener.start((IDndInteractionEvent)this.dropEvent);
        FavoritesDropInteractionListenerForLocalSelectionTest.assertTrue((String)"DND.DROP_DEFAULT not set to event datail", (this.dropEvent.getInteractionDetail() == 0 ? 1 : 0) != 0);
    }
}

