/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import org.eclipse.platform.discovery.core.api.ISearchFavoritesMasterController;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.internal.view.dnd.IDndInteractionEvent;
import org.eclipse.platform.discovery.ui.internal.view.impl.FavoritesDropInteractionListener;
import org.eclipse.platform.discovery.ui.test.unit.internal.dnd.DndTestFixture;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.jmock.core.Constraint;

public class FavoritesDropInteractionListenerTest
extends MockObjectTestCase {
    private FavoritesDropInteractionListener dropListener;
    private DndTestFixture.TestDNDInteractionEvent dropEvent;
    private TransferData transferData;
    private Transfer transfer1;
    private Mock<DndTestFixture.IRunnableWithResult<Boolean, TransferData>> transfer1SupportedDataTypeRunnable;
    private Transfer transfer2;
    private Mock<DndTestFixture.IRunnableWithResult<Boolean, TransferData>> transfer2SupportedDataTypeRunnable;
    private Mock<ISearchFavoritesMasterController> controller;

    protected void setUp() throws Exception {
        this.transferData = new TransferData();
        this.transfer1SupportedDataTypeRunnable = this.mock(DndTestFixture.IRunnableWithResult.class);
        this.transfer1 = new DndTestFixture.TestTransfer((DndTestFixture.IRunnableWithResult)this.transfer1SupportedDataTypeRunnable.proxy());
        this.transfer2SupportedDataTypeRunnable = this.mock(DndTestFixture.IRunnableWithResult.class);
        this.transfer2SupportedDataTypeRunnable.stubs().method("run").with((Constraint)this.eq(this.transferData)).will(this.returnValue(false));
        this.transfer2 = new DndTestFixture.TestTransfer((DndTestFixture.IRunnableWithResult)this.transfer2SupportedDataTypeRunnable.proxy());
        this.controller = this.mock(ISearchFavoritesMasterController.class);
        this.dropListener = new FavoritesDropInteractionListener(new Transfer[]{this.transfer1, this.transfer2}, (ISearchFavoritesMasterController)this.controller.proxy());
        this.dropEvent = new DndTestFixture.TestDNDInteractionEvent();
        this.dropEvent.setDataType(this.transferData);
    }

    public void testDragEnterWithUnsupportedDataType() {
        this.transfer1SupportedDataTypeRunnable.stubs().method("run").with((Constraint)this.eq(this.transferData)).will(this.returnValue(false));
        this.dropListener.start((IDndInteractionEvent)this.dropEvent);
        FavoritesDropInteractionListenerTest.assertTrue((String)"DND.DROP_NONE not set to event datail", (this.dropEvent.getInteractionDetail() == 0 ? 1 : 0) != 0);
    }

    public void testDropFiresEvent() {
        this.controller.expects(this.once()).method("importData").with((Constraint)this.same(this.dropEvent.getData()));
        this.dropListener.process((IDndInteractionEvent)this.dropEvent);
    }
}

