/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.platform.discovery.core.internal.selectors.IItemSelector;
import org.eclipse.platform.discovery.runtime.api.IDestinationChangeHandler;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchConsoleDestinationsSelector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jmock.core.Constraint;

public class SearchConsoleDestinationsSelectorTest
extends MockObjectTestCase {
    private SearchConsoleDestinationsSelector selector;
    private Mock<ISearchProviderConfiguration> searchProviderConfig;
    private Mock<IDestinationChangeHandler> destinationsChangeHandler;
    private FormToolkit formToolkit;
    private Composite parentComposite;
    private Mock<IItemSelector<ISearchDestination, IDestinationCategoryDescription>> selectionChangeHandlerChecker;
    private Mock<IDestinationCategoryDescription> firstDestinationCategory;
    private Mock<IDestinationsProviderDescription> firstDestProviderDescription;
    private Mock<IDestinationsProvider> firstDestinationsProvider;
    private Mock<IDestinationCategoryDescription> secondDestinationCategory;
    private Mock<IDestinationsProviderDescription> secondDestProviderDescription;
    private Mock<IDestinationsProvider> secondDestinationsProvider;
    private Mock<ISearchDestination> searchDestination;

    protected void setUp() throws Exception {
        this.setupSearchProviderConfig();
        this.destinationsChangeHandler = this.mock(IDestinationChangeHandler.class);
        this.selectionChangeHandlerChecker = this.mock(IItemSelector.class);
        this.formToolkit = new FormToolkit(PlatformUI.getWorkbench().getDisplay());
        this.parentComposite = this.formToolkit.createComposite((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.selector = new SearchConsoleDestinationsSelector(this.parentComposite, this.formToolkit, 10, (Control)new Composite(this.parentComposite, 0), (ISearchProviderConfiguration)this.searchProviderConfig.proxy()){

            public void handleSelectionChange(ISearchDestination newSelection) {
                ((IItemSelector)SearchConsoleDestinationsSelectorTest.this.selectionChangeHandlerChecker.proxy()).handleSelectionChange((Object)newSelection);
            }
        };
        this.selector.registerDestinationsChangeHandler((IDestinationChangeHandler)this.destinationsChangeHandler.proxy());
        super.setUp();
    }

    private void setupSearchProviderConfig() {
        this.searchProviderConfig = this.mock(ISearchProviderConfiguration.class);
        this.firstDestinationCategory = this.mock(IDestinationCategoryDescription.class);
        this.firstDestinationCategory.stubs().method("getDisplayName").will(this.returnValue("FirstDestinationCategory"));
        this.secondDestinationCategory = this.mock(IDestinationCategoryDescription.class);
        this.secondDestinationCategory.stubs().method("getDisplayName").will(this.returnValue("FirstDestinationCategory"));
        this.firstDestProviderDescription = this.mock(IDestinationsProviderDescription.class);
        this.secondDestProviderDescription = this.mock(IDestinationsProviderDescription.class);
        this.firstDestinationsProvider = this.mock(IDestinationsProvider.class);
        this.secondDestinationsProvider = this.mock(IDestinationsProvider.class);
        this.searchDestination = this.mock(ISearchDestination.class);
        this.searchDestination.stubs().method("getDisplayName").will(this.returnValue("SearchDestination"));
        this.firstDestProviderDescription.stubs().method("createProvider").will(this.returnValue(this.firstDestinationsProvider.proxy()));
        this.secondDestProviderDescription.stubs().method("createProvider").will(this.returnValue(this.secondDestinationsProvider.proxy()));
        ArrayList<IDestinationsProviderDescription> allDestProviders = new ArrayList<IDestinationsProviderDescription>();
        allDestProviders.add((IDestinationsProviderDescription)this.firstDestProviderDescription.proxy());
        this.searchProviderConfig.stubs().method("getDestinationProvidersForCategory").with((Constraint)this.eq(this.firstDestinationCategory.proxy())).will(this.returnValue(allDestProviders));
        ArrayList<IDestinationsProviderDescription> allDestProviders_2 = new ArrayList<IDestinationsProviderDescription>();
        allDestProviders_2.add((IDestinationsProviderDescription)this.secondDestProviderDescription.proxy());
        this.searchProviderConfig.stubs().method("getDestinationProvidersForCategory").with((Constraint)this.eq(this.secondDestinationCategory.proxy())).will(this.returnValue(allDestProviders_2));
        ArrayList<ISearchDestination> allDestinations = new ArrayList<ISearchDestination>();
        allDestinations.add((ISearchDestination)this.searchDestination.proxy());
        this.searchProviderConfig.stubs().method("getSearchDestinations").with((Constraint)this.eq(this.firstDestinationCategory.proxy()), (Constraint)this.eq(this.firstDestinationsProvider.proxy())).will(this.returnValue(allDestinations));
        this.searchProviderConfig.stubs().method("getSearchDestinations").with((Constraint)this.eq(this.secondDestinationCategory.proxy()), (Constraint)this.eq(this.secondDestinationsProvider.proxy())).will(this.returnValue(allDestinations));
    }

    public void testSetInputRegistersChangeHandler() {
        this.firstDestinationsProvider.expects(this.once()).method("registerDestinationsChangeHandler").with((Constraint)this.same(this.destinationsChangeHandler.proxy()));
        this.selectionChangeHandlerChecker.stubs().method("handleSelectionChange");
        this.selector.setInput(Arrays.asList((IDestinationCategoryDescription)this.firstDestinationCategory.proxy()));
    }

    public void testChangingInputUnregistersChangeHandler() {
        this.testSetInputRegistersChangeHandler();
        this.firstDestinationsProvider.verify();
        this.firstDestinationsProvider.reset();
        this.firstDestinationsProvider.expects(this.once()).method("unregisterDestinationsChangeHandler").with((Constraint)this.same(this.destinationsChangeHandler.proxy()));
        this.secondDestinationsProvider.expects(this.once()).method("registerDestinationsChangeHandler").with((Constraint)this.same(this.destinationsChangeHandler.proxy()));
        this.selectionChangeHandlerChecker.expects(this.once()).method("handleSelectionChange");
        this.selector.setInput(Arrays.asList((IDestinationCategoryDescription)this.secondDestinationCategory.proxy()));
    }

    public void testDisposeUnregistersListeners() {
        this.testSetInputRegistersChangeHandler();
        this.firstDestinationsProvider.verify();
        this.firstDestinationsProvider.reset();
        this.firstDestinationsProvider.expects(this.once()).method("unregisterDestinationsChangeHandler").with((Constraint)this.same(this.destinationsChangeHandler.proxy()));
        this.parentComposite.dispose();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.firstDestinationsProvider.reset();
        this.secondDestinationsProvider.reset();
        this.firstDestinationsProvider.stubs().method("unregisterDestinationsChangeHandler");
        this.secondDestinationsProvider.stubs().method("unregisterDestinationsChangeHandler");
        this.formToolkit.dispose();
    }
}

