/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.internal.view.impl.DisplayableObjectsContentProvider;

public class SearchForListContentProviderTest
extends MockObjectTestCase {
    private static final String OBJECT_TYPE1 = "objectType1";
    private static final String OBJECT_TYPE2 = "objectType2";
    private static final String OBJECT_TYPE3 = "objectType3";
    private DisplayableObjectsContentProvider<IObjectTypeDescription> contentProvider;
    private Mock<ISearchProviderConfiguration> searchProviderConfig;

    protected void setUp() throws Exception {
        this.searchProviderConfig = this.mock(ISearchProviderConfiguration.class);
        ArrayList<IObjectTypeDescription> objects = new ArrayList<IObjectTypeDescription>();
        objects.add(this.createObjectTypeWithId(OBJECT_TYPE1));
        objects.add(this.createObjectTypeWithId(OBJECT_TYPE2));
        objects.add(this.createObjectTypeWithId(OBJECT_TYPE3));
        this.searchProviderConfig.stubs().method("getObjectTypes").will(this.returnValue(objects));
        this.contentProvider = new DisplayableObjectsContentProvider(objects);
        this.contentProvider.inputChanged(null, null, objects);
    }

    public void testGetElements() {
        HashSet<String> expectedIds = new HashSet<String>(Arrays.asList(OBJECT_TYPE1, OBJECT_TYPE2, OBJECT_TYPE3));
        Object[] result = this.contentProvider.getElements(null);
        SearchForListContentProviderTest.assertEquals((int)expectedIds.size(), (int)result.length);
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object entry = objectArray[n2];
            IObjectTypeDescription objectType = (IObjectTypeDescription)entry;
            SearchForListContentProviderTest.assertTrue((boolean)expectedIds.contains(objectType.getId()));
            ++n2;
        }
    }

    private IObjectTypeDescription createObjectTypeWithId(String id) {
        Mock object = this.mock(IObjectTypeDescription.class);
        object.stubs().method("getId").will(this.returnValue(id));
        object.stubs().method("getDisplayName").will(this.returnValue(id));
        return (IObjectTypeDescription)object.proxy();
    }
}

