/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.platform.discovery.runtime.api.IDisplayableObject;

public class DisplayableObjectsContentProvider<T extends IDisplayableObject>
implements IStructuredContentProvider {
    private List<T> curentInput;

    public DisplayableObjectsContentProvider(List<T> input) {
        this.curentInput = input;
    }

    public Object[] getElements(Object inputElement) {
        return this.sortElements(this.curentInput);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.curentInput = (List)newInput;
    }

    protected Object[] sortElements(List<T> elements) {
        ArrayList<T> objectsList = new ArrayList<T>(elements);
        Collections.sort(objectsList, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return objectsList.toArray();
    }
}

