/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.longop;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.api.longop.LongOpCanceledException;
import org.eclipse.platform.discovery.util.internal.longop.ModalContextLongOpRunner;
import org.eclipse.platform.discovery.util.internal.longop.SingleForkThreadRunnerTests;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ModalContextOpRunnerTests
extends TestSuite {
    protected Mock<ISchedulingRule> ruleMock;
    private static Mock<Set<Thread>> trackerThatCouldBeaccessedBeforeTheSuperConstructor;

    public static Test suite() {
        ModalContextOpRunnerTests tests = new ModalContextOpRunnerTests();
        tests.addTestSuite(WithNoNestedOp.class);
        tests.addTestSuite(WithSubOpTest.class);
        tests.addTestSuite(DoesNotForkWhenAlreadyRunningInModalContext.class);
        return tests;
    }

    public static class DoesNotForkWhenAlreadyRunningInModalContext
    extends MockObjectTestCase {
        public void testDoesNotFork() throws InvocationTargetException, InterruptedException {
            DoesNotForkWhenAlreadyRunningInModalContext.assertFalse((String)"Test has to be rune outside ModalContext thread", (boolean)ModalContext.isModalContextThread((Thread)Thread.currentThread()));
            ModalContextLongOpRunner runner = new ModalContextLongOpRunner((IProgressMonitor)new NullProgressMonitor(), this.createSchedulingRule());
            IRunnableWithProgress testRunnable = new IRunnableWithProgress((ILongOperationRunner)runner){
                private final /* synthetic */ ILongOperationRunner val$runner;
                {
                    this.val$runner = iLongOperationRunner;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DoesNotForkWhenAlreadyRunningInModalContext.assertTrue((String)"Runnable needs to be executed in ModalContext", (boolean)ModalContext.isModalContextThread((Thread)Thread.currentThread()));
                    ILongOperation checkOperation = DoesNotForkWhenAlreadyRunningInModalContext.this.createCheckSameThreadOperation(Thread.currentThread());
                    try {
                        this.val$runner.run(checkOperation);
                    }
                    catch (LongOpCanceledException e) {
                        throw new IllegalStateException("Unexpected exception", e);
                    }
                }
            };
            ModalContext.run((IRunnableWithProgress)testRunnable, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (Display)PlatformUI.getWorkbench().getDisplay());
        }

        private ILongOperation<Void> createCheckSameThreadOperation(final Thread thread) {
            return new ILongOperation<Void>(){

                public Void run(IProgressMonitor monitor) throws LongOpCanceledException, Exception {
                    if (thread != Thread.currentThread()) {
                        throw new IllegalStateException("Not in same thread");
                    }
                    return null;
                }
            };
        }

        private ISchedulingRule createSchedulingRule() {
            return new ISchedulingRule(){

                public boolean contains(ISchedulingRule rule) {
                    return rule == this;
                }

                public boolean isConflicting(ISchedulingRule rule) {
                    return rule == this;
                }
            };
        }
    }

    private static class TestModalContextOpRunner
    extends ModalContextLongOpRunner {
        public TestModalContextOpRunner(IProgressMonitor monitor, ISchedulingRule rule, Set<Thread> tracker) {
            super(monitor, rule);
        }

        protected void runInModalContext(IRunnableWithProgress rp, IProgressMonitor m) throws InvocationTargetException, InterruptedException {
            rp.run(m);
        }

        protected Set<Thread> newThreadTracker() {
            return (Set)trackerThatCouldBeaccessedBeforeTheSuperConstructor.proxy();
        }

        protected ILongOperationRunner newSchedulingRuleSynchRunner(ILongOperationRunner wrapped, ISchedulingRule rule) {
            return new TestSchedulingRuleOpRunner(wrapped);
        }
    }

    private static class TestSchedulingRuleOpRunner
    implements ILongOperationRunner {
        ILongOperationRunner wrapped;

        public TestSchedulingRuleOpRunner(ILongOperationRunner wrapped) {
            this.wrapped = wrapped;
        }

        public <T> T run(ILongOperation<T> op) throws LongOpCanceledException, InvocationTargetException {
            return (T)this.wrapped.run(op);
        }
    }

    public static class WithNoNestedOp
    extends SingleForkThreadRunnerTests.WithNoNestedOp {
        @Override
        protected Mock<Set<Thread>> createThreadTracker() {
            Mock<Set<Thread>> mock = super.createThreadTracker();
            trackerThatCouldBeaccessedBeforeTheSuperConstructor = mock;
            return mock;
        }

        @Override
        public void setUp() throws Exception {
            super.setUp();
        }

        @Override
        protected ILongOperationRunner newRunner(IProgressMonitor monitor) {
            Mock ruleMock = this.mock(ISchedulingRule.class);
            return new TestModalContextOpRunner(monitor, (ISchedulingRule)ruleMock.proxy(), (Set)this.trackerMock.proxy());
        }
    }

    public static class WithSubOpTest
    extends SingleForkThreadRunnerTests.WithSubOpTest {
        @Override
        protected Mock<Set<Thread>> createThreadTracker() {
            Mock<Set<Thread>> mock = super.createThreadTracker();
            trackerThatCouldBeaccessedBeforeTheSuperConstructor = mock;
            return mock;
        }

        @Override
        public void setUp() throws Exception {
            super.setUp();
        }

        @Override
        protected ILongOperationRunner newRunner(IProgressMonitor monitor) {
            Mock ruleMock = this.mock(ISchedulingRule.class);
            return new TestModalContextOpRunner(monitor, (ISchedulingRule)ruleMock.proxy(), (Set)this.trackerMock.proxy());
        }
    }
}

