/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import java.util.List;
import org.eclipse.platform.discovery.util.internal.property.Access;
import org.eclipse.platform.discovery.util.internal.property.AccessAttributeTests;
import org.eclipse.platform.discovery.util.internal.property.IListProperty;
import org.eclipse.platform.discovery.util.internal.property.IProperty;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.ListProperty;

public class ListPropertyListAccessTest
extends AccessAttributeTests<List<Object>, Access> {
    @Override
    protected Access getAttributeValue(IProperty<List<Object>> p) {
        IListProperty lp = (IListProperty)p;
        return lp.getListAccess();
    }

    @Override
    protected Access getDefaultValue() {
        return Access.READ_WRITE;
    }

    @Override
    protected Access newAttributeDifferentThen(Access differentThen) {
        return Access.values()[(differentThen.ordinal() + 1) % Access.values().length];
    }

    @Override
    protected Access newNonDefaultAttributeValue() {
        return Access.READ_ONLY;
    }

    @Override
    protected IProperty<List<Object>> newTarget() {
        return new ListProperty();
    }

    @Override
    protected void registerAttributeListener(IProperty<List<Object>> target, IPropertyAttributeListener<Access> listener, boolean current) {
        IListProperty lp = (IListProperty)target;
        lp.registerListAccessListener(listener, current);
    }

    @Override
    protected boolean removeAttributeListener(IProperty<List<Object>> target, IPropertyAttributeListener<Access> listener) {
        IListProperty lp = (IListProperty)target;
        return lp.removeListAccesssListener(listener);
    }

    @Override
    protected void setAttributeValue(IProperty<List<Object>> p, Access attribute) {
        IListProperty lp = (IListProperty)p;
        lp.setListAccess(attribute);
    }
}

