/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.longop;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.api.longop.LongOpCanceledException;
import org.eclipse.platform.discovery.util.internal.longop.SchedulingRuleSynchRunner;
import org.eclipse.platform.discovery.util.internal.longop.SingleForkThreadRunner;
import org.eclipse.swt.widgets.Display;

public class ModalContextLongOpRunner
implements ILongOperationRunner {
    private final IProgressMonitor monitor;
    private final ISchedulingRule rule;
    private final Set<Thread> threadTracker;

    public ModalContextLongOpRunner(IProgressMonitor monitor, ISchedulingRule rule) {
        this.monitor = monitor;
        this.rule = rule;
        this.threadTracker = this.newThreadTracker();
    }

    @Override
    public <T> T run(ILongOperation<T> op) throws LongOpCanceledException, InvocationTargetException {
        return this.newSchedulingRuleSynchRunner(new ModalThreadForker(this.monitor), this.rule).run(op);
    }

    protected ILongOperationRunner newSchedulingRuleSynchRunner(ILongOperationRunner wrapped, ISchedulingRule rule) {
        return new SchedulingRuleSynchRunner(wrapped, rule, Job.getJobManager());
    }

    protected void runInModalContext(IRunnableWithProgress rp, IProgressMonitor m) throws InvocationTargetException, InterruptedException {
        ModalContext.run((IRunnableWithProgress)rp, (boolean)true, (IProgressMonitor)m, (Display)Display.getDefault());
    }

    protected Set<Thread> newThreadTracker() {
        return new HashSet<Thread>();
    }

    private <T> IRunnableWithProgress longOpToRunnable(final T[] resHolder, final ILongOperation<T> op) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    resHolder[0] = op.run(monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    private class ModalThreadForker
    extends SingleForkThreadRunner {
        public ModalThreadForker(IProgressMonitor monitor) {
            super(monitor, ModalContextLongOpRunner.this.threadTracker);
        }

        @Override
        protected boolean shouldRunInSameThread() {
            return ModalContext.isModalContextThread((Thread)this.currentThread()) || super.shouldRunInSameThread();
        }

        @Override
        public <T> T runInNewThread(ILongOperation<T> op) throws LongOpCanceledException, InvocationTargetException {
            Object[] resHolder = new Object[1];
            try {
                ModalContextLongOpRunner.this.runInModalContext(ModalContextLongOpRunner.this.longOpToRunnable(resHolder, op), ModalContextLongOpRunner.this.monitor);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof LongOpCanceledException) {
                    throw (LongOpCanceledException)e.getCause();
                }
                throw e;
            }
            return (T)resHolder[0];
        }
    }
}

