/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.longop;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.api.longop.LongOpCanceledException;
import org.eclipse.platform.discovery.util.internal.longop.ExceptionHelper;

public abstract class SingleForkThreadRunner
implements ILongOperationRunner {
    private final Set<Thread> threadTracker;
    private final IProgressMonitor monitor;

    public SingleForkThreadRunner(IProgressMonitor monitor, Set<Thread> threadTracker) {
        this.monitor = monitor;
        this.threadTracker = threadTracker;
    }

    public abstract <T> T runInNewThread(ILongOperation<T> var1) throws LongOpCanceledException, InvocationTargetException;

    @Override
    public <T> T run(ILongOperation<T> op) throws LongOpCanceledException, InvocationTargetException {
        if (this.shouldRunInSameThread()) {
            return this.runInSameThread(op);
        }
        return this.runInNewThread(new ThreadTrackingDecorator<T>(op));
    }

    protected boolean shouldRunInSameThread() {
        return this.threadTracker.contains(Thread.currentThread());
    }

    protected Thread currentThread() {
        return Thread.currentThread();
    }

    private <T> T runInSameThread(ILongOperation<T> op) throws LongOpCanceledException, InvocationTargetException {
        try {
            return op.run((IProgressMonitor)new SubProgressMonitor(this.monitor, 0));
        }
        catch (Exception e) {
            throw ExceptionHelper.rethrow(e);
        }
    }

    private class ThreadTrackingDecorator<T>
    implements ILongOperation<T> {
        private final ILongOperation<T> target;

        public ThreadTrackingDecorator(ILongOperation<T> target) {
            this.target = target;
        }

        @Override
        public T run(IProgressMonitor monitor) throws LongOpCanceledException, Exception {
            SingleForkThreadRunner.this.threadTracker.add(SingleForkThreadRunner.this.currentThread());
            try {
                T t = this.target.run(monitor);
                return t;
            }
            finally {
                SingleForkThreadRunner.this.threadTracker.remove(SingleForkThreadRunner.this.currentThread());
            }
        }
    }
}

