/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import java.util.ListIterator;
import org.eclipse.platform.discovery.util.internal.property.Access;
import org.eclipse.platform.discovery.util.internal.property.IListProperty;

public class AccessCheckingListIterator<T>
implements ListIterator<T> {
    private final ListIterator<T> delegate;
    private final IListProperty<T> property;

    public AccessCheckingListIterator(IListProperty<T> property, ListIterator<T> delegate) {
        this.delegate = delegate;
        this.property = property;
    }

    @Override
    public void add(T o) {
        this.assertCanWrite();
        this.delegate.add(o);
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.delegate.hasPrevious();
    }

    @Override
    public T next() {
        return this.delegate.next();
    }

    @Override
    public int nextIndex() {
        return this.delegate.nextIndex();
    }

    @Override
    public T previous() {
        return this.delegate.previous();
    }

    @Override
    public int previousIndex() {
        return this.delegate.previousIndex();
    }

    @Override
    public void remove() {
        this.assertCanWrite();
        this.delegate.remove();
    }

    @Override
    public void set(T o) {
        this.assertCanWrite();
        this.delegate.set(o);
    }

    private void assertCanWrite() {
        if (Access.READ_WRITE != this.property.getListAccess()) {
            throw new UnsupportedOperationException(this.property.getListAccess().name());
        }
    }
}

