/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.ui.KeyValuePair;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.internal.resources.semantic.ui.PropertiesContentProvider;
import org.eclipse.core.internal.resources.semantic.ui.PropertiesLabelProvider;
import org.eclipse.core.internal.resources.semantic.ui.SemanticResourcesUIPlugin;
import org.eclipse.core.internal.resources.semantic.ui.util.SFSBrowserTreeObject;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class SemanticResourcePropertyPage
extends PropertyPage {
    public SemanticResourcePropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        ISemanticResource node = (ISemanticResource)this.getElement().getAdapter(ISemanticResource.class);
        final TreeViewer tv = new TreeViewer(parent, 68354);
        PropertiesContentProvider.initTree(tv, 400);
        tv.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        tv.setContentProvider((IContentProvider)new PropertiesContentProvider());
        tv.getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                SemanticResourcePropertyPage.this.buildMenu(tv.getTree(), e);
            }
        });
        try {
            SFSBrowserTreeObject ob = new SFSBrowserTreeObject(EFS.getFileSystem((String)"semanticfs"), node.getAdaptedResource().getFullPath());
            tv.setInput((Object)ob);
        }
        catch (CoreException e) {
            SemanticResourcesUIPlugin.handleError(e.getMessage(), e, false);
        }
        tv.expandAll();
        return tv.getTree();
    }

    void buildMenu(Tree tree, MenuDetectEvent e) {
        TreeItem[] selected;
        Menu menu = tree.getMenu();
        if (menu != null) {
            menu.dispose();
        }
        if ((selected = tree.getSelection()).length == 1) {
            TreeItem item = selected[0];
            if (item.getData() instanceof KeyValuePair) {
                menu = new Menu((Control)tree);
                tree.setMenu(menu);
                final KeyValuePair kvp = (KeyValuePair)item.getData();
                MenuItem menuItem = new MenuItem(menu, 8);
                menuItem.setText(Messages.PropertySection_CopyValue_XMIT);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        Clipboard clip = null;
                        try {
                            clip = new Clipboard(Display.getCurrent());
                            clip.setContents((Object[])new String[]{kvp.getValue()}, new Transfer[]{TextTransfer.getInstance()});
                        }
                        finally {
                            if (clip != null) {
                                clip.dispose();
                            }
                        }
                    }
                });
                menuItem = new MenuItem(menu, 8);
                menuItem.setText(Messages.PropertySection_CopyKeyAndValue_XMIT);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        Clipboard clip = null;
                        try {
                            clip = new Clipboard(Display.getCurrent());
                            clip.setContents((Object[])new String[]{String.valueOf(kvp.getKey()) + "\t" + kvp.getValue()}, new Transfer[]{TextTransfer.getInstance()});
                        }
                        finally {
                            if (clip != null) {
                                clip.dispose();
                            }
                        }
                    }
                });
            }
        } else if (selected.length > 1) {
            final String linebreak = System.getProperty("line.separator");
            menu = new Menu((Control)tree);
            tree.setMenu(menu);
            MenuItem item = new MenuItem(menu, 8);
            item.setText(Messages.SemanticResourcePropertyPage_CopySelection_XMIT);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    StringBuilder sb = new StringBuilder();
                    TreeItem[] treeItemArray = selected;
                    int n = selected.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem actItem = treeItemArray[n2];
                        if (actItem.getData() instanceof KeyValuePair) {
                            KeyValuePair pair = (KeyValuePair)actItem.getData();
                            sb.append(String.valueOf(pair.getKey()) + "\t" + pair.getValue());
                            sb.append(linebreak);
                        } else if (actItem.getData() instanceof String) {
                            sb.append((String)actItem.getData());
                            sb.append(linebreak);
                        }
                        ++n2;
                    }
                    if (sb.length() > linebreak.length()) {
                        sb.setLength(sb.length() - linebreak.length());
                    }
                    Clipboard clip = null;
                    try {
                        clip = new Clipboard(Display.getCurrent());
                        clip.setContents((Object[])new String[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
                    }
                    finally {
                        if (clip != null) {
                            clip.dispose();
                        }
                    }
                }
            });
        }
    }
}

