/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.internal.resources.semantic.ui.actions.ActionBase;
import org.eclipse.core.internal.resources.semantic.ui.actions.Messages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;

public class SynchronizeAction
extends ActionBase {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.checkSelectionNonLocalOnly());
    }

    public void run(IAction action) {
        IRunnableWithProgress outerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor outerMonitor) throws InvocationTargetException, InterruptedException {
                for (final ISemanticResource resource : SynchronizeAction.this.getSelection()) {
                    outerMonitor.subTask(NLS.bind((String)Messages.SynchronizeAction_Synchronizing_XMSG, (Object)resource.getAdaptedResource().getName()));
                    if (outerMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    IWorkspaceRunnable wsRunnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            resource.synchronizeContentWithRemote(SyncDirection.BOTH, 0, monitor);
                        }
                    };
                    try {
                        IWorkspace ws = ResourcesPlugin.getWorkspace();
                        ISchedulingRule rule = ws.getRuleFactory().refreshRule(resource.getAdaptedResource());
                        ResourcesPlugin.getWorkspace().run(wsRunnable, rule, 1, outerMonitor);
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce, NLS.bind((String)Messages.SynchronizeAction_SyncFailedForResource_XMSG, (Object)resource.getAdaptedResource().getFullPath().toString()));
                    }
                }
            }
        };
        this.run(outerRunnable);
    }
}

