/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.tools.context.spy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.internal.tools.context.spy.ContextDataProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

@Creatable
@Singleton
public class ContextDataFilter
extends ViewerFilter {
    @Inject
    Logger log;
    private String pattern;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean mustKeepElement;
        if (element == "Local values managed  by this context" || element == "Inherited values injected or updated using this context") {
            return true;
        }
        TreeViewer tv = (TreeViewer)viewer;
        ContextDataProvider lpkey = (ContextDataProvider)tv.getLabelProvider(0);
        ContextDataProvider lpval = (ContextDataProvider)tv.getLabelProvider(1);
        String skey = lpkey.getText(element);
        String sval = lpval.getText(element);
        String sparentkey = lpkey.getText(parentElement);
        String sparentval = lpval.getText(parentElement);
        Set<Computation> listeners = lpkey.getListeners(parentElement);
        boolean mustKeepParent = (this.matchText(sparentkey) || this.matchText(sparentval)) && listeners != null && listeners.size() > 0;
        boolean bl = mustKeepElement = this.matchText(skey) || this.matchText(sval);
        return mustKeepElement || !mustKeepElement && mustKeepParent;
    }

    public void setPattern(String newPattern) {
        this.pattern = newPattern == null || newPattern.length() == 0 ? null : newPattern.toLowerCase();
    }

    public boolean containsText(IEclipseContext ctx) {
        Collection<String> values = this.computeValues(ctx);
        boolean found = false;
        for (String s : values) {
            if (!this.matchText(s)) continue;
            found = true;
            break;
        }
        return found;
    }

    public boolean matchText(String text) {
        return text == null || this.pattern == null ? false : text.toLowerCase().contains(this.pattern);
    }

    private Collection<String> computeValues(IEclipseContext ctx) {
        ArrayList<String> result = new ArrayList<String>();
        if (ctx instanceof EclipseContext) {
            EclipseContext currentContext = (EclipseContext)ctx;
            this.extractStringsFromMap(currentContext.localData(), result);
            this.extractStringsFromMap(currentContext.localContextFunction(), result);
            Set localKeys = currentContext.localData().keySet();
            Set localContextFunctionsKeys = currentContext.localContextFunction().keySet();
            if (currentContext.getRawListenerNames() != null) {
                for (String name : currentContext.getRawListenerNames()) {
                    if (localKeys.contains(name) || localContextFunctionsKeys.contains(name)) continue;
                    result.add(name);
                }
            }
        } else {
            this.log.warn("Warning : the received EclipseContext has not the expected type. It is a : " + ctx.getClass().toString());
        }
        return result;
    }

    private void extractStringsFromMap(Map<String, Object> map, Collection<String> result) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.add(entry.getKey().toString());
            Object value = entry.getValue();
            if (value == null) continue;
            result.add(value.toString());
        }
    }
}

