/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.context.spy;

import java.net.URL;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.internal.tools.context.spy.ContextDataFilter;
import org.eclipse.e4.internal.tools.context.spy.ContextDataPart;
import org.eclipse.e4.internal.tools.context.spy.ContextSpyHelper;
import org.eclipse.e4.internal.tools.context.spy.ContextSpyProvider;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ContextSpyPart {
    private static final String ICON_COLLAPSEALL = "icons/collapseall.gif";
    private static final String ICON_EXPANDALL = "icons/expandall.gif";
    private static final String ICON_REFRESH = "icons/refresh.gif";
    static final String CONTEXT_SPY_VIEW_DESC = "org.eclipse.e4.tools.context.spy.view";
    private TreeViewer contextTreeViewer;
    @Inject
    private ESelectionService selService;
    private ContextSpyProvider treeContentProvider;
    private ImageRegistry imgReg;
    @Inject
    private ContextDataFilter contextFilter;
    private ContextDataPart contextDataPart;
    private Button showOnlyFilteredElements;
    private Text filterText;
    private static String lastFilterText = null;
    private static boolean lastShowFiltered = false;

    @Inject
    private void initializeImageRegistry() {
        Bundle b = FrameworkUtil.getBundle(this.getClass());
        this.imgReg = new ImageRegistry();
        this.imgReg.put(ICON_COLLAPSEALL, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_COLLAPSEALL)));
        this.imgReg.put(ICON_EXPANDALL, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_EXPANDALL)));
        this.imgReg.put(ICON_REFRESH, ImageDescriptor.createFromURL((URL)b.getEntry(ICON_REFRESH)));
    }

    @PostConstruct
    public void createControls(Composite parent, MApplication a, IEclipseContext ctx) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(7, false));
        Button refreshButton = new Button(comp, 0x800000);
        refreshButton.setImage(this.imgReg.get(ICON_REFRESH));
        refreshButton.setToolTipText("Refresh the contexts");
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextSpyPart.this.contextTreeViewer.refresh(true);
                ContextSpyPart.this.contextDataPart.refresh(true);
            }
        });
        Button expandAll = new Button(comp, 0x800000);
        expandAll.setImage(this.imgReg.get(ICON_EXPANDALL));
        expandAll.setToolTipText("Expand context nodes");
        expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextSpyPart.this.contextTreeViewer.expandAll();
            }
        });
        Button collapseAll = new Button(comp, 0x800000);
        collapseAll.setImage(this.imgReg.get(ICON_COLLAPSEALL));
        collapseAll.setToolTipText("Collapse context nodes");
        collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextSpyPart.this.contextTreeViewer.collapseAll();
            }
        });
        this.filterText = new Text(comp, 640);
        GridDataFactory.fillDefaults().hint(200, -1).applyTo((Control)this.filterText);
        this.filterText.setMessage("Search data");
        this.filterText.setToolTipText("Highlight the contexts where the contained objects contains this string pattern.\nCase is ignored.");
        if (lastFilterText != null) {
            this.filterText.setText(lastFilterText);
        }
        this.contextFilter.setPattern(lastFilterText);
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String textToSearch = ContextSpyPart.this.filterText.getText();
                lastFilterText = textToSearch;
                boolean enableButton = textToSearch.length() > 0;
                ContextSpyPart.this.showOnlyFilteredElements.setEnabled(enableButton);
                ContextSpyPart.this.contextFilter.setPattern(textToSearch);
                ContextSpyPart.this.setFilter();
                ContextSpyPart.this.contextTreeViewer.refresh(true);
                ContextSpyPart.this.contextDataPart.refresh(true);
            }
        });
        this.showOnlyFilteredElements = new Button(comp, 32);
        this.showOnlyFilteredElements.setText("Show Only Filtered");
        this.showOnlyFilteredElements.setToolTipText("Show only the filtered items in the table view");
        this.showOnlyFilteredElements.setEnabled(lastFilterText != null && lastFilterText.length() > 0);
        this.showOnlyFilteredElements.setSelection(lastShowFiltered);
        this.showOnlyFilteredElements.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                lastShowFiltered = ContextSpyPart.this.showOnlyFilteredElements.getSelection();
                ContextSpyPart.this.setFilter();
            }
        });
        SashForm sashForm = new SashForm(parent, 768);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.contextTreeViewer = new TreeViewer((Composite)sashForm);
        this.treeContentProvider = (ContextSpyProvider)((Object)ContextInjectionFactory.make(ContextSpyProvider.class, (IEclipseContext)ctx));
        this.contextTreeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.contextTreeViewer.setLabelProvider((IBaseLabelProvider)this.treeContentProvider);
        this.contextTreeViewer.setSorter(new ViewerSorter());
        this.contextTreeViewer.setInput(ContextSpyHelper.getAllBundleContexts());
        this.contextTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                ContextSpyPart.this.selService.setSelection((Object)(ss.size() == 1 ? ss.getFirstElement() : ss.toArray()));
            }
        });
        IEclipseContext subCtx = ctx.createChild("Context for ContextDataPart");
        subCtx.set(Composite.class, (Object)sashForm);
        this.contextDataPart = (ContextDataPart)ContextInjectionFactory.make(ContextDataPart.class, (IEclipseContext)subCtx);
        this.setFilter();
        sashForm.setWeights(new int[]{35, 65});
        this.contextTreeViewer.expandAll();
    }

    public void setFilter() {
        if (this.showOnlyFilteredElements.isEnabled() && this.showOnlyFilteredElements.getSelection()) {
            this.contextDataPart.setFilter(this.contextFilter);
        } else {
            this.contextDataPart.setFilter(null);
        }
    }

    @PreDestroy
    public void dispose() {
    }

    @Focus
    public void setFocus() {
        this.contextTreeViewer.getControl().setFocus();
    }
}

