/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt.cocoa;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledMenuItemRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.cocoa.SWTCocoaEnhancerDelegate;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSToolbar;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CocoaUIHandler {
    private static final String MENU_ID_ABOUT = "org.eclipse.ui.help.aboutAction";
    private static final String MENU_ID_PREFERENCES = "org.eclipse.ui.window.preferences";
    private static final String MENU_ID_QUIT = "org.eclipse.ui.file.exit";
    private static final int kAboutMenuItem = 0;
    private static final int kPreferencesMenuItem = 2;
    private static final int kServicesMenuItem = 4;
    private static final int kHideApplicationMenuItem = 6;
    private static final int kQuitMenuItem = 10;
    static long sel_toolbarButtonClicked_;
    static long sel_preferencesMenuItemSelected_;
    static long sel_aboutMenuItemSelected_;
    static long sel_quitMenuItemSelected_;
    private static final long NSWindowToolbarButton = 3L;
    static Callback proc3Args;
    static final byte[] SWT_OBJECT;
    SWTCocoaEnhancerDelegate delegate;
    private long delegateJniRef;
    private static final String RESOURCE_BUNDLE;
    private static final String FRAGMENT_ID = "org.eclipse.e4.ui.workbench.renderers.swt.cocoa";
    private String fAboutActionName;
    private String fQuitActionName;
    private String fHideActionName;
    @Inject
    protected MApplication app;
    @Inject
    protected Provider<StatusReporter> statusReporter;
    @Inject
    protected ECommandService commandService;
    @Inject
    protected EHandlerService handlerService;
    @Inject
    protected EModelService modelService;
    @Inject
    protected IEventBroker eventBroker;

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
        RESOURCE_BUNDLE = String.valueOf(CocoaUIHandler.class.getPackage().getName()) + ".Messages";
    }

    private void init() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        byte[] types = byArray;
        int size = C.PTR_SIZEOF;
        int align = C.PTR_SIZEOF == 4 ? 2 : 3;
        Class<CocoaUIHandler> clazz = CocoaUIHandler.class;
        proc3Args = new Callback(clazz, "actionProc", 3);
        Method getAddress = Callback.class.getMethod("getAddress", new Class[0]);
        Object object = getAddress.invoke((Object)proc3Args, null);
        long proc3 = this.convertToLong(object);
        if (proc3 == 0L) {
            SWT.error((int)3);
        }
        Field field = OS.class.getField("class_NSObject");
        Object fieldObj = field.get(OS.class);
        object = CocoaUIHandler.invokeMethod(OS.class, "objc_allocateClassPair", new Object[]{fieldObj, "SWTCocoaEnhancerDelegate", CocoaUIHandler.wrapPointer(0L)});
        long cls = this.convertToLong(object);
        CocoaUIHandler.invokeMethod(OS.class, "class_addIvar", new Object[]{CocoaUIHandler.wrapPointer(cls), SWT_OBJECT, CocoaUIHandler.wrapPointer(size), new Byte((byte)align), types});
        CocoaUIHandler.invokeMethod(OS.class, "class_addMethod", new Object[]{CocoaUIHandler.wrapPointer(cls), CocoaUIHandler.wrapPointer(sel_toolbarButtonClicked_), CocoaUIHandler.wrapPointer(proc3), "@:@"});
        CocoaUIHandler.invokeMethod(OS.class, "class_addMethod", new Object[]{CocoaUIHandler.wrapPointer(cls), CocoaUIHandler.wrapPointer(sel_preferencesMenuItemSelected_), CocoaUIHandler.wrapPointer(proc3), "@:@"});
        CocoaUIHandler.invokeMethod(OS.class, "class_addMethod", new Object[]{CocoaUIHandler.wrapPointer(cls), CocoaUIHandler.wrapPointer(sel_aboutMenuItemSelected_), CocoaUIHandler.wrapPointer(proc3), "@:@"});
        CocoaUIHandler.invokeMethod(OS.class, "class_addMethod", new Object[]{CocoaUIHandler.wrapPointer(cls), CocoaUIHandler.wrapPointer(sel_quitMenuItemSelected_), CocoaUIHandler.wrapPointer(proc3), "@:@"});
        CocoaUIHandler.invokeMethod(OS.class, "objc_registerClassPair", new Object[]{CocoaUIHandler.wrapPointer(cls)});
    }

    public CocoaUIHandler() {
        String format;
        String productName = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            productName = product.getName();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
        try {
            if (productName != null && (format = resourceBundle.getString("AboutAction.format")) != null) {
                this.fAboutActionName = MessageFormat.format(format, productName);
            }
            if (this.fAboutActionName == null) {
                this.fAboutActionName = resourceBundle.getString("AboutAction.name");
            }
        }
        catch (MissingResourceException missingResourceException) {}
        if (this.fAboutActionName == null) {
            this.fAboutActionName = "About";
        }
        if (productName != null) {
            try {
                format = resourceBundle.getString("HideAction.format");
                if (format != null) {
                    this.fHideActionName = MessageFormat.format(format, productName);
                }
            }
            catch (MissingResourceException missingResourceException) {}
            try {
                format = resourceBundle.getString("QuitAction.format");
                if (format != null) {
                    this.fQuitActionName = MessageFormat.format(format, productName);
                }
            }
            catch (MissingResourceException missingResourceException) {}
        }
        try {
            if (sel_toolbarButtonClicked_ == 0L) {
                sel_toolbarButtonClicked_ = this.registerName("toolbarButtonClicked:");
                sel_preferencesMenuItemSelected_ = this.registerName("preferencesMenuItemSelected:");
                sel_aboutMenuItemSelected_ = this.registerName("aboutMenuItemSelected:");
                sel_quitMenuItemSelected_ = this.registerName("quitMenuItemSelected:");
                this.init();
            }
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    private long registerName(String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<OS> clazz = OS.class;
        Object object = CocoaUIHandler.invokeMethod(clazz, "sel_registerName", new Object[]{name});
        return this.convertToLong(object);
    }

    @Execute
    public void execute() {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                try {
                    CocoaUIHandler.this.delegate = new SWTCocoaEnhancerDelegate();
                    CocoaUIHandler.this.delegate.alloc().init();
                    Method method = OS.class.getMethod("NewGlobalRef", Object.class);
                    Object object = method.invoke(OS.class, CocoaUIHandler.this);
                    CocoaUIHandler.this.delegateJniRef = CocoaUIHandler.this.convertToLong(object);
                }
                catch (Exception e) {
                    CocoaUIHandler.this.log(e);
                }
                if (CocoaUIHandler.this.delegateJniRef == 0L) {
                    SWT.error((int)2);
                }
                try {
                    Field idField = SWTCocoaEnhancerDelegate.class.getField("id");
                    Object idValue = idField.get((Object)CocoaUIHandler.this.delegate);
                    CocoaUIHandler.invokeMethod(OS.class, "object_setInstanceVariable", new Object[]{idValue, SWT_OBJECT, CocoaUIHandler.wrapPointer(CocoaUIHandler.this.delegateJniRef)});
                    CocoaUIHandler.this.hookApplicationMenu();
                    CocoaUIHandler.this.hookWorkbenchListener();
                    display.disposeExec(new Runnable(){

                        public void run() {
                            if (CocoaUIHandler.this.delegateJniRef != 0L) {
                                try {
                                    CocoaUIHandler.invokeMethod(OS.class, "DeleteGlobalRef", new Object[]{CocoaUIHandler.wrapPointer(CocoaUIHandler.this.delegateJniRef)});
                                }
                                catch (Exception e) {
                                    CocoaUIHandler.this.log(e);
                                }
                            }
                            CocoaUIHandler.this.delegateJniRef = 0L;
                            if ((this).CocoaUIHandler.this.delegate != null) {
                                (this).CocoaUIHandler.this.delegate.release();
                            }
                            (this).CocoaUIHandler.this.delegate = null;
                        }
                    });
                    for (MWindow window : CocoaUIHandler.this.app.getChildren()) {
                        CocoaUIHandler.this.modifyWindowShell(window);
                    }
                }
                catch (Exception e) {
                    CocoaUIHandler.this.log(e);
                }
            }
        });
    }

    void log(Exception e) {
        ((StatusReporter)this.statusReporter.get()).report((IStatus)new Status(2, FRAGMENT_ID, "Exception occurred during CocoaUI processing", (Throwable)e), 32, new Object[0]);
    }

    protected void hookWorkbenchListener() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget"), new EventHandler(){

            public void handleEvent(Event event) {
                if (event.getProperty("ChangedElement") instanceof MWindow && event.getProperty("NewValue") != null) {
                    MWindow window = (MWindow)event.getProperty("ChangedElement");
                    CocoaUIHandler.this.modifyWindowShell(window);
                }
            }
        });
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/basic/Window", (String)"mainMenu"), new EventHandler(){

            public void handleEvent(Event event) {
                Object newValue = event.getProperty("NewValue");
                Object oldValue = event.getProperty("OldValue");
                Object element = event.getProperty("ChangedElement");
                if (element instanceof MWindow && oldValue == null && newValue instanceof MMenu) {
                    CocoaUIHandler.this.modifyWindowShell((MWindow)element);
                }
            }
        });
    }

    protected void modifyWindowShell(MWindow window) {
        if (window.getWidget() == null) {
            return;
        }
        if (window.getMainMenu() == null) {
            return;
        }
        this.redirectHandledMenuItems(window.getMainMenu());
        boolean trimInitiallyVisible = false;
        if (window instanceof MTrimmedWindow && !((MTrimmedWindow)window).getTrimBars().isEmpty()) {
            for (MTrimBar tb : ((MTrimmedWindow)window).getTrimBars()) {
                if (!tb.isVisible()) continue;
                trimInitiallyVisible = true;
            }
        }
        if (trimInitiallyVisible) {
            NSToolbar dummyBar = new NSToolbar();
            dummyBar.alloc();
            dummyBar.initWithIdentifier(NSString.stringWith((String)"SWTToolbar"));
            dummyBar.setVisible(false);
            Shell shell = ((Control)window.getWidget()).getShell();
            NSWindow nsWindow = shell.view.window();
            nsWindow.setToolbar(dummyBar);
            dummyBar.release();
            nsWindow.setShowsToolbarButton(true);
            try {
                Object fieldValue = CocoaUIHandler.wrapPointer(3L);
                NSButton toolbarButton = (NSButton)CocoaUIHandler.invokeMethod(NSWindow.class, nsWindow, "standardWindowButton", new Object[]{fieldValue});
                if (toolbarButton != null) {
                    toolbarButton.setTarget((id)this.delegate);
                    CocoaUIHandler.invokeMethod(NSControl.class, toolbarButton, "setAction", new Object[]{CocoaUIHandler.wrapPointer(sel_toolbarButtonClicked_)});
                }
            }
            catch (Exception e) {
                this.log(e);
            }
        }
    }

    private void redirectHandledMenuItems(MMenu menu) {
        if (menu == null) {
            return;
        }
        for (MMenuElement elmt : menu.getChildren()) {
            if (elmt instanceof MMenu) {
                this.redirectHandledMenuItems((MMenu)elmt);
                continue;
            }
            if (!(elmt instanceof MMenuItem)) continue;
            this.redirectHandledMenuItem((MMenuItem)elmt);
        }
    }

    private void redirectHandledMenuItem(MMenuItem item) {
        String elmtId = item.getElementId();
        if (elmtId != null && (elmtId.equals(MENU_ID_ABOUT) || elmtId.equals(MENU_ID_PREFERENCES) || elmtId.equals(MENU_ID_QUIT))) {
            item.setVisible(false);
        } else if (item instanceof MHandledMenuItem) {
            MHandledMenuItem mhmi = (MHandledMenuItem)item;
            String string = elmtId = mhmi.getCommand() == null ? null : mhmi.getCommand().getElementId();
            if (elmtId != null && (elmtId.equals(MENU_ID_ABOUT) || elmtId.equals(MENU_ID_PREFERENCES) || elmtId.equals(MENU_ID_QUIT))) {
                item.setVisible(false);
            }
        }
    }

    private void hookApplicationMenu() {
        try {
            NSMenu mainMenu = NSApplication.sharedApplication().mainMenu();
            NSMenuItem mainMenuItem = (NSMenuItem)CocoaUIHandler.invokeMethod(NSMenu.class, mainMenu, "itemAtIndex", new Object[]{CocoaUIHandler.wrapPointer(0L)});
            NSMenu appMenu = mainMenuItem.submenu();
            NSMenuItem aboutMenuItem = (NSMenuItem)CocoaUIHandler.invokeMethod(NSMenu.class, appMenu, "itemAtIndex", new Object[]{CocoaUIHandler.wrapPointer(0L)});
            aboutMenuItem.setTitle(NSString.stringWith((String)this.fAboutActionName));
            if (this.fHideActionName != null) {
                NSMenuItem hideMenuItem = (NSMenuItem)CocoaUIHandler.invokeMethod(NSMenu.class, appMenu, "itemAtIndex", new Object[]{CocoaUIHandler.wrapPointer(6L)});
                hideMenuItem.setTitle(NSString.stringWith((String)this.fHideActionName));
            }
            NSMenuItem quitMenuItem = (NSMenuItem)CocoaUIHandler.invokeMethod(NSMenu.class, appMenu, "itemAtIndex", new Object[]{CocoaUIHandler.wrapPointer(10L)});
            if (this.fQuitActionName != null) {
                quitMenuItem.setTitle(NSString.stringWith((String)this.fQuitActionName));
            }
            NSMenuItem prefMenuItem = (NSMenuItem)CocoaUIHandler.invokeMethod(NSMenu.class, appMenu, "itemAtIndex", new Object[]{CocoaUIHandler.wrapPointer(2L)});
            prefMenuItem.setEnabled(true);
            NSMenuItem servicesMenuItem = (NSMenuItem)CocoaUIHandler.invokeMethod(NSMenu.class, appMenu, "itemAtIndex", new Object[]{CocoaUIHandler.wrapPointer(4L)});
            servicesMenuItem.setEnabled(false);
            prefMenuItem.setTarget((id)this.delegate);
            CocoaUIHandler.invokeMethod(NSMenuItem.class, prefMenuItem, "setAction", new Object[]{CocoaUIHandler.wrapPointer(sel_preferencesMenuItemSelected_)});
            aboutMenuItem.setTarget((id)this.delegate);
            CocoaUIHandler.invokeMethod(NSMenuItem.class, aboutMenuItem, "setAction", new Object[]{CocoaUIHandler.wrapPointer(sel_aboutMenuItemSelected_)});
            quitMenuItem.setTarget((id)this.delegate);
            CocoaUIHandler.invokeMethod(NSMenuItem.class, quitMenuItem, "setAction", new Object[]{CocoaUIHandler.wrapPointer(sel_quitMenuItemSelected_)});
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    private void runAction(String actionId) {
        MMenu topMenu;
        MMenuItem item;
        MWindow window = (MWindow)this.app.getSelectedElement();
        if (window != null && (item = this.findAction(actionId, topMenu = window.getMainMenu())) != null && item.isEnabled()) {
            try {
                NSMenu mainMenu = NSApplication.sharedApplication().mainMenu();
                NSMenuItem mainMenuItem = (NSMenuItem)CocoaUIHandler.invokeMethod(NSMenu.class, mainMenu, "itemAtIndex", new Object[]{CocoaUIHandler.wrapPointer(0L)});
                NSMenu appMenu = mainMenuItem.submenu();
                NSMenuItem aboutMenuItem = (NSMenuItem)CocoaUIHandler.invokeMethod(NSMenu.class, appMenu, "itemAtIndex", new Object[]{CocoaUIHandler.wrapPointer(0L)});
                NSMenuItem prefMenuItem = (NSMenuItem)CocoaUIHandler.invokeMethod(NSMenu.class, appMenu, "itemAtIndex", new Object[]{CocoaUIHandler.wrapPointer(2L)});
                try {
                    prefMenuItem.setEnabled(false);
                    aboutMenuItem.setEnabled(false);
                    this.simulateMenuSelection(item);
                }
                finally {
                    prefMenuItem.setEnabled(true);
                    aboutMenuItem.setEnabled(true);
                }
            }
            catch (Exception e) {
                this.log(e);
            }
        }
    }

    private void simulateMenuSelection(MMenuItem item) {
        IEclipseContext lclContext = this.getContext((MUIElement)item);
        if (item instanceof MDirectMenuItem) {
            MDirectMenuItem dmi = (MDirectMenuItem)item;
            if (dmi.getObject() == null) {
                IContributionFactory cf = (IContributionFactory)lclContext.get(IContributionFactory.class.getName());
                dmi.setObject(cf.create(dmi.getContributionURI(), lclContext));
            }
            lclContext.set(MItem.class.getName(), (Object)item);
            ContextInjectionFactory.invoke((Object)dmi.getObject(), Execute.class, (IEclipseContext)lclContext);
            lclContext.remove(MItem.class.getName());
        } else if (item instanceof MHandledMenuItem) {
            MHandledMenuItem hmi = (MHandledMenuItem)item;
            EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
            ParameterizedCommand cmd = hmi.getWbCommand();
            if (cmd == null) {
                cmd = HandledMenuItemRenderer.generateParameterizedCommand((MHandledItem)hmi, (IEclipseContext)lclContext);
            }
            lclContext.set(MItem.class.getName(), (Object)item);
            service.executeHandler(cmd);
            lclContext.remove(MItem.class.getName());
        } else {
            ((StatusReporter)this.statusReporter.get()).report((IStatus)new Status(2, FRAGMENT_ID, "Unhandled menu type: " + item.getClass() + ": " + item), 32, new Object[0]);
        }
    }

    private IEclipseContext getContext(MUIElement element) {
        if (element instanceof MContext) {
            return ((MContext)element).getContext();
        }
        return this.modelService.getContainingContext(element);
    }

    private void runCommand(String commandId) {
        ParameterizedCommand cmd;
        MWindow window = (MWindow)this.app.getSelectedElement();
        if (window == null) {
            return;
        }
        if (this.handlerService != null && (cmd = this.commandService.createCommand(commandId, Collections.emptyMap())) != null) {
            this.handlerService.executeHandler(cmd);
        }
    }

    private MMenuItem findAction(String actionId, MMenu menu) {
        for (MMenuElement item : menu.getChildren()) {
            MMenuItem found;
            if (item instanceof MMenuItem) {
                MHandledMenuItem mhmi;
                MMenuItem mmi = (MMenuItem)item;
                if (mmi.getElementId() != null && mmi.getElementId().equals(actionId)) {
                    return mmi;
                }
                if (!(mmi instanceof MHandledMenuItem) || (mhmi = (MHandledMenuItem)mmi).getCommand() == null || !actionId.equals(mhmi.getCommand().getElementId())) continue;
                return mmi;
            }
            if (!(item instanceof MMenu) || (found = this.findAction(actionId, (MMenu)item)) == null) continue;
            return found;
        }
        return null;
    }

    void toolbarButtonClicked(NSControl source) {
        try {
            NSWindow window = source.window();
            Field idField = NSWindow.class.getField("id");
            Object idValue = idField.get(window);
            Display display = Display.getCurrent();
            Widget widget = (Widget)CocoaUIHandler.invokeMethod(Display.class, display, "findWidget", new Object[]{idValue});
            if (!(widget instanceof Shell)) {
                return;
            }
            Shell shell = (Shell)widget;
            for (MWindow mwin : this.app.getChildren()) {
                if (mwin.getWidget() != shell) continue;
                this.runCommand("org.eclipse.ui.ToggleCoolbarAction");
            }
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    void preferencesMenuItemSelected() {
        this.runAction(MENU_ID_PREFERENCES);
    }

    void aboutMenuItemSelected() {
        this.runAction(MENU_ID_ABOUT);
    }

    void quitMenuItemSelected() {
        this.runAction(MENU_ID_QUIT);
    }

    static int actionProc(int id2, int sel, int arg0) throws Exception {
        return (int)CocoaUIHandler.actionProc((long)id2, (long)sel, (long)arg0);
    }

    static long actionProc(long id2, long sel, long arg0) throws Exception {
        long[] jniRef = CocoaUIHandler.OS_object_getInstanceVariable(id2, SWT_OBJECT);
        if (jniRef[0] == 0L) {
            return 0L;
        }
        CocoaUIHandler delegate = (CocoaUIHandler)CocoaUIHandler.invokeMethod(OS.class, "JNIGetObject", new Object[]{CocoaUIHandler.wrapPointer(jniRef[0])});
        if (sel == sel_toolbarButtonClicked_) {
            NSControl source = CocoaUIHandler.new_NSControl(arg0);
            delegate.toolbarButtonClicked(source);
        } else if (sel == sel_preferencesMenuItemSelected_) {
            delegate.preferencesMenuItemSelected();
        } else if (sel == sel_aboutMenuItemSelected_) {
            delegate.aboutMenuItemSelected();
        } else if (sel == sel_quitMenuItemSelected_) {
            delegate.quitMenuItemSelected();
        }
        return 0L;
    }

    private static NSControl new_NSControl(long arg0) throws NoSuchMethodException, InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<NSControl> clazz = NSControl.class;
        Class<Number> PTR_CLASS = C.PTR_SIZEOF == 8 ? Long.TYPE : Integer.TYPE;
        Constructor constructor = clazz.getConstructor(PTR_CLASS);
        return (NSControl)constructor.newInstance(CocoaUIHandler.wrapPointer(arg0));
    }

    private static long[] OS_object_getInstanceVariable(long delegateId, byte[] name) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Class<Number> PTR_CLASS;
        Class<OS> clazz = OS.class;
        Method method = null;
        Class<Number> clazz2 = PTR_CLASS = C.PTR_SIZEOF == 8 ? Long.TYPE : Integer.TYPE;
        if (PTR_CLASS == Long.TYPE) {
            method = clazz.getMethod("object_getInstanceVariable", Long.TYPE, byte[].class, long[].class);
            long[] resultPtr = new long[1];
            method.invoke(null, new Long(delegateId), name, resultPtr);
            return resultPtr;
        }
        method = clazz.getMethod("object_getInstanceVariable", Integer.TYPE, byte[].class, int[].class);
        int[] resultPtr = new int[1];
        method.invoke(null, new Integer((int)delegateId), name, resultPtr);
        return new long[]{resultPtr[0]};
    }

    private long convertToLong(Object object) {
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i.longValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        return 0L;
    }

    private static Object invokeMethod(Class clazz, String methodName, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        return CocoaUIHandler.invokeMethod(clazz, null, methodName, args);
    }

    private static Object invokeMethod(Class clazz, Object target, String methodName, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Class[] signature = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            Class<?> thisClass = args[i].getClass();
            signature[i] = thisClass == Integer.class ? Integer.TYPE : (thisClass == Long.class ? Long.TYPE : (thisClass == Byte.class ? Byte.TYPE : thisClass));
            ++i;
        }
        Method method = clazz.getMethod(methodName, signature);
        return method.invoke(target, args);
    }

    private static Object wrapPointer(long value) {
        Class<Number> PTR_CLASS;
        Class<Number> clazz = PTR_CLASS = C.PTR_SIZEOF == 8 ? Long.TYPE : Integer.TYPE;
        if (PTR_CLASS == Long.TYPE) {
            return new Long(value);
        }
        return new Integer((int)value);
    }
}

