/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.use;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.use.Messages;
import org.eclipse.pde.api.tools.ui.internal.use.UsePatternPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ReportPatternPage
extends UsePatternPage {
    static final String PAGE_NAME = "report";
    private Text patterntext = null;
    int kind = 5;
    Button to = null;
    Button from = null;
    String pattern = null;

    public ReportPatternPage(String pattern, int kind) {
        super(PAGE_NAME, Messages.ReportPatternPage_report_conversion_pattern, null);
        this.pattern = pattern;
        this.kind = kind;
    }

    public int getKind() {
        return this.kind;
    }

    public String getPattern() {
        return this.patterntext.getText().trim();
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 768);
        this.to = SWTFactory.createRadioButton(comp, Messages.ReportPatternPage_filter_to_pattern);
        this.to.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPatternPage.this.kind = 5;
            }
        });
        this.from = SWTFactory.createRadioButton(comp, Messages.ReportPatternPage_filter_from_pattern);
        this.from.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPatternPage.this.kind = 4;
            }
        });
        if (this.kind == 4) {
            this.from.setSelection(true);
        } else {
            this.to.setSelection(true);
            this.kind = 5;
        }
        SWTFactory.createLabel(comp, Messages.ReportPatternPage_pattern, 1);
        this.patterntext = SWTFactory.createSingleText(comp, 1);
        if (this.pattern != null) {
            this.patterntext.setText(this.pattern);
        }
        this.patterntext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReportPatternPage.this.setDirty();
                ReportPatternPage.this.setPageComplete(ReportPatternPage.this.isPageComplete());
            }
        });
        this.patterntext.selectAll();
        this.patterntext.setFocus();
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IApiToolsHelpContextIds.APITOOLS_REPORT_PATTERN_WIZARD_PAGE);
    }

    public boolean isPageComplete() {
        String newtext = this.patterntext.getText().trim();
        if ("".equals(newtext)) {
            if (this.pageDirty()) {
                this.setErrorMessage(Messages.ReportPatternPage_enter_conversion_pattern);
            } else {
                this.setMessage(Messages.ReportPatternPage_enter_conversion_pattern);
            }
            return false;
        }
        try {
            Pattern.compile(newtext);
        }
        catch (PatternSyntaxException pse) {
            this.setErrorMessage(pse.getMessage());
            return false;
        }
        this.resetMessage(this.pattern != null);
        return true;
    }

    protected void resetMessage(boolean isediting) {
        this.setErrorMessage(null);
        if (isediting) {
            this.setMessage(Messages.ReportPatternPage_edit_conversion_pattern);
        } else {
            this.setMessage(Messages.ReportPatternPage_create_conversion_pattern);
        }
    }
}

