/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class RelaunchActionDelegate
extends AbstractDebugActionDelegate {
    protected void doAction(Object object) {
        ILaunch launch = DebugUIPlugin.getLaunch(object);
        if (launch != null) {
            RelaunchActionDelegate.relaunch(launch.getLaunchConfiguration(), launch.getLaunchMode());
        }
    }

    public static void relaunch(ILaunchConfiguration config, String mode) {
        DebugUITools.launch(config, mode);
    }

    protected boolean isEnabledFor(Object element) {
        ILaunch launch = DebugUIPlugin.getLaunch(element);
        return launch != null && launch.getLaunchConfiguration() != null && LaunchConfigurationManager.isVisible(launch.getLaunchConfiguration());
    }

    protected IStructuredSelection getTargetSelection(IStructuredSelection s) {
        if (s.isEmpty()) {
            return s;
        }
        LinkedHashSet<ILaunch> dups = new LinkedHashSet<ILaunch>();
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            ILaunch launch = DebugUIPlugin.getLaunch(object);
            if (launch == null) {
                return s;
            }
            dups.add(launch);
        }
        return new StructuredSelection(dups.toArray());
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.RelaunchActionDelegate_Launch_Failed_1;
    }

    protected String getStatusMessage() {
        return ActionMessages.RelaunchActionDelegate_An_exception_occurred_while_launching_2;
    }
}

