/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.IContextDisposalListener;
import org.eclipse.e4.core.internal.contexts.ILookupStrategy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OSGiContextStrategy
implements IContextDisposalListener,
ILookupStrategy,
ServiceTrackerCustomizer {
    final BundleContext bundleContext;
    private ContextFunctionCache functionCache;
    private Map<String, ServiceData> services = Collections.synchronizedMap(new HashMap());

    public OSGiContextStrategy(BundleContext bc) {
        this.bundleContext = bc;
        this.functionCache = new ContextFunctionCache();
    }

    public Object addingService(ServiceReference reference) {
        String name = this.serviceName(reference);
        Object newValue = this.bundleContext.getService(reference);
        if (newValue == null) {
            return null;
        }
        ServiceData data = this.getServiceData(name);
        if (data == null) {
            return null;
        }
        IEclipseContext[] iEclipseContextArray = data.getUsingContexts();
        int n = iEclipseContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEclipseContext user = iEclipseContextArray[n2];
            user.set(name, newValue);
            ++n2;
        }
        return newValue;
    }

    public boolean containsKey(String name, IEclipseContext context) {
        if (this.getContextFunction(name) != null) {
            return true;
        }
        return this.bundleContext.getServiceReference(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<String, ServiceData> map = this.services;
        synchronized (map) {
            Iterator<ServiceData> it = this.services.values().iterator();
            while (it.hasNext()) {
                it.next().tracker.close();
            }
            this.services.clear();
        }
        this.functionCache.dispose();
    }

    private ServiceData getServiceData(String name) {
        ServiceData data = this.services.get(name);
        if (data == null) {
            return null;
        }
        if (data.users.isEmpty()) {
            data.tracker.close();
            this.services.remove(name);
            return null;
        }
        return data;
    }

    public Object lookup(String name, IEclipseContext originatingContext) {
        if (name == null) {
            return null;
        }
        ServiceData data = this.getServiceData(name);
        if (data == null) {
            ServiceReference ref = this.getContextFunction(name);
            if (ref != null) {
                return this.bundleContext.getService(ref);
            }
            if (name.indexOf(46) == -1) {
                return null;
            }
            data = new ServiceData(name);
            try {
                data.tracker = new ServiceTracker(this.bundleContext, name, (ServiceTrackerCustomizer)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            data.addContext(originatingContext);
            ((EclipseContext)originatingContext).notifyOnDisposal(this);
            this.services.put(name, data);
            data.tracker.open();
        } else {
            data.addContext(originatingContext);
        }
        return data.tracker.getService();
    }

    private ServiceReference getContextFunction(String name) {
        return this.functionCache.lookup(name);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        String name = this.serviceName(reference);
        ServiceData data = this.getServiceData(name);
        if (data == null) {
            return;
        }
        IEclipseContext[] iEclipseContextArray = data.getUsingContexts();
        int n = iEclipseContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEclipseContext user = iEclipseContextArray[n2];
            user.set(name, service);
            ++n2;
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        String name = this.serviceName(reference);
        ServiceData data = this.getServiceData(name);
        if (data != null) {
            IEclipseContext[] iEclipseContextArray = data.getUsingContexts();
            int n = iEclipseContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEclipseContext user = iEclipseContextArray[n2];
                user.set(name, null);
                ++n2;
            }
        }
        this.bundleContext.ungetService(reference);
    }

    private String serviceName(ServiceReference reference) {
        return ((String[])reference.getProperty("objectClass"))[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposed(IEclipseContext context) {
        Map<String, ServiceData> map = this.services;
        synchronized (map) {
            Iterator<ServiceData> it = this.services.values().iterator();
            while (it.hasNext()) {
                ServiceData data = it.next();
                data.users.remove(context);
                if (!data.users.isEmpty()) continue;
                it.remove();
                data.tracker.close();
            }
        }
    }

    class ContextFunctionCache
    implements ServiceListener {
        final Map<String, ServiceReference> functionKeys = Collections.synchronizedMap(new HashMap());

        public ContextFunctionCache() {
            try {
                String filter = "(objectClass=" + IContextFunction.SERVICE_NAME + ')';
                OSGiContextStrategy.this.bundleContext.addServiceListener((ServiceListener)this, filter);
                ServiceReference[] existing = OSGiContextStrategy.this.bundleContext.getServiceReferences(IContextFunction.SERVICE_NAME, null);
                if (existing != null) {
                    int i = 0;
                    while (i < existing.length) {
                        this.add(existing[i]);
                        ++i;
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private void add(ServiceReference ref) {
            String key = (String)ref.getProperty("service.context.key");
            if (key != null) {
                this.functionKeys.put(key, ref);
            }
        }

        public ServiceReference lookup(String key) {
            return this.functionKeys.get(key);
        }

        public void dispose() {
            OSGiContextStrategy.this.bundleContext.removeServiceListener((ServiceListener)this);
            this.functionKeys.clear();
        }

        private void remove(ServiceReference ref) {
            String key = (String)ref.getProperty("service.context.key");
            if (key != null) {
                this.functionKeys.remove(key);
            }
        }

        public void serviceChanged(ServiceEvent event) {
            switch (event.getType()) {
                case 1: {
                    this.add(event.getServiceReference());
                    break;
                }
                case 4: {
                    this.remove(event.getServiceReference());
                }
            }
        }
    }

    class ServiceData {
        String name;
        ServiceTracker tracker;
        final Map<IEclipseContext, Object> users = Collections.synchronizedMap(new WeakHashMap());

        ServiceData(String name) {
            this.name = name;
        }

        public void addContext(IEclipseContext originatingContext) {
            this.users.put(originatingContext, null);
        }

        public IEclipseContext[] getUsingContexts() {
            return this.users.keySet().toArray(new IEclipseContext[this.users.size()]);
        }
    }
}

