/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DragHost {
    public static final String DragHostId = "dragHost";
    MUIElement dragElement;
    MElementContainer<MUIElement> originalParent;
    int originalIndex;
    MWindow baseWindow;
    int xOffset = 20;
    int yOffset = 20;
    private MWindow dragWindow;

    public DragHost(Shell shell) {
        this.dragWindow = (MWindow)shell.getData("modelElement");
        this.baseWindow = (MWindow)shell.getParent().getData("modelElement");
        this.dragElement = (MUIElement)this.dragWindow.getChildren().get(0);
    }

    public DragHost(MUIElement element) {
        assert (this.dragElement != null);
        this.dragElement = element;
        this.originalParent = this.dragElement.getParent();
        this.originalIndex = this.originalParent.getChildren().indexOf(element);
        this.baseWindow = this.getWindow();
        assert (this.baseWindow != null && this.baseWindow.getWidget() != null);
        this.attach();
    }

    public Shell getShell() {
        return (Shell)this.dragWindow.getWidget();
    }

    public MWindow getModel() {
        return this.dragWindow;
    }

    public void setLocation(int x, int y) {
        this.getShell().setLocation(x + this.xOffset, y + this.yOffset);
    }

    private MWindow getWindow() {
        MElementContainer pe = this.originalParent;
        while (pe != null && !(pe instanceof MApplication)) {
            if (pe instanceof MWindow) {
                return (MWindow)pe;
            }
            pe = pe.getParent();
        }
        return null;
    }

    private void attach() {
        this.dragElement.getParent().getChildren().remove(this.dragElement);
        ((Shell)this.baseWindow.getWidget()).getDisplay().update();
        this.dragWindow = MBasicFactory.INSTANCE.createWindow();
        this.dragWindow.getTags().add(DragHostId);
        this.formatModel(this.dragWindow);
        Point cp = ((Shell)this.baseWindow.getWidget()).getDisplay().getCursorLocation();
        Point size = new Point(200, 200);
        if (this.dragElement.getWidget() instanceof Control) {
            Control ctrl = (Control)this.dragElement.getWidget();
            size = ctrl.getSize();
        } else if (this.dragElement.getWidget() instanceof ToolItem) {
            ToolItem ti = (ToolItem)this.dragElement.getWidget();
            Rectangle bounds = ti.getBounds();
            size = new Point(bounds.width + 3, bounds.height + 3);
        }
        this.dragWindow.setX(cp.x + this.xOffset);
        this.dragWindow.setY(cp.y + this.yOffset);
        this.dragWindow.setWidth(size.x);
        this.dragWindow.setHeight(size.y);
        this.baseWindow.getWindows().add(this.dragWindow);
        this.getShell().layout(this.getShell().getChildren(), 6);
        this.getShell().setVisible(true);
    }

    private void formatModel(MWindow dragWindow) {
    }

    public void drop(MElementContainer<MUIElement> newContainer, int itemIndex) {
        if (this.dragElement.getParent() != null) {
            this.dragElement.getParent().getChildren().remove(this.dragElement);
        }
        if (itemIndex >= 0) {
            newContainer.getChildren().add(itemIndex, this.dragElement);
        } else {
            newContainer.getChildren().add(this.dragElement);
        }
        newContainer.setSelectedElement(this.dragElement);
        if (this.dragElement.getWidget() instanceof ToolItem) {
            ToolItem ti = (ToolItem)this.dragElement.getWidget();
            ToolBar tb = ti.getParent();
            tb.layout(true);
            tb.getParent().layout(new Control[]{tb}, 6);
        }
        this.baseWindow.getChildren().remove(this.dragWindow);
        newContainer.setSelectedElement(this.dragElement);
        if (this.getShell() != null) {
            this.getShell().dispose();
        }
    }

    public void cancel() {
        this.drop(this.originalParent, this.originalIndex);
    }

    public MUIElement getDragElement() {
        return this.dragElement;
    }

    public void dispose() {
    }
}

