/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.Messages;
import org.eclipse.e4.ui.workbench.addons.minmax.MinMaxAddon;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimPaneLayout;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.EventHandler;

public class TrimStack {
    private static final String LAYOUT_ICON_URI = "platform:/plugin/org.eclipse.e4.ui.workbench.addons.swt/icons/full/obj16/layout_co.gif";
    private static final String RESTORE_ICON_URI = "platform:/plugin/org.eclipse.e4.ui.workbench.addons.swt/icons/full/etool16/fastview_restore.gif";
    private Image layoutImage;
    private Image restoreImage;
    private ToolBar trimStackTB;
    private Menu trimStackMenu;
    private ToolItem selectedToolItem;
    private boolean isShowing = false;
    private MUIElement minimizedElement;
    private Composite hostPane;
    @Inject
    @Named(value="org.eclipse.e4.ui.workbench.IResourceUtilities")
    private IResourceUtilities<ImageDescriptor> resUtils;
    private Map<String, Image> imageMap = new HashMap<String, Image>();
    ControlListener caResizeListener = new ControlListener(){

        public void controlResized(ControlEvent e) {
            if (TrimStack.this.hostPane != null && TrimStack.this.hostPane.isVisible()) {
                TrimStack.this.setPaneLocation(TrimStack.this.hostPane);
            }
        }

        public void controlMoved(ControlEvent e) {
        }
    };
    private Listener mouseDownListener = new Listener(){

        /*
         * Unable to fully structure code
         */
        public void handleEvent(Event event) {
            block3: {
                if (!(event.widget instanceof Control)) break block3;
                control = (Control)event.widget;
                if (control.getShell() != TrimStack.access$0(TrimStack.this).getParent()) {
                    return;
                }
                if (control != TrimStack.access$2(TrimStack.this)) ** GOTO lbl10
                return;
lbl-1000:
                // 1 sources

                {
                    if (control == TrimStack.access$0(TrimStack.this)) {
                        return;
                    }
                    control = control.getParent();
lbl10:
                    // 2 sources

                    ** while (!(control instanceof Shell))
                }
lbl11:
                // 1 sources

                TrimStack.this.showStack(false);
            }
        }
    };
    private Listener escapeListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.character == '\u001b') {
                TrimStack.this.showStack(false);
            }
        }
    };
    @Inject
    EModelService modelService;
    @Inject
    EPartService partService;
    @Inject
    MWindow window;
    @Inject
    MToolControl toolControl;
    @Inject
    protected IEventBroker eventBroker;
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (changedElement != TrimStack.this.minimizedElement) {
                return;
            }
            if (TrimStack.this.hostPane != null && TrimStack.this.hostPane.isVisible() && TrimStack.this.minimizedElement instanceof MPartStack) {
                TrimStack.this.updateSelection(true);
            }
        }
    };
    private EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            if (TrimStack.this.minimizedElement == null || TrimStack.this.trimStackTB == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (changedElement == TrimStack.this.minimizedElement && !TrimStack.this.minimizedElement.isToBeRendered()) {
                TrimStack.this.restoreStack();
                return;
            }
            MElementContainer parentElement = changedElement.getParent();
            if (parentElement == TrimStack.this.minimizedElement) {
                TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TrimStack.this.updateTrimStackItems();
                    }
                });
            }
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            if (TrimStack.this.minimizedElement == null || TrimStack.this.trimStackTB == null) {
                return;
            }
            Object changedObj = event.getProperty("ChangedElement");
            if (changedObj == TrimStack.this.minimizedElement) {
                TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TrimStack.this.updateTrimStackItems();
                    }
                });
            }
        }
    };
    private EventHandler widgetHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            Object changedObj = event.getProperty("ChangedElement");
            if (changedObj != TrimStack.this.minimizedElement) {
                return;
            }
            if (TrimStack.this.minimizedElement.getWidget() != null) {
                TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TrimStack.this.updateTrimStackItems();
                    }
                });
            }
        }
    };
    private MTrimBar bar;
    private int fixedSides;

    @PostConstruct
    void addListeners() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childrenHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), this.selectionHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget"), this.widgetHandler);
    }

    @PreDestroy
    void removeListeners() {
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.selectionHandler);
        this.eventBroker.unsubscribe(this.widgetHandler);
    }

    @PostConstruct
    void createWidget(Composite parent, MToolControl me) {
        if (this.minimizedElement == null) {
            this.minimizedElement = this.findElement();
        }
        MElementContainer meParent = me.getParent();
        int orientation = 256;
        if (meParent instanceof MTrimBar) {
            this.bar = (MTrimBar)meParent;
            if (this.bar.getSide() == SideValue.RIGHT || this.bar.getSide() == SideValue.LEFT) {
                orientation = 512;
            }
        }
        this.trimStackTB = new ToolBar(parent, orientation | 0x800000 | 0x40);
        this.trimStackTB.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point point = TrimStack.this.trimStackTB.getDisplay().map(null, (Control)TrimStack.this.trimStackTB, new Point(event.x, event.y));
                TrimStack.this.selectedToolItem = TrimStack.this.trimStackTB.getItem(point);
            }
        });
        if (this.minimizedElement instanceof MPartStack) {
            this.createPopupMenu();
        }
        ToolItem restoreBtn = new ToolItem(this.trimStackTB, 8);
        restoreBtn.setToolTipText(Messages.TrimStack_RestoreText);
        restoreBtn.setImage(this.getRestoreImage());
        restoreBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TrimStack.this.minimizedElement.getTags().remove(MinMaxAddon.MINIMIZED);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TrimStack.this.minimizedElement.getTags().remove(MinMaxAddon.MINIMIZED);
            }
        });
        this.updateTrimStackItems();
    }

    @PreDestroy
    void destroy() {
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        if (this.layoutImage != null) {
            this.layoutImage.dispose();
            this.layoutImage = null;
        }
        if (this.restoreImage != null) {
            this.restoreImage.dispose();
            this.restoreImage = null;
        }
    }

    private MUIElement findElement() {
        List ps = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null);
        if (ps.size() == 0) {
            String toolControlId = this.toolControl.getElementId();
            int index = toolControlId.indexOf(40);
            String stackId = toolControlId.substring(0, index);
            this.minimizedElement = (MPartStack)this.modelService.find(stackId, (MUIElement)this.window);
        } else {
            String toolControlId = this.toolControl.getElementId();
            int index = toolControlId.indexOf(40);
            String stackId = toolControlId.substring(0, index);
            String perspId = toolControlId.substring(index + 1, toolControlId.length() - 1);
            MPerspective persp = (MPerspective)this.modelService.find(perspId, (MUIElement)ps.get(0));
            this.minimizedElement = persp != null ? this.modelService.find(stackId, (MUIElement)persp) : this.modelService.find(stackId, (MUIElement)this.window);
        }
        return this.minimizedElement;
    }

    private String getLabel(MUILabel label) {
        String string = label.getLabel();
        return string == null ? "" : string;
    }

    private Image getImage(MUILabel element) {
        String iconURI = element.getIconURI();
        if (iconURI != null && iconURI.length() > 0) {
            Image image = this.imageMap.get(iconURI);
            if (image == null) {
                image = ((ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI))).createImage();
                this.imageMap.put(iconURI, image);
            }
            return image;
        }
        return null;
    }

    private MPart getPart(MStackElement element) {
        if (element instanceof MPart) {
            return (MPart)element;
        }
        return (MPart)((MPlaceholder)element).getRef();
    }

    /*
     * Unable to fully structure code
     */
    private void updateTrimStackItems() {
        block8: {
            block7: {
                if (this.trimStackTB == null || this.trimStackTB.isDisposed()) {
                    return;
                }
                if (!(this.minimizedElement instanceof MPlaceholder)) break block7;
                if (this.trimStackTB.getItemCount() == 1) {
                    ti = new ToolItem(this.trimStackTB, 8);
                    ti.setToolTipText(Messages.TrimStack_SharedAreaTooltip);
                    ti.setImage(this.getLayoutImage());
                    ti.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            TrimStack.this.showStack(!TrimStack.this.isShowing);
                            ToolItem item = (ToolItem)e.widget;
                            item.setSelection(TrimStack.this.isShowing);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            TrimStack.this.showStack(!TrimStack.this.isShowing);
                            ToolItem item = (ToolItem)e.widget;
                            item.setSelection(TrimStack.this.isShowing);
                        }
                    });
                }
                break block8;
            }
            if (!(this.minimizedElement instanceof MPartStack)) break block8;
            theStack = (MPartStack)this.minimizedElement;
            if (theStack.getWidget() == null) {
                return;
            }
            check = false;
            for (MStackElement stackElement : theStack.getChildren()) {
                if (!stackElement.isToBeRendered()) continue;
                check = true;
                break;
            }
            if (check) ** GOTO lbl24
            this.restoreStack();
            return;
lbl-1000:
            // 1 sources

            {
                this.trimStackTB.getItem(this.trimStackTB.getItemCount() - 1).dispose();
lbl24:
                // 2 sources

                ** while (this.trimStackTB.getItemCount() > 1)
            }
lbl25:
            // 3 sources

            for (MStackElement stackElement : theStack.getChildren()) {
                if (!stackElement.isToBeRendered()) continue;
                part = this.getPart(stackElement);
                newItem = new ToolItem(this.trimStackTB, 32);
                newItem.setData((Object)stackElement);
                newItem.setImage(this.getImage((MUILabel)part));
                newItem.setToolTipText(this.getLabel((MUILabel)part));
                newItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ToolItem item = (ToolItem)e.widget;
                        MUIElement me = (MUIElement)item.getData();
                        if (me instanceof MPlaceholder) {
                            me = ((MPlaceholder)me).getRef();
                        }
                        boolean show = item.getSelection();
                        TrimStack.this.partService.activate((MPart)me);
                        TrimStack.this.showStack(show);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
            }
        }
        if (this.hostPane != null && this.hostPane.isVisible()) {
            this.updateSelection(true);
        }
        this.trimStackTB.pack();
        this.trimStackTB.getShell().layout(new Control[]{this.trimStackTB}, 4);
        this.trimStackTB.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TrimStack.this.trimStackTB = null;
            }
        });
    }

    void restoreStack() {
        this.showStack(false);
        Display.getCurrent().removeFilter(3, this.mouseDownListener);
        this.minimizedElement.setVisible(true);
        this.minimizedElement.getTags().remove(MinMaxAddon.MINIMIZED);
        this.toolControl.setToBeRendered(false);
        if (this.hostPane != null && !this.hostPane.isDisposed()) {
            this.hostPane.dispose();
        }
        this.hostPane = null;
    }

    private void createPopupMenu() {
        this.trimStackMenu = new Menu((Control)this.trimStackTB);
        this.trimStackTB.setMenu(this.trimStackMenu);
        MenuItem closeItem = new MenuItem(this.trimStackMenu, 0);
        closeItem.setText(Messages.TrimStack_CloseText);
        closeItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)TrimStack.this.selectedToolItem.getData();
                if (element instanceof MPlaceholder) {
                    element = ((MPlaceholder)element).getRef();
                }
                TrimStack.this.partService.hidePart((MPart)element);
            }
        });
    }

    @Execute
    public void showStack(@Named(value="show") boolean show) {
        Control ctf = (Control)this.minimizedElement.getWidget();
        Composite clientArea = this.getShellClientComposite();
        if (clientArea == null) {
            return;
        }
        if (show && !this.isShowing) {
            this.hostPane = this.getHostPane();
            ctf.setParent(this.hostPane);
            this.hostPane.getDisplay().addFilter(3, this.mouseDownListener);
            clientArea.addControlListener(this.caResizeListener);
            this.updateSelection(true);
            this.setPaneLocation(this.hostPane);
            this.hostPane.layout(true);
            this.hostPane.moveAbove(null);
            this.hostPane.setVisible(true);
            this.isShowing = true;
        } else if (!show && this.isShowing) {
            Display.getCurrent().removeFilter(3, this.mouseDownListener);
            if (clientArea != null) {
                clientArea.removeControlListener(this.caResizeListener);
            }
            if (this.hostPane != null && this.hostPane.isVisible()) {
                this.hostPane.setVisible(false);
                this.updateSelection(false);
                Point size = this.hostPane.getSize();
                this.toolControl.getPersistedState().put("XSize", Integer.toString(size.x));
                this.toolControl.getPersistedState().put("YSize", Integer.toString(size.y));
            }
            this.isShowing = false;
        }
    }

    Composite getShellClientComposite() {
        if (this.trimStackTB.isDisposed()) {
            return null;
        }
        Shell theShell = this.trimStackTB.getShell();
        if (!(theShell.getLayout() instanceof TrimmedPartLayout)) {
            return null;
        }
        TrimmedPartLayout tpl = (TrimmedPartLayout)theShell.getLayout();
        return tpl.clientArea;
    }

    private void setPaneLocation(Composite someShell) {
        Composite clientComp = this.getShellClientComposite();
        if (clientComp == null || clientComp.isDisposed()) {
            return;
        }
        Rectangle caRect = this.getShellClientComposite().getBounds();
        Point paneSize = this.hostPane.getSize();
        Point loc = new Point(0, 0);
        loc.x = this.isFixed(16384) ? caRect.x : caRect.x + caRect.width - paneSize.x;
        loc.y = this.isFixed(128) ? caRect.y : caRect.y + caRect.height - paneSize.y;
        someShell.setLocation(loc);
    }

    private void updateSelection(boolean showing) {
        ToolItem[] items;
        if (this.trimStackTB == null || this.trimStackTB.isDisposed()) {
            return;
        }
        if (this.minimizedElement instanceof MPlaceholder) {
            this.trimStackTB.getItem(1).setSelection(showing);
            return;
        }
        MPartStack theStack = (MPartStack)this.minimizedElement;
        MStackElement selectedElement = showing ? (MStackElement)theStack.getSelectedElement() : null;
        ToolItem[] toolItemArray = items = this.trimStackTB.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item;
            item.setSelection((item = toolItemArray[n2]).getData() == selectedElement);
            ++n2;
        }
    }

    private Composite getHostPane() {
        if (this.hostPane != null) {
            return this.hostPane;
        }
        this.hostPane = new Composite((Composite)this.trimStackTB.getShell(), 0);
        this.hostPane.setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
        int xSize = 600;
        String xSizeStr = (String)this.toolControl.getPersistedState().get("XSize");
        if (xSizeStr != null) {
            xSize = Integer.parseInt(xSizeStr);
        }
        int ySize = 400;
        String ySizeStr = (String)this.toolControl.getPersistedState().get("YSize");
        if (ySizeStr != null) {
            ySize = Integer.parseInt(ySizeStr);
        }
        this.hostPane.setSize(xSize, ySize);
        this.hostPane.addListener(31, this.escapeListener);
        this.fixedSides = this.getFixedSides();
        this.hostPane.setLayout((Layout)new TrimPaneLayout(this.fixedSides));
        return this.hostPane;
    }

    private int getFixedSides() {
        int verticalValue = 128;
        if (this.bar.getSide() == SideValue.LEFT) {
            return 0x4000 | verticalValue;
        }
        if (this.bar.getSide() == SideValue.RIGHT) {
            return 0x20000 | verticalValue;
        }
        return 16512;
    }

    private Image getLayoutImage() {
        if (this.layoutImage == null) {
            this.layoutImage = ((ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)LAYOUT_ICON_URI))).createImage();
        }
        return this.layoutImage;
    }

    private Image getRestoreImage() {
        if (this.restoreImage == null) {
            this.restoreImage = ((ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)RESTORE_ICON_URI))).createImage();
        }
        return this.restoreImage;
    }

    private boolean isFixed(int swtSide) {
        return (this.fixedSides & swtSide) != 0;
    }
}

