/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class IconFinder {
    private static final String LEAF = "_leaf";
    private static final String CLOSED = "_closed";
    private static final String OPEN = "_open";
    private static final String ALT = "_alt";
    private static final String EXT_PT = "org.eclipse.help.toc";
    private static final String TOC_ICON_ELEMENT = "tocIcon";
    private static final String TOC_ICON_ID = "id";
    private static final String OPEN_ICON_PATH = "openIcon";
    private static final String CLOSED_ICON_PATH = "closedIcon";
    private static final String LEAF_ICON_PATH = "leafIcon";
    private static final String ICON_ALT_TEXT = "altText";
    private static final String PATH_SEPARATOR = "/";
    private static boolean iconsInitialized = false;
    public static int TYPEICON_OPEN = 0;
    public static int TYPEICON_CLOSED = 1;
    public static int TYPEICON_LEAF = 2;
    private static Map IconPathMap = null;

    private static void addIconPath(String IconKey, String IconPath) {
        if (IconPathMap == null) {
            IconPathMap = new HashMap();
            IconPathMap = new TreeMap();
        }
        IconPathMap.put(IconKey, IconPath);
    }

    private static String getIconPath(String IconKey) {
        return IconFinder.getEntry(IconKey);
    }

    private static String getIconAltText(String IconKey) {
        return IconFinder.getEntry(IconKey);
    }

    private static String getEntry(String IconKey) {
        if (IconPathMap == null) {
            return null;
        }
        Object key = IconPathMap.get(IconKey);
        return (String)key;
    }

    private static void setIconImagePath(String bundleId, String path, String key) {
        String iconPath = IconFinder.getIconPath(key);
        if (iconPath == null) {
            iconPath = String.valueOf(bundleId) + PATH_SEPARATOR + path;
            IconFinder.addIconPath(key, iconPath);
        }
    }

    private static void setIconAltText(String value, String key) {
        IconFinder.addIconPath(key, value);
    }

    public static String getImagePathFromId(String iconId, int type) {
        String suffix;
        if (iconId == null) {
            return null;
        }
        IconFinder.initializeTocIcons();
        switch (type) {
            case 0: {
                suffix = OPEN;
                break;
            }
            case 1: {
                suffix = CLOSED;
                break;
            }
            case 2: {
                suffix = LEAF;
                break;
            }
            default: {
                suffix = OPEN;
            }
        }
        String result = IconFinder.lookupImagePath(String.valueOf(iconId) + suffix);
        if (result != null) {
            return result;
        }
        return IconFinder.lookupImagePath(String.valueOf(iconId) + OPEN);
    }

    public static String getIconAltFromId(String iconId) {
        if (iconId == null) {
            return null;
        }
        IconFinder.initializeTocIcons();
        return IconFinder.getIconAltText(String.valueOf(iconId) + ALT);
    }

    public static boolean isIconDefined(String icon) {
        if (icon == null || icon.length() == 0) {
            return false;
        }
        String result = IconFinder.getImagePathFromId(icon, TYPEICON_OPEN);
        return result != null;
    }

    private static String lookupImagePath(String name) {
        return IconFinder.getIconPath(name);
    }

    private static void initializeTocIcons() {
        if (iconsInitialized) {
            return;
        }
        iconsInitialized = true;
        IExtension[] extensionsFound = Platform.getExtensionRegistry().getExtensionPoint(EXT_PT).getExtensions();
        int i = 0;
        while (i < extensionsFound.length) {
            IConfigurationElement[] configElements = extensionsFound[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals(TOC_ICON_ELEMENT)) {
                    IConfigurationElement iconElem = configElements[j];
                    String[] attrs = iconElem.getAttributeNames();
                    String contributorID = iconElem.getContributor().getName();
                    int k = 0;
                    while (k < attrs.length) {
                        if (attrs[k].equals(OPEN_ICON_PATH)) {
                            IconFinder.setIconImagePath(contributorID, iconElem.getAttribute(OPEN_ICON_PATH), String.valueOf(iconElem.getAttribute(TOC_ICON_ID)) + OPEN);
                        }
                        if (attrs[k].equals(CLOSED_ICON_PATH)) {
                            IconFinder.setIconImagePath(contributorID, iconElem.getAttribute(CLOSED_ICON_PATH), String.valueOf(iconElem.getAttribute(TOC_ICON_ID)) + CLOSED);
                        }
                        if (attrs[k].equals(LEAF_ICON_PATH)) {
                            IconFinder.setIconImagePath(contributorID, iconElem.getAttribute(LEAF_ICON_PATH), String.valueOf(iconElem.getAttribute(TOC_ICON_ID)) + LEAF);
                        }
                        if (attrs[k].equals(ICON_ALT_TEXT)) {
                            IconFinder.setIconAltText(iconElem.getAttribute(ICON_ALT_TEXT), String.valueOf(iconElem.getAttribute(TOC_ICON_ID)) + ALT);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

