/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;

class AccessibleTableHeader
extends Accessible {
    public AccessibleTableHeader(Accessible accessible, int childID) {
        super(accessible);
        this.index = childID;
        this.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildren(AccessibleControlEvent e) {
                int validColumnCount = Math.max(1, AccessibleTableHeader.this.parent.getColumnCount());
                Accessible[] children = new Accessible[validColumnCount];
                AccessibleControlEvent event = new AccessibleControlEvent(this);
                int i = 0;
                while (i < validColumnCount) {
                    event.childID = i;
                    event.detail = -4;
                    int j = 0;
                    while (j < AccessibleTableHeader.this.parent.accessibleControlListeners.size()) {
                        AccessibleControlListener listener = (AccessibleControlListener)AccessibleTableHeader.this.parent.accessibleControlListeners.elementAt(j);
                        listener.getChild(event);
                        ++j;
                    }
                    event.accessible.parent = AccessibleTableHeader.this;
                    children[i] = event.accessible;
                    ++i;
                }
                e.children = children;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = Math.max(1, AccessibleTableHeader.this.parent.getColumnCount());
            }

            public void getLocation(AccessibleControlEvent e) {
                int validColumnCount = Math.max(1, AccessibleTableHeader.this.parent.getColumnCount());
                Accessible[] children = new Accessible[validColumnCount];
                AccessibleControlEvent event = new AccessibleControlEvent(this);
                int i = 0;
                while (i < validColumnCount) {
                    event.childID = i;
                    event.detail = -4;
                    int j = 0;
                    while (j < AccessibleTableHeader.this.parent.accessibleControlListeners.size()) {
                        AccessibleControlListener listener = (AccessibleControlListener)AccessibleTableHeader.this.parent.accessibleControlListeners.elementAt(j);
                        listener.getChild(event);
                        ++j;
                    }
                    event.accessible.parent = AccessibleTableHeader.this;
                    children[i] = event.accessible;
                    ++i;
                }
                NSValue positionObj = (NSValue)children[0].getPositionAttribute(-1);
                NSPoint position = positionObj.pointValue();
                int height = 0;
                int width = 0;
                int j = 0;
                while (j < children.length) {
                    NSValue sizeObj = (NSValue)children[j].getSizeAttribute(-1);
                    NSSize size = sizeObj.sizeValue();
                    if (size.height > (double)height) {
                        height = (int)size.height;
                    }
                    width = (int)((double)width + size.width);
                    ++j;
                }
                e.x = (int)position.x;
                NSArray screens = NSScreen.screens();
                NSScreen screen = new NSScreen(screens.objectAtIndex(0L));
                NSRect frame = screen.frame();
                e.y = (int)(frame.height - position.y - (double)height);
                e.width = width;
                e.height = height;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 25;
            }
        });
    }
}

