/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public long pixmap;
    public long mask;
    long surface;
    long surfaceData;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int width, int height) {
        super(device);
        this.init(width, height);
        this.init();
    }

    public Image(Device device, Image srcImage, int flag) {
        super(device);
        long gdkGC;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        device = this.device;
        this.type = srcImage.type;
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(srcImage.pixmap, w, h);
        int width = w[0];
        int height = h[0];
        if (srcImage.type == 1 && srcImage.mask != 0L || srcImage.transparentPixel != -1) {
            long mask;
            if (srcImage.transparentPixel != -1) {
                srcImage.createMask();
            }
            if ((mask = OS.gdk_pixmap_new(0L, width, height, 1)) == 0L) {
                SWT.error(2);
            }
            if ((gdkGC = OS.gdk_gc_new(mask)) == 0L) {
                SWT.error(2);
            }
            OS.gdk_draw_drawable(mask, gdkGC, srcImage.mask, 0, 0, 0, 0, width, height);
            OS.g_object_unref(gdkGC);
            this.mask = mask;
            if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
                srcImage.destroyMask();
            }
        }
        if (flag != 1) {
            this.transparentPixel = srcImage.transparentPixel;
        }
        this.alpha = srcImage.alpha;
        if (srcImage.alphaData != null) {
            this.alphaData = new byte[srcImage.alphaData.length];
            System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
        }
        this.createAlphaMask(width, height);
        long pixmap = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, -1);
        if (pixmap == 0L) {
            SWT.error(2);
        }
        if ((gdkGC = OS.gdk_gc_new(pixmap)) == 0L) {
            SWT.error(2);
        }
        this.pixmap = pixmap;
        if (flag == 0) {
            OS.gdk_draw_drawable(pixmap, gdkGC, srcImage.pixmap, 0, 0, 0, 0, width, height);
            OS.g_object_unref(gdkGC);
        } else {
            long pixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height);
            if (pixbuf == 0L) {
                SWT.error(2);
            }
            long colormap = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(pixbuf, srcImage.pixmap, colormap, 0, 0, 0, 0, width, height);
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            switch (flag) {
                case 1: {
                    Color zeroColor = device.getSystemColor(18);
                    RGB zeroRGB = zeroColor.getRGB();
                    byte zeroRed = (byte)zeroRGB.red;
                    byte zeroGreen = (byte)zeroRGB.green;
                    byte zeroBlue = (byte)zeroRGB.blue;
                    Color oneColor = device.getSystemColor(22);
                    RGB oneRGB = oneColor.getRGB();
                    byte oneRed = (byte)oneRGB.red;
                    byte oneGreen = (byte)oneRGB.green;
                    byte oneBlue = (byte)oneRGB.blue;
                    byte[] line = new byte[stride];
                    int y = 0;
                    while (y < height) {
                        OS.memmove(line, pixels + (long)(y * stride), (long)stride);
                        int x = 0;
                        while (x < width) {
                            int offset = x * 3;
                            int red = line[offset] & 0xFF;
                            int green = line[offset + 1] & 0xFF;
                            int blue = line[offset + 2] & 0xFF;
                            int intensity = red * red + green * green + blue * blue;
                            if (intensity < 98304) {
                                line[offset] = zeroRed;
                                line[offset + 1] = zeroGreen;
                                line[offset + 2] = zeroBlue;
                            } else {
                                line[offset] = oneRed;
                                line[offset + 1] = oneGreen;
                                line[offset + 2] = oneBlue;
                            }
                            ++x;
                        }
                        OS.memmove(pixels + (long)(y * stride), line, (long)stride);
                        ++y;
                    }
                    break;
                }
                case 2: {
                    byte[] line = new byte[stride];
                    int y = 0;
                    while (y < height) {
                        OS.memmove(line, pixels + (long)(y * stride), (long)stride);
                        int x = 0;
                        while (x < width) {
                            byte intensity;
                            int offset = x * 3;
                            int red = line[offset] & 0xFF;
                            int green = line[offset + 1] & 0xFF;
                            int blue = line[offset + 2] & 0xFF;
                            byte by = intensity = (byte)(red + red + green + green + green + green + green + blue >> 3);
                            line[offset + 2] = by;
                            line[offset + 1] = by;
                            line[offset] = by;
                            ++x;
                        }
                        OS.memmove(pixels + (long)(y * stride), line, (long)stride);
                        ++y;
                    }
                    break;
                }
            }
            OS.gdk_pixbuf_render_to_drawable(pixbuf, pixmap, gdkGC, 0, 0, 0, 0, width, height, 1, 0, 0);
            OS.g_object_unref(pixbuf);
            OS.g_object_unref(gdkGC);
        }
        this.init();
    }

    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(bounds.width, bounds.height);
        this.init();
    }

    public Image(Device device, ImageData data) {
        super(device);
        this.init(data);
        this.init();
    }

    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
        image.maskPad = mask.scanlinePad;
        image.maskData = mask.data;
        this.init(image);
        this.init();
    }

    public Image(Device device, InputStream stream) {
        super(device);
        this.init(new ImageData(stream));
        this.init();
    }

    public Image(Device device, String filename) {
        super(device);
        if (filename == null) {
            SWT.error(4);
        }
        this.initNative(filename);
        if (this.pixmap == 0L) {
            this.init(new ImageData(filename));
        }
        this.init();
    }

    void initNative(String filename) {
        try {
            int length = filename.length();
            char[] chars = new char[length];
            filename.getChars(0, length, chars, 0);
            byte[] buffer = Converter.wcsToMbcs(null, chars, true);
            long pixbuf = OS.gdk_pixbuf_new_from_file(buffer, null);
            if (pixbuf != 0L) {
                boolean hasAlpha = OS.gdk_pixbuf_get_has_alpha(pixbuf);
                if (hasAlpha) {
                    int width = OS.gdk_pixbuf_get_width(pixbuf);
                    int height = OS.gdk_pixbuf_get_height(pixbuf);
                    int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                    long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                    byte[] line = new byte[stride];
                    this.alphaData = new byte[width * height];
                    int y = 0;
                    while (y < height) {
                        OS.memmove(line, pixels + (long)(y * stride), (long)stride);
                        int x = 0;
                        while (x < width) {
                            this.alphaData[y * width + x] = line[x * 4 + 3];
                            line[x * 4 + 3] = -1;
                            ++x;
                        }
                        OS.memmove(pixels + (long)(y * stride), line, (long)stride);
                        ++y;
                    }
                    this.createAlphaMask(width, height);
                }
                long[] pixmap_return = new long[1];
                OS.gdk_pixbuf_render_pixmap_and_mask(pixbuf, pixmap_return, null, 0);
                this.type = 0;
                this.pixmap = pixmap_return[0];
                if (this.pixmap == 0L) {
                    SWT.error(2);
                }
                OS.g_object_unref(pixbuf);
            }
        }
        catch (SWTException sWTException) {}
    }

    void createAlphaMask(int width, int height) {
        if (this.device.useXRender && (this.alpha != -1 || this.alphaData != null)) {
            this.mask = OS.gdk_pixmap_new(0L, this.alpha != -1 ? 1 : width, this.alpha != -1 ? 1 : height, 8);
            if (this.mask == 0L) {
                SWT.error(2);
            }
            long gc = OS.gdk_gc_new(this.mask);
            if (this.alpha != -1) {
                GdkColor color = new GdkColor();
                color.pixel = (this.alpha & 0xFF) << 8 | this.alpha & 0xFF;
                OS.gdk_gc_set_foreground(gc, color);
                OS.gdk_draw_rectangle(this.mask, gc, 1, 0, 0, 1, 1);
            } else {
                long imagePtr = OS.gdk_drawable_get_image(this.mask, 0, 0, width, height);
                if (imagePtr == 0L) {
                    SWT.error(2);
                }
                GdkImage gdkImage = new GdkImage();
                OS.memmove(gdkImage, imagePtr);
                if (gdkImage.bpl == width) {
                    OS.memmove(gdkImage.mem, this.alphaData, (long)this.alphaData.length);
                } else {
                    byte[] line = new byte[gdkImage.bpl];
                    int y = 0;
                    while (y < height) {
                        System.arraycopy(this.alphaData, width * y, line, 0, width);
                        OS.memmove(gdkImage.mem + (long)(gdkImage.bpl * y), line, (long)gdkImage.bpl);
                        ++y;
                    }
                }
                OS.gdk_draw_image(this.mask, gc, imagePtr, 0, 0, 0, 0, width, height);
                OS.g_object_unref(imagePtr);
            }
            OS.g_object_unref(gc);
        }
    }

    void createMask() {
        if (this.mask != 0L) {
            return;
        }
        this.mask = this.createMask(this.getImageData(), false);
        if (this.mask == 0L) {
            SWT.error(2);
        }
    }

    long createMask(ImageData image, boolean copy) {
        ImageData mask = image.getTransparencyMask();
        byte[] data = mask.data;
        byte[] maskData = copy ? new byte[data.length] : data;
        int i = 0;
        while (i < maskData.length) {
            byte s = data[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            ++i;
        }
        maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
        return OS.gdk_bitmap_create_from_data(0L, maskData, mask.width, mask.height);
    }

    void createSurface() {
        if (this.surface != 0L) {
            return;
        }
        if (this.transparentPixel != -1) {
            this.createMask();
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, w, h);
        int width = w[0];
        int height = h[0];
        if (this.mask != 0L || this.alpha != -1 || this.alphaData != null) {
            int ob;
            int og;
            int or;
            int oa;
            boolean bigendian;
            long pixbuf = OS.gdk_pixbuf_new(0, true, 8, width, height);
            if (pixbuf == 0L) {
                SWT.error(2);
            }
            long colormap = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(pixbuf, this.pixmap, colormap, 0, 0, 0, 0, width, height);
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            byte[] line = new byte[stride];
            long ptr = OS.malloc(4L);
            OS.memmove(ptr, new int[]{1}, 4L);
            OS.memmove(line, ptr, 1L);
            OS.free(ptr);
            boolean bl = bigendian = line[0] == 0;
            if (bigendian) {
                oa = 0;
                or = 1;
                og = 2;
                ob = 3;
            } else {
                oa = 3;
                or = 2;
                og = 1;
                ob = 0;
            }
            if (this.mask != 0L && OS.gdk_drawable_get_depth(this.mask) == 1) {
                long maskPixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height);
                if (maskPixbuf == 0L) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(maskPixbuf, this.mask, 0L, 0, 0, 0, 0, width, height);
                int maskStride = OS.gdk_pixbuf_get_rowstride(maskPixbuf);
                long maskPixels = OS.gdk_pixbuf_get_pixels(maskPixbuf);
                byte[] maskLine = new byte[maskStride];
                long offset = pixels;
                long maskOffset = maskPixels;
                int y = 0;
                while (y < height) {
                    OS.memmove(line, offset, (long)stride);
                    OS.memmove(maskLine, maskOffset, (long)maskStride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        if (maskLine[x * 3] == 0) {
                            line[offset1 + 3] = 0;
                            line[offset1 + 2] = 0;
                            line[offset1 + 1] = 0;
                            line[offset1 + 0] = 0;
                        } else {
                            byte r = line[offset1 + 0];
                            byte g = line[offset1 + 1];
                            byte b = line[offset1 + 2];
                            line[offset1 + oa] = -1;
                            line[offset1 + or] = r;
                            line[offset1 + og] = g;
                            line[offset1 + ob] = b;
                        }
                        ++x;
                        offset1 += 4;
                    }
                    OS.memmove(offset, line, (long)stride);
                    offset += (long)stride;
                    maskOffset += (long)maskStride;
                    ++y;
                }
                OS.g_object_unref(maskPixbuf);
            } else if (this.alpha != -1) {
                long offset = pixels;
                int y = 0;
                while (y < height) {
                    OS.memmove(line, offset, (long)stride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        int r = (line[offset1 + 0] & 0xFF) * this.alpha + 128;
                        r = r + (r >> 8) >> 8;
                        int g = (line[offset1 + 1] & 0xFF) * this.alpha + 128;
                        g = g + (g >> 8) >> 8;
                        int b = (line[offset1 + 2] & 0xFF) * this.alpha + 128;
                        b = b + (b >> 8) >> 8;
                        line[offset1 + oa] = (byte)this.alpha;
                        line[offset1 + or] = (byte)r;
                        line[offset1 + og] = (byte)g;
                        line[offset1 + ob] = (byte)b;
                        ++x;
                        offset1 += 4;
                    }
                    OS.memmove(offset, line, (long)stride);
                    offset += (long)stride;
                    ++y;
                }
            } else if (this.alphaData != null) {
                long offset = pixels;
                int y = 0;
                while (y < h[0]) {
                    OS.memmove(line, offset, (long)stride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        int alpha = this.alphaData[y * w[0] + x] & 0xFF;
                        int r = (line[offset1 + 0] & 0xFF) * alpha + 128;
                        r = r + (r >> 8) >> 8;
                        int g = (line[offset1 + 1] & 0xFF) * alpha + 128;
                        g = g + (g >> 8) >> 8;
                        int b = (line[offset1 + 2] & 0xFF) * alpha + 128;
                        b = b + (b >> 8) >> 8;
                        line[offset1 + oa] = (byte)alpha;
                        line[offset1 + or] = (byte)r;
                        line[offset1 + og] = (byte)g;
                        line[offset1 + ob] = (byte)b;
                        ++x;
                        offset1 += 4;
                    }
                    OS.memmove(offset, line, (long)stride);
                    offset += (long)stride;
                    ++y;
                }
            } else {
                long offset = pixels;
                int y = 0;
                while (y < h[0]) {
                    OS.memmove(line, offset, (long)stride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        byte r = line[offset1 + 0];
                        byte g = line[offset1 + 1];
                        byte b = line[offset1 + 2];
                        line[offset1 + oa] = -1;
                        line[offset1 + or] = r;
                        line[offset1 + og] = g;
                        line[offset1 + ob] = b;
                        ++x;
                        offset1 += 4;
                    }
                    OS.memmove(offset, line, (long)stride);
                    offset += (long)stride;
                    ++y;
                }
            }
            this.surfaceData = OS.g_malloc(stride * height);
            OS.memmove(this.surfaceData, pixels, (long)(stride * height));
            this.surface = Cairo.cairo_image_surface_create_for_data(this.surfaceData, 0, width, height, stride);
            OS.g_object_unref(pixbuf);
        } else {
            long xDisplay = OS.GDK_DISPLAY();
            long xDrawable = OS.GDK_PIXMAP_XID(this.pixmap);
            long xVisual = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            this.surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, width, height);
        }
        if (this.transparentPixel != -1 && this.memGC != null) {
            this.destroyMask();
        }
    }

    void destroyMask() {
        if (this.mask == 0L) {
            return;
        }
        OS.g_object_unref(this.mask);
        this.mask = 0L;
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.pixmap != 0L) {
            OS.g_object_unref(this.pixmap);
        }
        if (this.mask != 0L) {
            OS.g_object_unref(this.mask);
        }
        if (this.surface != 0L) {
            Cairo.cairo_surface_destroy(this.surface);
        }
        if (this.surfaceData != 0L) {
            OS.g_free(this.surfaceData);
        }
        this.mask = 0L;
        this.pixmap = 0L;
        this.surface = 0L;
        this.surfaceData = 0L;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.pixmap == image.pixmap;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, w, h);
        this.width = w[0];
        this.height = h[0];
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, w, h);
        int width = w[0];
        int height = h[0];
        long pixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height);
        if (pixbuf == 0L) {
            SWT.error(2);
        }
        long colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(pixbuf, this.pixmap, colormap, 0, 0, 0, 0, width, height);
        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
        long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
        byte[] srcData = new byte[stride * height];
        OS.memmove(srcData, pixels, (long)srcData.length);
        OS.g_object_unref(pixbuf);
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData(width, height, 24, palette, 4, srcData);
        data.bytesPerLine = stride;
        if (this.transparentPixel == -1 && this.type == 1 && this.mask != 0L) {
            long gdkImagePtr = OS.gdk_drawable_get_image(this.mask, 0, 0, width, height);
            if (gdkImagePtr == 0L) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, gdkImagePtr);
            byte[] maskData = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(maskData, gdkImage.mem, (long)maskData.length);
            OS.g_object_unref(gdkImagePtr);
            int maskPad = 1;
            while (maskPad < 128) {
                int bpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
                if (gdkImage.bpl == bpl) break;
                ++maskPad;
            }
            data.maskPad = 2;
            maskData = ImageData.convertPad(maskData, width, height, 1, maskPad, data.maskPad);
            if (gdkImage.byte_order == 0) {
                int i = 0;
                while (i < maskData.length) {
                    byte b = maskData[i];
                    maskData[i] = (byte)((b & 1) << 7 | (b & 2) << 5 | (b & 4) << 3 | (b & 8) << 1 | (b & 0x10) >> 1 | (b & 0x20) >> 3 | (b & 0x40) >> 5 | (b & 0x80) >> 7);
                    ++i;
                }
            }
            data.maskData = maskData;
        }
        data.transparentPixel = this.transparentPixel;
        data.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            data.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, data.alphaData, 0, this.alphaData.length);
        }
        return data;
    }

    public static Image gtk_new(Device device, int type, long pixmap, long mask) {
        Image image = new Image(device);
        image.type = type;
        image.pixmap = pixmap;
        image.mask = mask;
        return image;
    }

    public int hashCode() {
        return (int)this.pixmap;
    }

    void init(int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.pixmap = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, -1);
        if (this.pixmap == 0L) {
            SWT.error(2);
        }
        GdkColor white = new GdkColor();
        white.red = (short)-1;
        white.green = (short)-1;
        white.blue = (short)-1;
        long colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color(colormap, white, true, true);
        long gdkGC = OS.gdk_gc_new(this.pixmap);
        OS.gdk_gc_set_foreground(gdkGC, white);
        OS.gdk_draw_rectangle(this.pixmap, gdkGC, 1, 0, 0, width, height);
        OS.g_object_unref(gdkGC);
        OS.gdk_colormap_free_colors(colormap, white, 1);
    }

    void init(ImageData image) {
        boolean isIcon;
        long gdkGC;
        long pixbuf;
        if (image == null) {
            SWT.error(4);
        }
        int width = image.width;
        int height = image.height;
        PaletteData palette = image.palette;
        if ((image.depth != 1 && image.depth != 2 && image.depth != 4 && image.depth != 8 || palette.isDirect) && image.depth != 8 && (image.depth != 16 && image.depth != 24 && image.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        if ((pixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height)) == 0L) {
            SWT.error(2);
        }
        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
        long data = OS.gdk_pixbuf_get_pixels(pixbuf);
        byte[] buffer = image.data;
        if (!palette.isDirect || image.depth != 24 || stride != image.bytesPerLine || palette.redMask != 0xFF0000 || palette.greenMask != 65280 || palette.blueMask != 255) {
            buffer = new byte[stride * height];
            if (palette.isDirect) {
                ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 24, stride, 1, 0, 0, width, height, 0xFF0000, 65280, 255, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                int i = 0;
                while (i < rgbs.length) {
                    RGB rgb = rgbs[i];
                    if (rgb != null) {
                        srcReds[i] = (byte)rgb.red;
                        srcGreens[i] = (byte)rgb.green;
                        srcBlues[i] = (byte)rgb.blue;
                    }
                    ++i;
                }
                ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 24, stride, 1, 0, 0, width, height, 0xFF0000, 65280, 255, false, false);
            }
        }
        OS.memmove(data, buffer, (long)(stride * height));
        long pixmap = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, -1);
        if (pixmap == 0L) {
            SWT.error(2);
        }
        if ((gdkGC = OS.gdk_gc_new(pixmap)) == 0L) {
            SWT.error(2);
        }
        OS.gdk_pixbuf_render_to_drawable(pixbuf, pixmap, gdkGC, 0, 0, 0, 0, width, height, 1, 0, 0);
        OS.g_object_unref(gdkGC);
        OS.g_object_unref(pixbuf);
        boolean bl = isIcon = image.getTransparencyType() == 2;
        if (isIcon || image.transparentPixel != -1) {
            long mask;
            if (image.transparentPixel != -1) {
                RGB rgb = null;
                if (palette.isDirect) {
                    rgb = palette.getRGB(image.transparentPixel);
                } else if (image.transparentPixel < palette.colors.length) {
                    rgb = palette.getRGB(image.transparentPixel);
                }
                if (rgb != null) {
                    this.transparentPixel = rgb.red << 16 | rgb.green << 8 | rgb.blue;
                }
            }
            if ((mask = this.createMask(image, isIcon)) == 0L) {
                SWT.error(2);
            }
            this.mask = mask;
            this.type = isIcon ? 1 : 0;
        } else {
            this.type = 0;
            this.mask = 0L;
            this.alpha = image.alpha;
            if (image.alpha == -1 && image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            this.createAlphaMask(width, height);
        }
        this.pixmap = pixmap;
    }

    public long internal_new_GC(GCData data) {
        if (this.pixmap == 0L) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        long gdkGC = OS.gdk_gc_new(this.pixmap);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            } else if ((data.style & 0x4000000) != 0) {
                data.style |= 0x8000000;
            }
            data.device = this.device;
            data.drawable = this.pixmap;
            data.background = this.device.COLOR_WHITE.handle;
            data.foreground = this.device.COLOR_BLACK.handle;
            data.font = this.device.systemFont;
            data.image = this;
        }
        return gdkGC;
    }

    public void internal_dispose_GC(long gdkGC, GCData data) {
        OS.g_object_unref(gdkGC);
    }

    public boolean isDisposed() {
        return this.pixmap == 0L;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.pixmap + "}";
    }
}

