/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.util.Date;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;

public class LogEntry
extends PlatformObject
implements ILogEntry {
    private RemoteFile file;
    private String author;
    private Date date;
    private String comment;
    private String state;
    private CVSTag[] tags;
    private CVSTag[] branches;
    private String[] revisions;

    public static String flattenText(String string) {
        StringBuffer buffer = new StringBuffer(string.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                if (!skipAdjacentLineSeparator) {
                    buffer.append(CVSMessages.LogEntry_0);
                }
                skipAdjacentLineSeparator = true;
            } else {
                buffer.append(c);
                skipAdjacentLineSeparator = false;
            }
            ++i;
        }
        return buffer.toString();
    }

    public LogEntry(RemoteFile file, String revision, String author, Date date, String comment, String state, CVSTag[] tags, CVSTag[] branches) {
        this.file = file.toRevision(revision);
        this.author = author;
        this.date = date;
        this.comment = comment;
        this.state = state;
        this.tags = tags;
        this.branches = branches;
    }

    public LogEntry(RemoteFile file, String revision, String author, Date date, String comment, String state, CVSTag[] tags, CVSTag[] branches, String[] revisions) {
        this(file, revision, author, date, comment, state, tags, branches);
        this.revisions = revisions;
    }

    public String getRevision() {
        return this.file.getRevision();
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date;
    }

    public String getComment() {
        return this.comment;
    }

    public String getState() {
        return this.state;
    }

    public CVSTag[] getBranches() {
        CVSTag[] result = new CVSTag[this.branches.length];
        System.arraycopy(this.branches, 0, result, 0, this.branches.length);
        return result;
    }

    public CVSTag[] getTags() {
        CVSTag[] result = new CVSTag[this.tags.length];
        System.arraycopy(this.tags, 0, result, 0, this.tags.length);
        return result;
    }

    public ICVSRemoteFile getRemoteFile() {
        return this.file;
    }

    public boolean isDeletion() {
        return this.getState().equals("dead");
    }

    public String[] getBranchRevisions() {
        if (this.revisions != null) {
            return this.revisions;
        }
        return new String[0];
    }
}

