/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.htmlwriter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.ease.helpgenerator.IReporter;
import org.eclipse.ease.helpgenerator.htmlwriter.SynopsisBuilder;
import org.eclipse.ease.helpgenerator.model.AbstractClassModel;
import org.eclipse.ease.helpgenerator.model.Description;
import org.eclipse.ease.helpgenerator.model.Field;
import org.eclipse.ease.helpgenerator.model.Method;
import org.eclipse.ease.helpgenerator.model.ModuleDefinition;
import org.eclipse.ease.helpgenerator.model.Parameter;
import org.eclipse.ease.helpgenerator.model.ScriptExample;

public class HtmlWriter {
    private static final String LINE_DELIMITER = "\n";
    private final IReporter fReporter;
    private final ModuleDefinition fModule;
    private final AbstractClassModel fClassModel;

    private static void addText(StringBuffer buffer, Object text) {
        buffer.append(text);
    }

    private static void addLine(StringBuffer buffer, Object text) {
        buffer.append(text).append(LINE_DELIMITER);
    }

    private static String escapeText(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public HtmlWriter(ModuleDefinition module, AbstractClassModel classModel, IReporter reporter) {
        this.fModule = module;
        this.fClassModel = classModel;
        this.fReporter = reporter;
    }

    protected IReporter getReporter() {
        return this.fReporter;
    }

    private String getModuleName() {
        return this.fModule.getName();
    }

    public String createContents() {
        StringBuffer buffer = new StringBuffer();
        HtmlWriter.addLine(buffer, "<html>");
        HtmlWriter.addLine(buffer, "<head>");
        HtmlWriter.addLine(buffer, "\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        HtmlWriter.addLine(buffer, "\t<link rel=\"stylesheet\" type=\"text/css\" href=\"../../org.eclipse.ease.help/help/css/modules_reference.css\" />");
        HtmlWriter.addLine(buffer, "</head>");
        HtmlWriter.addLine(buffer, "<body>");
        HtmlWriter.addText(buffer, "\t<div class=\"module\" title=\"");
        HtmlWriter.addText(buffer, this.getModuleName());
        HtmlWriter.addLine(buffer, " Module\">");
        HtmlWriter.addText(buffer, "\t\t<h1>");
        HtmlWriter.addText(buffer, this.getModuleName());
        HtmlWriter.addLine(buffer, " Module</h1>");
        Description classComment = this.fClassModel.getClassDocumentation();
        if (!classComment.isEmpty()) {
            HtmlWriter.addText(buffer, "\t\t<p class=\"description\">");
            HtmlWriter.addText(buffer, classComment);
            HtmlWriter.addLine(buffer, "</p>");
            if (this.fClassModel.isDeprecated()) {
                HtmlWriter.addText(buffer, "\t\t<p class=\"deprecated\"><span class=\"warning\"></span><b>Deprecated:</b> <i>");
                HtmlWriter.addText(buffer, this.fClassModel.getDeprecationMessage());
                HtmlWriter.addLine(buffer, "</i></p>");
            }
        } else {
            this.getReporter().reportMissingDocs("Missing class comment for " + this.fClassModel.getClassName());
        }
        HtmlWriter.addLine(buffer, this.createDependenciesSection());
        HtmlWriter.addLine(buffer, "\t</div>");
        HtmlWriter.addLine(buffer, this.createConstantsSection());
        HtmlWriter.addLine(buffer, this.createOverviewSection());
        HtmlWriter.addLine(buffer, this.createDetailSection());
        HtmlWriter.addLine(buffer, "</body>");
        HtmlWriter.addLine(buffer, "</html>");
        return buffer.toString();
    }

    private StringBuffer createDependenciesSection() {
        StringBuffer buffer = new StringBuffer();
        if (this.fModule.hasDependencies()) {
            HtmlWriter.addLine(buffer, "\t<h3>Dependencies</h3>");
            HtmlWriter.addLine(buffer, "\t<p>This module depends on following other modules which will automatically be loaded.</p>");
            HtmlWriter.addLine(buffer, "\t<ul class=\"dependency\">");
            for (ModuleDefinition dependency : this.fModule.getDependencies()) {
                HtmlWriter.addLine(buffer, "\t\t<li>{@module " + dependency.getId() + "}</li>");
            }
            HtmlWriter.addLine(buffer, "\t</ul>");
        }
        return buffer;
    }

    private StringBuffer createDetailSection() {
        StringBuffer buffer = new StringBuffer();
        HtmlWriter.addLine(buffer, "\t<h2>Methods</h2>");
        for (Method method : this.fClassModel.getExportedMethods()) {
            HtmlWriter.addText(buffer, "\t<div class=\"command\" data-method=\"");
            HtmlWriter.addText(buffer, method.getName());
            HtmlWriter.addLine(buffer, "\">");
            HtmlWriter.addLine(buffer, "\t\t<h3" + (method.isDeprecated() ? " class=\"deprecatedText\"" : "") + "><a id=\"" + method.getName() + "\">" + method.getName() + "</a></h3>");
            HtmlWriter.addLine(buffer, this.createSynopsis(method));
            HtmlWriter.addLine(buffer, "\t\t<p class=\"description\">" + method.getComment() + "</p>");
            if (method.getComment().isEmpty()) {
                this.getReporter().reportMissingDocs("Missing comment for " + this.fClassModel.getClassName() + "." + method.getName() + "()");
            }
            if (method.isDeprecated()) {
                String deprecationText = method.getDeprecationMessage();
                if (deprecationText.isEmpty()) {
                    deprecationText = "This method is deprecated and might be removed in future versions.";
                }
                HtmlWriter.addLine(buffer, "\t\t<p class=\"deprecated\"><span class=\"warning\"></span><b>Deprecated:</b> <i>" + deprecationText + "</i></p>");
            }
            HtmlWriter.addLine(buffer, this.createAliases(method));
            HtmlWriter.addLine(buffer, this.createParametersArea(method));
            HtmlWriter.addLine(buffer, this.createReturnValueArea(method));
            HtmlWriter.addLine(buffer, this.createExceptionArea(method));
            HtmlWriter.addLine(buffer, this.createExampleArea(method));
            HtmlWriter.addLine(buffer, "\t</div>");
        }
        return buffer;
    }

    private StringBuffer createExampleArea(Method method) {
        StringBuffer buffer = new StringBuffer();
        if (!method.getExamples().isEmpty()) {
            HtmlWriter.addLine(buffer, "\t\t<dl class=\"examples\">");
            for (ScriptExample example : method.getExamples()) {
                HtmlWriter.addLine(buffer, "\t\t\t<dt>" + example.getCode() + "</dt>");
                HtmlWriter.addText(buffer, "\t\t\t<dd class=\"description\">" + example.getComment());
                HtmlWriter.addLine(buffer, "           </dd>");
            }
            HtmlWriter.addLine(buffer, "\t\t</dl>");
        }
        return buffer;
    }

    private StringBuffer createReturnValueArea(Method method) {
        StringBuffer buffer = new StringBuffer();
        if (!method.getReturnType().isVoid()) {
            HtmlWriter.addText(buffer, "\t\t<p class=\"return\">");
            Description comment = method.getReturnType().getComment();
            if (comment.isEmpty()) {
                this.getReporter().reportMissingDocs("Missing return statement documentation for " + this.fClassModel.getClassName() + "." + method.getName() + "()");
            } else {
                HtmlWriter.addText(buffer, comment);
            }
            HtmlWriter.addLine(buffer, "</p>");
        }
        return buffer;
    }

    private StringBuffer createParametersArea(Method method) {
        StringBuffer buffer = new StringBuffer();
        if (!method.getParameters().isEmpty()) {
            HtmlWriter.addLine(buffer, "\t\t<dl class=\"parameters\">");
            for (Parameter parameter : method.getParameters()) {
                String defaultValue;
                HtmlWriter.addLine(buffer, "\t\t\t<dt>" + parameter.getName() + "</dt>");
                HtmlWriter.addText(buffer, "\t\t\t<dd class=\"description\" data-parameter=\"" + parameter.getName() + "\">" + parameter.getComment());
                if (parameter.getComment().isEmpty()) {
                    this.getReporter().reportMissingDocs("Missing parameter documentation for " + this.fClassModel.getClassName() + "." + method.getName() + "(" + parameter.getName() + ")");
                }
                if ((defaultValue = parameter.getDefaultValue()) != null) {
                    HtmlWriter.addText(buffer, "<span class=\"optional\"><b>Optional:</b> defaults to &lt;<i>");
                    if (!String.class.getName().equals(parameter.getTypeName())) {
                        if (defaultValue.startsWith("\"")) {
                            defaultValue = defaultValue.substring(1);
                        }
                        if (defaultValue.endsWith("\"")) {
                            defaultValue = defaultValue.substring(0, defaultValue.length() - 1);
                        }
                    }
                    if (defaultValue.contains("org.eclipse.ease.modules.ScriptParameter.null")) {
                        HtmlWriter.addText(buffer, "null");
                    } else {
                        HtmlWriter.addText(buffer, HtmlWriter.escapeText(defaultValue));
                    }
                    HtmlWriter.addText(buffer, "</i>&gt;.</span>");
                }
                HtmlWriter.addLine(buffer, "</dd>");
            }
            HtmlWriter.addLine(buffer, "\t\t</dl>");
        }
        return buffer;
    }

    private StringBuffer createExceptionArea(Method method) {
        StringBuffer buffer = new StringBuffer();
        if (!method.getExceptions().isEmpty()) {
            HtmlWriter.addLine(buffer, "\t\t<dl class=\"exceptions\">");
            for (Parameter parameter : method.getExceptions()) {
                HtmlWriter.addLine(buffer, "\t\t\t<dt>{@link " + parameter.getName() + "}</dt>");
                HtmlWriter.addText(buffer, "\t\t\t<dd class=\"description\" data-exception=\"" + parameter.getName() + "\">" + parameter.getComment());
                HtmlWriter.addLine(buffer, "           </dd>");
                if (!parameter.getComment().isEmpty()) continue;
                this.getReporter().reportMissingDocs("Missing exception documentation for " + this.fClassModel.getClassName() + "." + method.getName() + "() - " + parameter.getName());
            }
            HtmlWriter.addLine(buffer, "\t\t</dl>");
        }
        return buffer;
    }

    private StringBuffer createAliases(Method method) {
        StringBuffer buffer = new StringBuffer();
        Collection<String> aliases = method.getAliases();
        if (!aliases.isEmpty()) {
            HtmlWriter.addLine(buffer, "\t\t<p class=\"synonyms\"><em>Alias:</em>");
            for (String alias : aliases) {
                HtmlWriter.addText(buffer, " " + alias + "(),");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            HtmlWriter.addLine(buffer, "</p>");
        }
        return buffer;
    }

    private String createSynopsis(Method method) {
        return String.format("\t\t<p class=\"synopsis\">%s</p>", SynopsisBuilder.getInstance().build(method));
    }

    private StringBuffer createOverviewSection() {
        StringBuffer buffer = new StringBuffer();
        HtmlWriter.addLine(buffer, "\t<h2>Method Overview</h2>");
        HtmlWriter.addLine(buffer, "\t<table class=\"functions\">");
        HtmlWriter.addLine(buffer, "\t\t<tr>");
        HtmlWriter.addLine(buffer, "\t\t\t<th>Method</th>");
        HtmlWriter.addLine(buffer, "\t\t\t<th>Description</th>");
        HtmlWriter.addLine(buffer, "\t\t</tr>");
        ArrayList<Overview> overview = new ArrayList<Overview>();
        for (Method method : this.fClassModel.getExportedMethods()) {
            overview.add(new Overview(method.getName(), method.getName(), method.getComment(), method.isDeprecated()));
            for (String alias : method.getAliases()) {
                overview.add(new Overview(alias, method.getName(), new Description("Alias for <a href=\"#" + method.getName() + "\">" + method.getName() + "()</a>."), method.isDeprecated()));
            }
        }
        Collections.sort(overview);
        for (Overview entry : overview) {
            HtmlWriter.addLine(buffer, "\t\t<tr>");
            if (!entry.fDeprecated) {
                HtmlWriter.addLine(buffer, "\t\t\t<td><a href=\"#" + entry.fLinkID + "\">" + entry.fTitle + "</a>()</td>");
                HtmlWriter.addLine(buffer, "\t\t\t<td>" + entry.fDescription.getFirstSentence() + "</td>");
            } else {
                HtmlWriter.addLine(buffer, "\t\t\t<td class=\"deprecatedText\"><a href=\"#" + entry.fLinkID + "\">" + entry.fTitle + "</a>()</td>");
                HtmlWriter.addLine(buffer, "\t\t\t<td class=\"deprecatedDescription\"><b>Deprecated:</b> " + entry.fDescription.getFirstSentence() + "</td>");
            }
            HtmlWriter.addLine(buffer, "\t\t</tr>");
        }
        HtmlWriter.addLine(buffer, "\t</table>");
        HtmlWriter.addLine(buffer, "");
        return buffer;
    }

    private StringBuffer createConstantsSection() {
        StringBuffer buffer = new StringBuffer();
        List<Field> fields = this.fClassModel.getExportedFields();
        Collections.sort(fields, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        if (!fields.isEmpty()) {
            HtmlWriter.addLine(buffer, "");
            HtmlWriter.addLine(buffer, "\t<h2>Constants</h2>");
            HtmlWriter.addLine(buffer, "\t<table class=\"constants\">");
            HtmlWriter.addLine(buffer, "\t\t<tr>");
            HtmlWriter.addLine(buffer, "\t\t\t<th>Constant</th>");
            HtmlWriter.addLine(buffer, "\t\t\t<th>Description</th>");
            HtmlWriter.addLine(buffer, "\t\t</tr>");
            for (Field field : fields) {
                HtmlWriter.addLine(buffer, "\t\t<tr>");
                if (field.getComment().isEmpty()) {
                    this.getReporter().reportMissingDocs("Field documentation missing for " + this.fModule.getClassName() + "." + field.getName());
                }
                if (!field.isDeprecated()) {
                    HtmlWriter.addLine(buffer, " <td><a id=\"" + field.getName() + "\">" + field.getName() + "</a></td>");
                    HtmlWriter.addLine(buffer, " <td class=\"description\" data-field=\"" + field.getName() + "\">" + field.getComment() + "</td>");
                } else {
                    HtmlWriter.addLine(buffer, " <td><a id=\"" + field.getName() + "\" class=\"deprecatedText\">" + field.getName() + "</a></td>");
                    HtmlWriter.addLine(buffer, " <td class=\"description\" data-field=\"" + field.getName() + "\">");
                    HtmlWriter.addText(buffer, field.getComment());
                    String deprecationText = field.getDeprecationMessage();
                    if (deprecationText.isEmpty()) {
                        deprecationText = "This constant is deprecated and might be removed in future versions.";
                    }
                    HtmlWriter.addText(buffer, " <div class=\"warning\"><b>Deprecated:</b> <i>" + deprecationText + "</i></div>");
                    HtmlWriter.addLine(buffer, "</td>");
                }
                HtmlWriter.addLine(buffer, " </tr>");
            }
            HtmlWriter.addLine(buffer, "\t</table>");
            HtmlWriter.addLine(buffer, "");
        }
        return buffer;
    }

    private class Overview
    implements Comparable<Overview> {
        private final String fTitle;
        private final String fLinkID;
        private final Description fDescription;
        private final boolean fDeprecated;

        public Overview(String title, String linkID, Description description, boolean deprecated) {
            this.fTitle = title;
            this.fLinkID = linkID;
            this.fDescription = description;
            this.fDeprecated = deprecated;
        }

        @Override
        public int compareTo(Overview arg0) {
            return this.fTitle.compareTo(arg0.fTitle);
        }
    }
}

