/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.sunapi;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.ease.helpgenerator.model.AbstractClassModel;
import org.eclipse.ease.helpgenerator.model.Description;
import org.eclipse.ease.helpgenerator.model.ExceptionValue;
import org.eclipse.ease.helpgenerator.model.Field;
import org.eclipse.ease.helpgenerator.model.Method;
import org.eclipse.ease.helpgenerator.model.Parameter;
import org.eclipse.ease.helpgenerator.model.ReturnValue;
import org.eclipse.ease.helpgenerator.model.ScriptExample;

public class Java5ClassModel
extends AbstractClassModel {
    private static final String WRAP_TO_SCRIPT = "WrapToScript";
    private static final String QUALIFIED_WRAP_TO_SCRIPT = "org.eclipse.ease.modules.WrapToScript";
    private static final Object SCRIPT_PARAMETER = "ScriptParameter";
    private static final Object QUALIFIED_SCRIPT_PARAMETER = "org.eclipse.ease.modules." + SCRIPT_PARAMETER;
    private final ClassDoc fClassDoc;

    private static String getParameterComment(MethodDoc method, String name) {
        String comment = Java5ClassModel.extractComment(method, method1 -> {
            for (ParamTag paramTags : method1.paramTags()) {
                if (!name.equals(paramTags.parameterName())) continue;
                return paramTags.parameterComment();
            }
            return "";
        });
        return comment;
    }

    private static String getDefaultValue(com.sun.javadoc.Parameter param) {
        AnnotationDesc parameterAnnotation = Java5ClassModel.getScriptParameterAnnotation(param);
        if (parameterAnnotation != null) {
            for (AnnotationDesc.ElementValuePair pair : parameterAnnotation.elementValues()) {
                if (!"org.eclipse.ease.modules.ScriptParameter.defaultValue()".equals(pair.element().toString())) continue;
                return pair.value().toString();
            }
        }
        return null;
    }

    private static AnnotationDesc getScriptParameterAnnotation(com.sun.javadoc.Parameter parameter) {
        for (AnnotationDesc annotation : parameter.annotations()) {
            if (!Java5ClassModel.isScriptParameterAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    private static boolean isScriptParameterAnnotation(AnnotationDesc annotation) {
        return QUALIFIED_SCRIPT_PARAMETER.equals(annotation.annotationType().qualifiedName()) || SCRIPT_PARAMETER.equals(annotation.annotationType().qualifiedName());
    }

    private static String extractComment(MethodDoc method, CommentExtractor extractor) {
        String comment = extractor.extract(method);
        if (comment != null && !comment.isEmpty()) {
            return comment;
        }
        for (ClassDoc iface : method.containingClass().interfaces()) {
            for (MethodDoc ifaceMethod : iface.methods()) {
                if (!method.overrides(ifaceMethod) || (comment = Java5ClassModel.extractComment(ifaceMethod, extractor)) == null || comment.isEmpty()) continue;
                return comment;
            }
        }
        ClassDoc parent = method.containingClass().superclass();
        if (parent != null) {
            for (MethodDoc superMethod : parent.methods()) {
                if (!method.overrides(superMethod)) continue;
                return Java5ClassModel.extractComment(superMethod, extractor);
            }
        }
        return "";
    }

    private static AnnotationDesc getWrapAnnotation(ProgramElementDoc method) {
        for (AnnotationDesc annotation : method.annotations()) {
            if (!Java5ClassModel.isWrapToScriptAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    private static boolean isWrapToScriptAnnotation(AnnotationDesc annotation) {
        return QUALIFIED_WRAP_TO_SCRIPT.equals(annotation.annotationType().qualifiedName()) || WRAP_TO_SCRIPT.equals(annotation.annotationType().qualifiedName());
    }

    private static boolean isDeprecated(ProgramElementDoc field) {
        Tag[] tags = field.tags("deprecated");
        return tags != null && tags.length > 0;
    }

    private static Collection<String> getFunctionAliases(MethodDoc method) {
        HashSet<String> aliases = new HashSet<String>();
        AnnotationDesc annotation = Java5ClassModel.getWrapAnnotation((ProgramElementDoc)method);
        if (annotation != null) {
            for (AnnotationDesc.ElementValuePair pair : annotation.elementValues()) {
                if (!"alias".equals(pair.element().name())) continue;
                String candidates = pair.value().toString();
                candidates = candidates.substring(1, candidates.length() - 1);
                for (String token : candidates.split("[,;]")) {
                    if (token.trim().isEmpty()) continue;
                    aliases.add(token.trim());
                }
            }
        }
        return aliases;
    }

    public Java5ClassModel(ClassDoc classDoc) {
        this.fClassDoc = classDoc;
    }

    @Override
    public void populateModel() {
        this.setClassName(this.fClassDoc.name());
        this.setClassDocumentation(new Description(this.fClassDoc.commentText()));
        this.setDeprecationMessage(Java5ClassModel.isDeprecated((ProgramElementDoc)this.fClassDoc) ? this.fClassDoc.tags("deprecated")[0].text() : null);
        this.setExportedFields(this.fetchExportedFields());
        this.setExportedMethods(this.fetchExportedMethods());
        this.setImportedClasses(this.fetchImportedClasses());
    }

    private List<String> fetchImportedClasses() {
        try {
            return Arrays.asList(this.fClassDoc.importedClasses()).stream().map(f -> f.toString()).collect(Collectors.toList());
        }
        catch (NullPointerException e) {
            return Collections.emptyList();
        }
    }

    private List<Field> fetchExportedFields() {
        ArrayList<FieldDoc> fields = new ArrayList<FieldDoc>();
        boolean hasAnnotation = this.hasWrapToScriptAnnotation();
        ArrayList<ClassDoc> candidates = new ArrayList<ClassDoc>();
        candidates.add(this.fClassDoc);
        while (!candidates.isEmpty()) {
            ClassDoc clazzDoc = (ClassDoc)candidates.remove(0);
            for (FieldDoc field : clazzDoc.fields()) {
                if (hasAnnotation && Java5ClassModel.getWrapAnnotation((ProgramElementDoc)field) == null) continue;
                fields.add(field);
            }
            candidates.addAll(Arrays.asList(clazzDoc.interfaces()));
            ClassDoc nextCandidate = clazzDoc.superclass();
            if (nextCandidate == null || Object.class.getName().equals(nextCandidate.qualifiedName())) continue;
            candidates.add(nextCandidate);
        }
        return fields.stream().map(doc -> {
            String deprecationMessage = Java5ClassModel.isDeprecated((ProgramElementDoc)doc) ? doc.tags("deprecated")[0].text() : this.getDeprecationMessage();
            return new Field(doc.name(), doc.commentText(), deprecationMessage);
        }).collect(Collectors.toList());
    }

    private boolean hasWrapToScriptAnnotation() {
        for (ClassDoc classDoc = this.fClassDoc; classDoc != null; classDoc = classDoc.superclass()) {
            for (MethodDoc methodDoc : classDoc.methods()) {
                if (Java5ClassModel.getWrapAnnotation((ProgramElementDoc)methodDoc) == null) continue;
                return true;
            }
            for (MethodDoc methodDoc : classDoc.fields()) {
                if (Java5ClassModel.getWrapAnnotation((ProgramElementDoc)methodDoc) == null) continue;
                return true;
            }
        }
        return false;
    }

    private List<Method> fetchExportedMethods() {
        return new MethodExtractor().getMethods(this.fClassDoc, this.hasWrapToScriptAnnotation());
    }

    private String getExceptionComment(MethodDoc method, Type exceptionType) {
        String comment = Java5ClassModel.extractComment(method, method1 -> {
            for (ThrowsTag tag : method1.throwsTags()) {
                if (!exceptionType.simpleTypeName().equals(tag.exceptionName()) && !exceptionType.typeName().equals(tag.exceptionName())) continue;
                return tag.exceptionComment();
            }
            return "";
        });
        return comment;
    }

    private class MethodExtractor {
        private final List<Method> fMethods = new ArrayList<Method>();

        private MethodExtractor() {
        }

        private Method findRegisteredMethod(String methodName) {
            return this.fMethods.stream().filter(m -> methodName.equals(m.getName())).findFirst().orElse(null);
        }

        private void addMethod(Method method) {
            Method existingMethod = this.findRegisteredMethod(method.getName());
            if (existingMethod != null) {
                existingMethod.fetchDetailsFrom(method);
            } else {
                this.fMethods.add(method);
            }
        }

        public List<Method> getMethods(ClassDoc classDoc, boolean hasWrapToScriptAnnotation) {
            for (MethodDoc methodDoc : classDoc.methods()) {
                Method registeredMethod = this.findRegisteredMethod(methodDoc.name());
                AnnotationDesc wrapAnnotation = Java5ClassModel.getWrapAnnotation((ProgramElementDoc)methodDoc);
                if (hasWrapToScriptAnnotation && wrapAnnotation == null && registeredMethod == null || !methodDoc.isPublic()) continue;
                String deprecationMessage = Java5ClassModel.isDeprecated((ProgramElementDoc)methodDoc) ? methodDoc.tags("deprecated")[0].text() : Java5ClassModel.this.getDeprecationMessage();
                String returnComment = methodDoc.tags("return").length > 0 ? methodDoc.tags("return")[0].text() : null;
                ReturnValue returnValue = new ReturnValue(methodDoc.returnType().qualifiedTypeName(), returnComment);
                List<Parameter> parameters = Arrays.asList(methodDoc.parameters()).stream().map(param -> {
                    String defaultValue = Java5ClassModel.getDefaultValue(param);
                    return new Parameter(param.name(), param.typeName(), Java5ClassModel.getParameterComment(doc, param.name()), defaultValue);
                }).collect(Collectors.toList());
                List<ExceptionValue> exceptions = Arrays.asList(methodDoc.thrownExceptionTypes()).stream().map(e -> new ExceptionValue(e.qualifiedTypeName(), Java5ClassModel.this.getExceptionComment(doc, e))).collect(Collectors.toList());
                List<ScriptExample> examples = Arrays.asList(methodDoc.tags("scriptExample")).stream().map(example -> new ScriptExample(example.text())).collect(Collectors.toList());
                this.addMethod(new Method(methodDoc.name(), Java5ClassModel.extractComment(methodDoc, d -> d.commentText()), deprecationMessage, Java5ClassModel.getFunctionAliases(methodDoc), returnValue, parameters, exceptions, examples));
            }
            for (MethodDoc methodDoc : classDoc.interfaces()) {
                this.getMethods((ClassDoc)methodDoc, hasWrapToScriptAnnotation);
            }
            ClassDoc superclassDoc = classDoc.superclass();
            if (superclassDoc != null && !Object.class.getName().equals(superclassDoc.qualifiedName())) {
                this.getMethods(superclassDoc, hasWrapToScriptAnnotation);
            }
            return this.fMethods;
        }
    }

    private static interface CommentExtractor {
        public String extract(MethodDoc var1);
    }
}

