/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.dialogs;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.internal.ui.ContextHelp;
import org.eclipse.eclemma.internal.ui.RedGreenBar;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;

public class CoveragePropertyPage
extends PropertyPage {
    private static final NumberFormat COVERAGE_VALUE = new DecimalFormat(UIMessages.CoveragePropertyPageColumnCoverage_value);
    private static final NumberFormat COUNTER_VALUE = DecimalFormat.getIntegerInstance();

    protected Control createContents(Composite parent) {
        ContextHelp.setHelp((Control)parent, "org.eclipse.eclemma.ui.coverage_properties_context");
        this.noDefaultAndApplyButton();
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Label l1 = new Label(parent, 0);
        l1.setText(UIMessages.CoveragePropertyPageSession_label);
        l1.setLayoutData((Object)new GridData(16384, 128, false, false));
        Text t1 = new Text(parent, 72);
        t1.setText(this.getSessionDescription());
        t1.setLayoutData((Object)new GridData(16384, 128, true, false));
        t1.setBackground(t1.getDisplay().getSystemColor(22));
        Control table = this.createTable(parent);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        table.setLayoutData((Object)gd);
        return parent;
    }

    private String getSessionDescription() {
        ICoverageSession session = CoverageTools.getSessionManager().getActiveSession();
        return session == null ? UIMessages.CoveragePropertyPageNoSession_value : session.getDescription();
    }

    private Control createTable(Composite parent) {
        final Table table = new Table(parent, 2048);
        this.initializeDialogUnits((Control)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer viewer = new TableViewer(table);
        this.createColumn(viewer, 16384, 20, UIMessages.CoveragePropertyPageColumnCounter_label, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Line line = (Line)cell.getElement();
                cell.setText(line.label);
            }
        });
        this.createColumn(viewer, 131072, 20, UIMessages.CoveragePropertyPageColumnCoverage_label, (CellLabelProvider)new OwnerDrawLabelProvider(){

            public void update(ViewerCell cell) {
                Line line = (Line)cell.getElement();
                cell.setText(COVERAGE_VALUE.format(line.counter.getCoveredRatio()));
            }

            protected void paint(Event event, Object element) {
                Line line = (Line)element;
                RedGreenBar.draw(event, table.getColumn(1).getWidth(), line.counter);
            }

            protected void erase(Event event, Object element) {
            }

            protected void measure(Event event, Object element) {
            }
        });
        this.createColumn(viewer, 131072, 16, UIMessages.CoveragePropertyPageColumnCovered_label, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Line line = (Line)cell.getElement();
                cell.setText(COUNTER_VALUE.format(line.counter.getCoveredCount()));
            }
        });
        this.createColumn(viewer, 131072, 16, UIMessages.CoveragePropertyPageColumnMissed_label, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Line line = (Line)cell.getElement();
                cell.setText(COUNTER_VALUE.format(line.counter.getMissedCount()));
            }
        });
        this.createColumn(viewer, 131072, 16, UIMessages.CoveragePropertyPageColumnTotal_label, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Line line = (Line)cell.getElement();
                cell.setText(COUNTER_VALUE.format(line.counter.getTotalCount()));
            }
        });
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ((Line)element).counter.getTotalCount() != 0;
            }
        });
        viewer.setInput((Object)this.getLines());
        return table;
    }

    private void createColumn(TableViewer viewer, int align, int width, String caption, CellLabelProvider labelProvider) {
        TableViewerColumn column = new TableViewerColumn(viewer, align);
        column.getColumn().setText(caption);
        column.getColumn().setWidth(this.convertWidthInCharsToPixels(width));
        column.setLabelProvider(labelProvider);
    }

    private Line[] getLines() {
        ICoverageNode c = CoverageTools.getCoverageInfo((Object)this.getElement());
        if (c == null) {
            return new Line[0];
        }
        return new Line[]{new Line(UIMessages.CoveragePropertyPageInstructions_label, c.getInstructionCounter()), new Line(UIMessages.CoveragePropertyPageBranches_label, c.getBranchCounter()), new Line(UIMessages.CoveragePropertyPageLines_label, c.getLineCounter()), new Line(UIMessages.CoveragePropertyPageMethods_label, c.getMethodCounter()), new Line(UIMessages.CoveragePropertyPageTypes_label, c.getClassCounter()), new Line(UIMessages.CoveragePropertyPageComplexity_label, c.getComplexityCounter())};
    }

    private static class Line {
        public final String label;
        public final ICounter counter;

        public Line(String label, ICounter counter) {
            this.label = label;
            this.counter = counter;
        }
    }
}

