/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.annotation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.analysis.IJavaCoverageListener;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.annotation.CoverageAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceNode;

public final class CoverageAnnotationModel
implements IAnnotationModel {
    private static final Object KEY = new Object();
    private List<CoverageAnnotation> annotations = new ArrayList<CoverageAnnotation>(32);
    private List<IAnnotationModelListener> annotationModelListeners = new ArrayList<IAnnotationModelListener>(2);
    private final ITextEditor editor;
    private final IDocument document;
    private int openConnections = 0;
    private boolean annotated = false;
    private IJavaCoverageListener coverageListener = new IJavaCoverageListener(){

        public void coverageChanged() {
            CoverageAnnotationModel.this.updateAnnotations(true);
        }
    };
    private IDocumentListener documentListener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            CoverageAnnotationModel.this.updateAnnotations(false);
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };

    private CoverageAnnotationModel(ITextEditor editor, IDocument document) {
        this.editor = editor;
        this.document = document;
        this.updateAnnotations(true);
    }

    public static void attach(ITextEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return;
        }
        IAnnotationModel model = provider.getAnnotationModel((Object)editor.getEditorInput());
        if (!(model instanceof IAnnotationModelExtension)) {
            return;
        }
        IAnnotationModelExtension modelex = (IAnnotationModelExtension)model;
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        CoverageAnnotationModel coveragemodel = (CoverageAnnotationModel)modelex.getAnnotationModel(KEY);
        if (coveragemodel == null) {
            coveragemodel = new CoverageAnnotationModel(editor, document);
            modelex.addAnnotationModel(KEY, (IAnnotationModel)coveragemodel);
        }
    }

    public static void detach(ITextEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return;
        }
        IAnnotationModel model = provider.getAnnotationModel((Object)editor.getEditorInput());
        if (!(model instanceof IAnnotationModelExtension)) {
            return;
        }
        IAnnotationModelExtension modelex = (IAnnotationModelExtension)model;
        modelex.removeAnnotationModel(KEY);
    }

    private void updateAnnotations(boolean force) {
        ISourceNode coverage = this.findSourceCoverageForEditor();
        if (coverage != null) {
            if (!this.annotated || force) {
                this.createAnnotations(coverage);
                this.annotated = true;
            }
        } else if (this.annotated) {
            this.clear();
            this.annotated = false;
        }
    }

    private ISourceNode findSourceCoverageForEditor() {
        if (this.editor.isDirty()) {
            return null;
        }
        IEditorInput input = this.editor.getEditorInput();
        if (input == null) {
            return null;
        }
        Object element = input.getAdapter(IJavaElement.class);
        if (!this.hasSource((IJavaElement)element)) {
            return null;
        }
        return this.findSourceCoverageForElement(element);
    }

    private boolean hasSource(IJavaElement element) {
        if (element instanceof ISourceReference) {
            try {
                return ((ISourceReference)element).getSourceRange() != null;
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }

    private ISourceNode findSourceCoverageForElement(Object element) {
        ICoverageNode coverage = CoverageTools.getCoverageInfo((Object)element);
        if (coverage instanceof ISourceNode) {
            return (ISourceNode)coverage;
        }
        return null;
    }

    private void clear() {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        this.fireModelChanged(event);
    }

    private void clear(AnnotationModelEvent event) {
        for (CoverageAnnotation ca : this.annotations) {
            event.annotationRemoved((Annotation)ca, ca.getPosition());
        }
        this.annotations.clear();
    }

    private void createAnnotations(ISourceNode linecoverage) {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        int firstline = linecoverage.getFirstLine();
        int lastline = Math.min(linecoverage.getLastLine(), this.document.getNumberOfLines());
        try {
            int l = firstline;
            while (l <= lastline) {
                ILine line = linecoverage.getLine(l);
                if (line.getStatus() != 0) {
                    IRegion region = this.document.getLineInformation(l - 1);
                    CoverageAnnotation ca = new CoverageAnnotation(region.getOffset(), region.getLength(), line);
                    this.annotations.add(ca);
                    event.annotationAdded((Annotation)ca);
                }
                ++l;
            }
        }
        catch (BadLocationException ex) {
            EclEmmaUIPlugin.log(ex);
        }
        this.fireModelChanged(event);
    }

    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        if (!this.annotationModelListeners.contains(listener)) {
            this.annotationModelListeners.add(listener);
            this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this, true));
        }
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        this.annotationModelListeners.remove(listener);
    }

    private void fireModelChanged(AnnotationModelEvent event) {
        event.markSealed();
        if (!event.isEmpty()) {
            for (IAnnotationModelListener l : this.annotationModelListeners) {
                if (l instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)l).modelChanged(event);
                    continue;
                }
                l.modelChanged((IAnnotationModel)this);
            }
        }
    }

    public void connect(IDocument document) {
        if (this.document != document) {
            throw new IllegalArgumentException("Can't connect to different document.");
        }
        for (CoverageAnnotation ca : this.annotations) {
            try {
                document.addPosition(ca.getPosition());
            }
            catch (BadLocationException ex) {
                EclEmmaUIPlugin.log(ex);
            }
        }
        if (this.openConnections++ == 0) {
            CoverageTools.addJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
            document.addDocumentListener(this.documentListener);
        }
    }

    public void disconnect(IDocument document) {
        if (this.document != document) {
            throw new IllegalArgumentException("Can't disconnect from different document.");
        }
        for (CoverageAnnotation ca : this.annotations) {
            document.removePosition(ca.getPosition());
        }
        if (--this.openConnections == 0) {
            CoverageTools.removeJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
            document.removeDocumentListener(this.documentListener);
        }
    }

    public void addAnnotation(Annotation annotation, Position position) {
        throw new UnsupportedOperationException();
    }

    public void removeAnnotation(Annotation annotation) {
        throw new UnsupportedOperationException();
    }

    public Iterator getAnnotationIterator() {
        return this.annotations.iterator();
    }

    public Position getPosition(Annotation annotation) {
        if (annotation instanceof CoverageAnnotation) {
            return ((CoverageAnnotation)annotation).getPosition();
        }
        return null;
    }
}

