/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.internal.analysis.CounterImpl;
import org.jacoco.core.internal.analysis.MethodCoverageImpl;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.flow.IFrame;
import org.jacoco.core.internal.flow.Instruction;
import org.jacoco.core.internal.flow.LabelInfo;
import org.jacoco.core.internal.flow.MethodProbesVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class MethodAnalyzer
extends MethodProbesVisitor
implements IFilterOutput {
    private final String className;
    private final String superClassName;
    private final boolean[] probes;
    private final IFilter filter;
    private final MethodCoverageImpl coverage;
    private int currentLine = -1;
    private int firstLine = -1;
    private int lastLine = -1;
    private final List<Label> currentLabel = new ArrayList<Label>(2);
    private final List<Instruction> instructions = new ArrayList<Instruction>();
    private final List<CoveredProbe> coveredProbes = new ArrayList<CoveredProbe>();
    private final List<Jump> jumps = new ArrayList<Jump>();
    private Instruction lastInsn;
    private final Set<AbstractInsnNode> ignored = new HashSet<AbstractInsnNode>();
    private final Map<AbstractInsnNode, AbstractInsnNode> merged = new HashMap<AbstractInsnNode, AbstractInsnNode>();
    private final Map<AbstractInsnNode, Instruction> nodeToInstruction = new HashMap<AbstractInsnNode, Instruction>();
    private AbstractInsnNode currentNode;

    MethodAnalyzer(String className, String superClassName, String name, String desc, String signature, boolean[] probes, IFilter filter) {
        this.className = className;
        this.superClassName = superClassName;
        this.probes = probes;
        this.filter = filter;
        this.coverage = new MethodCoverageImpl(name, desc, signature);
    }

    public IMethodCoverage getCoverage() {
        return this.coverage;
    }

    public void accept(MethodNode methodNode, MethodVisitor methodVisitor) {
        this.filter.filter(this.className, this.superClassName, methodNode, this);
        methodVisitor.visitCode();
        for (TryCatchBlockNode n : methodNode.tryCatchBlocks) {
            n.accept(methodVisitor);
        }
        this.currentNode = methodNode.instructions.getFirst();
        while (this.currentNode != null) {
            this.currentNode.accept(methodVisitor);
            this.currentNode = this.currentNode.getNext();
        }
        methodVisitor.visitEnd();
    }

    public void ignore(AbstractInsnNode fromInclusive, AbstractInsnNode toInclusive) {
        for (AbstractInsnNode i = fromInclusive; i != toInclusive; i = i.getNext()) {
            this.ignored.add(i);
        }
        this.ignored.add(toInclusive);
    }

    private AbstractInsnNode findRepresentative(AbstractInsnNode i) {
        AbstractInsnNode r = this.merged.get(i);
        while (r != null) {
            i = r;
            r = this.merged.get(i);
        }
        return i;
    }

    public void merge(AbstractInsnNode i1, AbstractInsnNode i2) {
        if ((i1 = this.findRepresentative(i1)) != (i2 = this.findRepresentative(i2))) {
            this.merged.put(i2, i1);
        }
    }

    public void visitLabel(Label label) {
        this.currentLabel.add(label);
        if (!LabelInfo.isSuccessor(label)) {
            this.lastInsn = null;
        }
    }

    public void visitLineNumber(int line, Label start) {
        this.currentLine = line;
        if (this.firstLine > line || this.lastLine == -1) {
            this.firstLine = line;
        }
        if (this.lastLine < line) {
            this.lastLine = line;
        }
    }

    private void visitInsn() {
        int labelCount;
        Instruction insn = new Instruction(this.currentNode, this.currentLine);
        this.nodeToInstruction.put(this.currentNode, insn);
        this.instructions.add(insn);
        if (this.lastInsn != null) {
            insn.setPredecessor(this.lastInsn, 0);
        }
        if ((labelCount = this.currentLabel.size()) > 0) {
            int i = labelCount;
            while (--i >= 0) {
                LabelInfo.setInstruction(this.currentLabel.get(i), insn);
            }
            this.currentLabel.clear();
        }
        this.lastInsn = insn;
    }

    public void visitInsn(int opcode) {
        this.visitInsn();
    }

    public void visitIntInsn(int opcode, int operand) {
        this.visitInsn();
    }

    public void visitVarInsn(int opcode, int var) {
        this.visitInsn();
    }

    public void visitTypeInsn(int opcode, String type) {
        this.visitInsn();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.visitInsn();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.visitInsn();
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.visitInsn();
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.visitInsn();
        this.jumps.add(new Jump(this.lastInsn, label, 1));
    }

    public void visitLdcInsn(Object cst) {
        this.visitInsn();
    }

    public void visitIincInsn(int var, int increment) {
        this.visitInsn();
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.visitSwitchInsn(dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.visitSwitchInsn(dflt, labels);
    }

    private void visitSwitchInsn(Label dflt, Label[] labels) {
        this.visitInsn();
        LabelInfo.resetDone(labels);
        int branch = 0;
        this.jumps.add(new Jump(this.lastInsn, dflt, branch));
        LabelInfo.setDone(dflt);
        for (Label l : labels) {
            if (LabelInfo.isDone(l)) continue;
            this.jumps.add(new Jump(this.lastInsn, l, ++branch));
            LabelInfo.setDone(l);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.visitInsn();
    }

    public void visitProbe(int probeId) {
        this.addProbe(probeId, 0);
        this.lastInsn = null;
    }

    public void visitJumpInsnWithProbe(int opcode, Label label, int probeId, IFrame frame) {
        this.visitInsn();
        this.addProbe(probeId, 1);
    }

    public void visitInsnWithProbe(int opcode, int probeId) {
        this.visitInsn();
        this.addProbe(probeId, 0);
    }

    public void visitTableSwitchInsnWithProbes(int min, int max, Label dflt, Label[] labels, IFrame frame) {
        this.visitSwitchInsnWithProbes(dflt, labels);
    }

    public void visitLookupSwitchInsnWithProbes(Label dflt, int[] keys, Label[] labels, IFrame frame) {
        this.visitSwitchInsnWithProbes(dflt, labels);
    }

    private void visitSwitchInsnWithProbes(Label dflt, Label[] labels) {
        this.visitInsn();
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        int branch = 0;
        this.visitSwitchTarget(dflt, branch);
        for (Label l : labels) {
            this.visitSwitchTarget(l, ++branch);
        }
    }

    private void visitSwitchTarget(Label label, int branch) {
        int id = LabelInfo.getProbeId(label);
        if (!LabelInfo.isDone(label)) {
            if (id == -1) {
                this.jumps.add(new Jump(this.lastInsn, label, branch));
            } else {
                this.addProbe(id, branch);
            }
            LabelInfo.setDone(label);
        }
    }

    public void visitEnd() {
        for (Jump j : this.jumps) {
            LabelInfo.getInstruction(j.target).setPredecessor(j.source, j.branch);
        }
        for (CoveredProbe p : this.coveredProbes) {
            p.instruction.setCovered(p.branch);
        }
        for (Instruction i : this.instructions) {
            AbstractInsnNode m = i.getNode();
            AbstractInsnNode r = this.findRepresentative(m);
            if (r == m) continue;
            this.ignored.add(m);
            this.nodeToInstruction.get(r).merge(i);
        }
        this.coverage.ensureCapacity(this.firstLine, this.lastLine);
        for (Instruction i : this.instructions) {
            if (this.ignored.contains(i.getNode())) continue;
            int total = i.getBranches();
            int covered = i.getCoveredBranches();
            CounterImpl instrCounter = covered == 0 ? CounterImpl.COUNTER_1_0 : CounterImpl.COUNTER_0_1;
            CounterImpl branchCounter = total > 1 ? CounterImpl.getInstance(total - covered, covered) : CounterImpl.COUNTER_0_0;
            this.coverage.increment(instrCounter, branchCounter, i.getLine());
        }
        this.coverage.incrementMethodCounter();
    }

    private void addProbe(int probeId, int branch) {
        this.lastInsn.addBranch();
        if (this.probes != null && this.probes[probeId]) {
            this.coveredProbes.add(new CoveredProbe(this.lastInsn, branch));
        }
    }

    private static class CoveredProbe {
        final Instruction instruction;
        final int branch;

        private CoveredProbe(Instruction instruction, int branch) {
            this.instruction = instruction;
            this.branch = branch;
        }
    }

    private static class Jump {
        final Instruction source;
        final Label target;
        final int branch;

        Jump(Instruction source, Label target, int branch) {
            this.source = source;
            this.target = target;
            this.branch = branch;
        }
    }
}

