/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.handlers;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.internal.ui.ContextHelp;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.handlers.AbstractSessionManagerHandler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class SelectActiveSessionHandler
extends AbstractSessionManagerHandler {
    public SelectActiveSessionHandler() {
        super(CoverageTools.getSessionManager());
    }

    public boolean isEnabled() {
        return !this.sessionManager.getSessions().isEmpty();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] result;
        ListDialog dialog = new ListDialog(HandlerUtil.getActiveShell((ExecutionEvent)event)){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                ContextHelp.setHelp((Control)shell, "org.eclipse.eclemma.ui.select_active_session_context");
            }
        };
        dialog.setTitle(UIMessages.SelectActiveSessionDialog_title);
        dialog.setMessage(UIMessages.SelectActiveSessionDialog_message);
        dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ICoverageSession)element).getDescription();
            }

            public Image getImage(Object element) {
                return EclEmmaUIPlugin.getImage("icons/full/elcl16/session.png");
            }
        });
        dialog.setInitialElementSelections(Collections.singletonList(this.sessionManager.getActiveSession()));
        dialog.setInput((Object)this.sessionManager.getSessions());
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.sessionManager.activateSession((ICoverageSession)result[0]);
        }
        return null;
    }
}

